/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.client.mgcp.parser.params;

import jain.protocol.ip.mgcp.message.parms.Bandwidth;
import jain.protocol.ip.mgcp.message.parms.CompressionAlgorithm;
import jain.protocol.ip.mgcp.message.parms.EchoCancellation;
import jain.protocol.ip.mgcp.message.parms.EncryptionMethod;
import jain.protocol.ip.mgcp.message.parms.GainControl;
import jain.protocol.ip.mgcp.message.parms.LocalOptionExtension;
import jain.protocol.ip.mgcp.message.parms.LocalOptionValue;
import jain.protocol.ip.mgcp.message.parms.PacketizationPeriod;
import jain.protocol.ip.mgcp.message.parms.ResourceReservation;
import jain.protocol.ip.mgcp.message.parms.SilenceSuppression;
import jain.protocol.ip.mgcp.message.parms.TypeOfNetwork;
import jain.protocol.ip.mgcp.message.parms.TypeOfService;
import java.text.ParseException;
import org.restcomm.media.client.mgcp.parser.SplitDetails;
import org.restcomm.media.client.mgcp.parser.StringFunctions;
import org.restcomm.media.client.mgcp.parser.params.BandwidthHandler;
import org.restcomm.media.client.mgcp.parser.params.CompressionAlgorithmHandler;
import org.restcomm.media.client.mgcp.parser.params.EchoCancellationHandler;
import org.restcomm.media.client.mgcp.parser.params.EncryptionMethodHandler;
import org.restcomm.media.client.mgcp.parser.params.GainControlHandler;
import org.restcomm.media.client.mgcp.parser.params.PacketizationPeriodHandler;
import org.restcomm.media.client.mgcp.parser.params.ResourceReservationHandler;
import org.restcomm.media.client.mgcp.parser.params.SilenceSuppressionHandler;
import org.restcomm.media.client.mgcp.parser.params.TypeOfNetworkHandler;
import org.restcomm.media.client.mgcp.parser.params.TypeOfServiceHandler;

public class LocalOptionValueHandler {
    public static LocalOptionValue decode(byte[] value, int offset, int length) throws ParseException {
        if (length > 1 && value[offset + 1] == 58) {
            switch (value[offset]) {
                case 65: 
                case 97: {
                    return CompressionAlgorithmHandler.decode(value, offset + 2, length - 2);
                }
                case 66: 
                case 98: {
                    return BandwidthHandler.decode(value, offset + 2, length - 2);
                }
                case 69: 
                case 101: {
                    return EchoCancellationHandler.decode(value, offset + 2, length - 2);
                }
                case 75: 
                case 107: {
                    return EncryptionMethodHandler.decode(value, offset + 2, length - 2);
                }
                case 80: 
                case 112: {
                    return PacketizationPeriodHandler.decode(value, offset + 2, length - 2);
                }
                case 82: 
                case 114: {
                    return ResourceReservationHandler.decode(value, offset + 2, length - 2);
                }
                case 83: 
                case 115: {
                    return SilenceSuppressionHandler.decode(value, offset + 2, length - 2);
                }
                case 84: 
                case 116: {
                    return TypeOfServiceHandler.decode(value, offset + 2, length - 2);
                }
            }
        } else if (length > 2 && value[offset + 2] == 58) {
            switch (value[offset]) {
                case 78: 
                case 110: {
                    if (value[offset + 1] == 116 || value[offset + 1] == 84) {
                        return TypeOfNetworkHandler.decode(value, offset + 3, length - 3);
                    }
                }
                case 71: 
                case 103: {
                    if (value[offset + 1] != 99 && value[offset + 1] != 67) break;
                    return GainControlHandler.decode(value, offset + 3, length - 3);
                }
            }
        }
        for (int i = 3; i < length; ++i) {
            if (value[offset + i] != 58) continue;
            return new LocalOptionExtension(new String(value, offset, i), new String(value, offset + i + 1, length - i - 1));
        }
        throw new ParseException("Could not parse local connection option: " + new String(value, offset, length), 0);
    }

    public static int encode(byte[] destination, int offset, LocalOptionValue localOptionValue) {
        switch (localOptionValue.getLocalOptionValueType()) {
            case 3: {
                destination[offset] = 98;
                destination[offset + 1] = 58;
                return BandwidthHandler.encode(destination, offset + 2, (Bandwidth)localOptionValue) + 2;
            }
            case 2: {
                destination[offset] = 97;
                destination[offset + 1] = 58;
                return CompressionAlgorithmHandler.encode(destination, offset + 2, (CompressionAlgorithm)localOptionValue) + 2;
            }
            case 4: {
                destination[offset] = 101;
                destination[offset + 1] = 58;
                return EchoCancellationHandler.encode(destination, offset + 2, (EchoCancellation)localOptionValue) + 2;
            }
            case 10: {
                destination[offset] = 107;
                destination[offset + 1] = 58;
                return EncryptionMethodHandler.encode(destination, offset + 2, (EncryptionMethod)localOptionValue) + 2;
            }
            case 1: {
                destination[offset] = 112;
                destination[offset + 1] = 58;
                return PacketizationPeriodHandler.encode(destination, offset + 2, (PacketizationPeriod)localOptionValue) + 2;
            }
            case 8: {
                destination[offset] = 114;
                destination[offset + 1] = 58;
                return ResourceReservationHandler.encode(destination, offset + 2, (ResourceReservation)localOptionValue) + 2;
            }
            case 5: {
                destination[offset] = 115;
                destination[offset + 1] = 58;
                return SilenceSuppressionHandler.encode(destination, offset + 2, (SilenceSuppression)localOptionValue) + 2;
            }
            case 7: {
                destination[offset] = 116;
                destination[offset + 1] = 58;
                return TypeOfServiceHandler.encode(destination, offset + 2, (TypeOfService)localOptionValue) + 2;
            }
            case 9: {
                destination[offset] = 110;
                destination[offset + 1] = 116;
                destination[offset + 2] = 58;
                return TypeOfNetworkHandler.encode(destination, offset + 3, (TypeOfNetwork)localOptionValue) + 3;
            }
            case 6: {
                destination[offset] = 103;
                destination[offset + 1] = 99;
                destination[offset + 2] = 58;
                return GainControlHandler.encode(destination, offset + 3, (GainControl)localOptionValue) + 3;
            }
            case 11: {
                LocalOptionExtension localOptionExtension = (LocalOptionExtension)localOptionValue;
                byte[] name = localOptionExtension.getLocalOptionExtensionName().getBytes();
                byte[] value = localOptionExtension.getLocalOptionExtensionValue().getBytes();
                System.arraycopy(name, 0, destination, offset, name.length);
                destination[offset + name.length] = 58;
                System.arraycopy(value, 0, destination, offset + name.length + 1, value.length);
                return name.length + value.length + 1;
            }
        }
        return 0;
    }

    public static int encodeList(byte[] destination, int offset, LocalOptionValue[] optionsList) {
        int i;
        if (optionsList.length == 0) {
            return 0;
        }
        int totalLength = 0;
        for (i = 0; i < optionsList.length - 1; ++i) {
            totalLength += LocalOptionValueHandler.encode(destination, offset + totalLength, optionsList[i]);
            destination[offset + totalLength] = 44;
            ++totalLength;
        }
        totalLength += LocalOptionValueHandler.encode(destination, offset + totalLength, optionsList[i]);
        return totalLength;
    }

    public static LocalOptionValue[] decodeList(byte[] value, int offset, int length) throws ParseException {
        SplitDetails[] splitDetails = StringFunctions.split(value, offset, length, (byte)44);
        LocalOptionValue[] options = new LocalOptionValue[splitDetails.length];
        for (int i = 0; i < splitDetails.length; ++i) {
            options[i] = LocalOptionValueHandler.decode(value, splitDetails[i].getOffset(), splitDetails[i].getLength());
        }
        return options;
    }
}

