/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.client.mgcp.parser.commands;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.RestartInProgress;
import jain.protocol.ip.mgcp.message.RestartInProgressResponse;
import jain.protocol.ip.mgcp.message.parms.NotifiedEntity;
import jain.protocol.ip.mgcp.message.parms.RestartMethod;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import java.io.IOException;
import java.net.InetAddress;
import java.text.ParseException;
import org.apache.log4j.Logger;
import org.restcomm.media.client.mgcp.handlers.MgcpContentHandler;
import org.restcomm.media.client.mgcp.handlers.TransactionHandler;
import org.restcomm.media.client.mgcp.parser.SplitDetails;
import org.restcomm.media.client.mgcp.parser.StringFunctions;
import org.restcomm.media.client.mgcp.parser.params.EndpointIdentifierHandler;
import org.restcomm.media.client.mgcp.parser.params.NotifiedEntityHandler;
import org.restcomm.media.client.mgcp.parser.params.ReasonCodeHandler;
import org.restcomm.media.client.mgcp.parser.params.RestartMethodHandler;
import org.restcomm.media.client.mgcp.parser.params.ReturnCodeHandler;
import org.restcomm.media.client.mgcp.stack.JainMgcpStackImpl;

public class RestartInProgressHandler
extends TransactionHandler {
    public static final byte[] COMMAND_NAME = new byte[]{82, 83, 73, 80};
    private static final Logger logger = Logger.getLogger(RestartInProgressHandler.class);
    private RestartInProgress command;
    private RestartInProgressResponse response;

    public RestartInProgressHandler(JainMgcpStackImpl stack) {
        super(stack);
    }

    public RestartInProgressHandler(JainMgcpStackImpl stack, InetAddress address, int port) {
        super(stack, address, port);
    }

    @Override
    public JainMgcpCommandEvent decodeCommand(byte[] data, SplitDetails[] message) throws ParseException {
        this.command = new RestartInProgress(this.source != null ? this.source : this.stack, this.endpoint, RestartMethod.Restart);
        this.command.setTransactionHandle(this.remoteTID);
        try {
            new CommandContentHandle().parse(data, message);
        }
        catch (Exception e) {
            throw new ParseException(e.getMessage(), -1);
        }
        return this.command;
    }

    @Override
    public JainMgcpResponseEvent decodeResponse(byte[] data, SplitDetails[] msg, Integer txID, ReturnCode returnCode) throws ParseException {
        this.response = new RestartInProgressResponse(this.source != null ? this.source : this.stack, returnCode);
        this.response.setTransactionHandle(txID.intValue());
        try {
            new ResponseContentHandle().parse(data, msg);
        }
        catch (IOException e) {
            // empty catch block
        }
        return this.response;
    }

    @Override
    public int encode(JainMgcpCommandEvent event, byte[] array) {
        RestartInProgress rsip = (RestartInProgress)event;
        int totalLength = 5;
        System.arraycopy(COMMAND_NAME, 0, array, 0, 4);
        array[4] = 32;
        totalLength += StringFunctions.encodeInt(array, 5, event.getTransactionHandle());
        array[totalLength++] = 32;
        totalLength += EndpointIdentifierHandler.encode(array, totalLength, rsip.getEndpointIdentifier());
        array[totalLength++] = 32;
        System.arraycopy(MGCP_VERSION, 0, array, totalLength, MGCP_VERSION.length);
        totalLength += MGCP_VERSION.length;
        array[totalLength++] = 10;
        array[totalLength++] = 82;
        array[totalLength++] = 77;
        array[totalLength++] = 58;
        totalLength += RestartMethodHandler.encode(array, totalLength, rsip.getRestartMethod());
        array[totalLength++] = 10;
        if (rsip.getRestartDelay() != 0) {
            array[totalLength++] = 82;
            array[totalLength++] = 68;
            array[totalLength++] = 58;
            totalLength += StringFunctions.encodeInt(array, totalLength, rsip.getRestartDelay());
            array[totalLength++] = 10;
        }
        if (rsip.getReasonCode() != null) {
            array[totalLength++] = 69;
            array[totalLength++] = 58;
            totalLength += ReasonCodeHandler.encode(array, totalLength, rsip.getReasonCode());
            array[totalLength++] = 10;
        }
        return totalLength;
    }

    @Override
    public int encode(JainMgcpResponseEvent event, byte[] array) {
        RestartInProgressResponse response = (RestartInProgressResponse)event;
        ReturnCode returnCode = response.getReturnCode();
        int totalLength = ReturnCodeHandler.encode(array, 0, returnCode);
        array[totalLength++] = 32;
        totalLength += StringFunctions.encodeInt(array, totalLength, response.getTransactionHandle());
        array[totalLength++] = 32;
        byte[] commentBytes = returnCode.getComment().getBytes();
        System.arraycopy(commentBytes, 0, array, totalLength, commentBytes.length);
        totalLength += commentBytes.length;
        array[totalLength++] = 10;
        if (response.getNotifiedEntity() != null) {
            array[totalLength++] = 78;
            array[totalLength++] = 58;
            totalLength += NotifiedEntityHandler.encode(array, totalLength, response.getNotifiedEntity());
            array[totalLength++] = 10;
        }
        return totalLength;
    }

    @Override
    public JainMgcpResponseEvent getProvisionalResponse() {
        RestartInProgressResponse provisionalResponse = null;
        if (!this.sent) {
            provisionalResponse = new RestartInProgressResponse(this.source != null ? this.source : this.stack, ReturnCode.Transaction_Being_Executed);
            provisionalResponse.setTransactionHandle(this.remoteTID);
        }
        return provisionalResponse;
    }

    private class ResponseContentHandle
    extends MgcpContentHandler {
        @Override
        public void param(byte[] data, SplitDetails name, SplitDetails value) throws ParseException {
            if (name.getLength() == 1) {
                switch (data[name.getOffset()]) {
                    case 78: 
                    case 110: {
                        NotifiedEntity n = NotifiedEntityHandler.decode(data, value.getOffset(), value.getLength(), true);
                        RestartInProgressHandler.this.response.setNotifiedEntity(n);
                        break;
                    }
                    default: {
                        logger.warn((Object)("Unidentified RSIP Response parameter " + new String(data, name.getOffset(), name.getLength()) + " with value = " + new String(data, value.getOffset(), value.getLength())));
                        break;
                    }
                }
            } else {
                logger.warn((Object)("Unidentified RSIP Response parameter " + new String(data, name.getOffset(), name.getLength()) + " with value = " + new String(data, value.getOffset(), value.getLength())));
            }
        }

        @Override
        public void sessionDescription(String sd) throws ParseException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private class CommandContentHandle
    extends MgcpContentHandler {
        @Override
        public void param(byte[] data, SplitDetails name, SplitDetails value) throws ParseException {
            if (name.getLength() == 1) {
                switch (data[name.getOffset()]) {
                    case 69: 
                    case 101: {
                        RestartInProgressHandler.this.command.setReasonCode(ReasonCodeHandler.decode(data, value.getOffset(), value.getLength()));
                        break;
                    }
                    default: {
                        logger.warn((Object)("Unidentified RSIP Request parameter " + new String(data, name.getOffset(), name.getLength()) + " with value = " + new String(data, value.getOffset(), value.getLength())));
                        break;
                    }
                }
            } else if (name.getLength() == 2) {
                switch (data[name.getOffset() + 1]) {
                    case 77: 
                    case 109: {
                        if (data[name.getOffset()] == 114 || data[name.getOffset()] == 82) {
                            RestartInProgressHandler.this.command.setRestartMethod(RestartMethodHandler.decode(data, value.getOffset(), value.getLength()));
                            break;
                        }
                        logger.warn((Object)("Unidentified RSIP Request parameter " + new String(data, name.getOffset(), name.getLength()) + " with value = " + new String(data, value.getOffset(), value.getLength())));
                        break;
                    }
                    case 68: 
                    case 100: {
                        if (data[name.getOffset()] == 114 || data[name.getOffset()] == 82) {
                            Integer restartDelay = new Integer(0);
                            int currIndex = value.getOffset();
                            int j = 0;
                            while (j < value.getLength()) {
                                if (data[currIndex] < 48 || data[currIndex] > 57) {
                                    throw new ParseException("Invalid restart delay:" + new String(data, value.getOffset(), value.getLength()), 0);
                                }
                                restartDelay = restartDelay * 10 + (data[currIndex] - 48);
                                ++j;
                                ++currIndex;
                            }
                            RestartInProgressHandler.this.command.setRestartDelay(restartDelay.intValue());
                            break;
                        }
                        logger.warn((Object)("Unidentified RSIP Request parameter " + new String(data, name.getOffset(), name.getLength()) + " with value = " + new String(data, value.getOffset(), value.getLength())));
                        break;
                    }
                    default: {
                        logger.warn((Object)("Unidentified RSIP Request parameter " + new String(data, name.getOffset(), name.getLength()) + " with value = " + new String(data, value.getOffset(), value.getLength())));
                        break;
                    }
                }
            } else {
                logger.warn((Object)("Unidentified RSIP Request parameter " + new String(data, name.getOffset(), name.getLength()) + " with value = " + new String(data, value.getOffset(), value.getLength())));
            }
        }

        @Override
        public void sessionDescription(String sd) throws ParseException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

