/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.client.mgcp.parser.params;

import jain.protocol.ip.mgcp.message.parms.InfoCode;
import java.text.ParseException;
import org.restcomm.media.client.mgcp.parser.SplitDetails;
import org.restcomm.media.client.mgcp.parser.StringFunctions;

public class InfoCodeHandler {
    public static InfoCode decode(byte[] value, int offset, int length) throws ParseException {
        int startIndex = offset;
        int newLength = length;
        for (int i = 0; i < length; ++i) {
            if (value[offset + i] != 32) continue;
            ++startIndex;
            --newLength;
        }
        int finalLength = newLength;
        for (int i = 0; i < newLength; ++i) {
            if (value[offset + length - i - 1] != 32) continue;
            --finalLength;
        }
        if (finalLength == 1) {
            switch (value[startIndex]) {
                case 66: 
                case 98: {
                    return InfoCode.BearerInformation;
                }
                case 67: 
                case 99: {
                    return InfoCode.CallIdentifier;
                }
                case 73: 
                case 105: {
                    return InfoCode.ConnectionIdentifier;
                }
                case 78: 
                case 110: {
                    return InfoCode.NotifiedEntity;
                }
                case 88: 
                case 120: {
                    return InfoCode.RequestIdentifier;
                }
                case 76: 
                case 108: {
                    return InfoCode.LocalConnectionOptions;
                }
                case 77: 
                case 109: {
                    return InfoCode.ConnectionMode;
                }
                case 82: 
                case 114: {
                    return InfoCode.RequestedEvents;
                }
                case 83: 
                case 115: {
                    return InfoCode.SignalRequests;
                }
                case 68: 
                case 100: {
                    return InfoCode.DigitMap;
                }
                case 79: 
                case 111: {
                    return InfoCode.ObservedEvents;
                }
                case 80: 
                case 112: {
                    return InfoCode.ConnectionParameters;
                }
                case 69: 
                case 101: {
                    return InfoCode.ReasonCode;
                }
                case 90: 
                case 122: {
                    return InfoCode.SpecificEndpointID;
                }
                case 81: 
                case 113: {
                    return InfoCode.QuarantineHandling;
                }
                case 84: 
                case 116: {
                    return InfoCode.DetectEvents;
                }
                case 65: 
                case 97: {
                    return InfoCode.Capabilities;
                }
            }
        } else if (finalLength == 2) {
            switch (value[startIndex]) {
                case 76: 
                case 108: {
                    if (value[startIndex + 1] == 99 || value[startIndex + 1] == 67) {
                        return InfoCode.LocalConnectionDescriptor;
                    }
                }
                case 69: 
                case 101: {
                    if (value[startIndex + 1] == 115 || value[startIndex + 1] == 83) {
                        return InfoCode.EventStates;
                    }
                }
                case 82: 
                case 114: {
                    switch (value[startIndex + 1]) {
                        case 67: 
                        case 99: {
                            return InfoCode.RemoteConnectionDescriptor;
                        }
                        case 77: 
                        case 109: {
                            return InfoCode.RestartMethod;
                        }
                        case 68: 
                        case 100: {
                            return InfoCode.RestartDelay;
                        }
                    }
                }
            }
        }
        throw new ParseException("Could not parse info code: " + new String(value, offset, length), 0);
    }

    public static int encode(byte[] destination, int offset, InfoCode infoCode) {
        switch (infoCode.getInfoCode()) {
            case 1: {
                destination[offset] = 66;
                return 1;
            }
            case 2: {
                destination[offset] = 67;
                return 1;
            }
            case 3: {
                destination[offset] = 73;
                return 1;
            }
            case 4: {
                destination[offset] = 78;
                return 1;
            }
            case 5: {
                destination[offset] = 88;
                return 1;
            }
            case 6: {
                destination[offset] = 76;
                return 1;
            }
            case 7: {
                destination[offset] = 77;
                return 1;
            }
            case 8: {
                destination[offset] = 82;
                return 1;
            }
            case 9: {
                destination[offset] = 83;
                return 1;
            }
            case 10: {
                destination[offset] = 68;
                return 1;
            }
            case 11: {
                destination[offset] = 79;
                return 1;
            }
            case 12: {
                destination[offset] = 80;
                return 1;
            }
            case 13: {
                destination[offset] = 69;
                return 1;
            }
            case 14: {
                destination[offset] = 90;
                return 1;
            }
            case 15: {
                destination[offset] = 81;
                return 1;
            }
            case 16: {
                destination[offset] = 84;
                return 1;
            }
            case 19: {
                destination[offset] = 65;
                return 1;
            }
            case 17: {
                destination[offset] = 82;
                destination[offset + 1] = 67;
                return 2;
            }
            case 18: {
                destination[offset] = 76;
                destination[offset + 1] = 67;
                return 2;
            }
            case 20: {
                destination[offset] = 69;
                destination[offset + 1] = 83;
                return 2;
            }
            case 21: {
                destination[offset] = 82;
                destination[offset + 1] = 77;
                return 2;
            }
            case 22: {
                destination[offset] = 82;
                destination[offset + 1] = 68;
                return 2;
            }
        }
        return 0;
    }

    public static int encodeList(byte[] destination, int offset, InfoCode[] infoCodes) {
        int i;
        if (infoCodes.length == 0) {
            return 0;
        }
        int totalLength = 0;
        for (i = 0; i < infoCodes.length - 1; ++i) {
            totalLength += InfoCodeHandler.encode(destination, offset + totalLength, infoCodes[i]);
            destination[offset + totalLength] = 44;
            ++totalLength;
        }
        totalLength += InfoCodeHandler.encode(destination, offset + totalLength, infoCodes[i]);
        return totalLength;
    }

    public static InfoCode[] decodeList(byte[] value, int offset, int length) throws ParseException {
        SplitDetails[] splitDetails = StringFunctions.split(value, offset, length, (byte)44);
        InfoCode[] infoCodes = new InfoCode[splitDetails.length];
        for (int i = 0; i < splitDetails.length; ++i) {
            infoCodes[i] = InfoCodeHandler.decode(value, splitDetails[i].getOffset(), splitDetails[i].getLength());
        }
        return infoCodes;
    }
}

