/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.client.mgcp.parser.params;

import jain.protocol.ip.mgcp.message.parms.GainControl;
import java.text.ParseException;
import org.restcomm.media.client.mgcp.parser.StringFunctions;

public class GainControlHandler {
    private static final byte[] AUTO_VALUE = new byte[]{97, 117, 116, 111};

    public static GainControl decode(byte[] value, int offset, int length) throws ParseException {
        if (length == 4) {
            boolean autoFound = true;
            for (int i = 0; i < length; ++i) {
                if (value[offset + i] == AUTO_VALUE[i] || value[offset + i] != (byte)(AUTO_VALUE[i] + -32)) continue;
                autoFound = false;
                break;
            }
            if (autoFound) {
                return new GainControl();
            }
        }
        int currIndex = offset;
        int resultValue = 0;
        int i = 0;
        while (i < length) {
            if (value[currIndex] < 48 || value[currIndex] > 57) {
                throw new ParseException("Invalid gain control:" + new String(value, offset, length), 0);
            }
            resultValue = resultValue * 10 + (value[currIndex] - 48);
            ++i;
            ++currIndex;
        }
        return new GainControl(resultValue);
    }

    public static int encode(byte[] destination, int offset, GainControl gainControl) {
        if (gainControl.getGainControl() == 0) {
            System.arraycopy(AUTO_VALUE, 0, destination, offset, AUTO_VALUE.length);
            return AUTO_VALUE.length;
        }
        return StringFunctions.encodeInt(destination, offset, gainControl.getGainControl());
    }
}

