/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.client.mgcp.parser.params;

import jain.protocol.ip.mgcp.message.parms.PacketizationPeriod;
import java.text.ParseException;
import org.restcomm.media.client.mgcp.parser.StringFunctions;

public class PacketizationPeriodHandler {
    public static PacketizationPeriod decode(byte[] value, int offset, int length) throws ParseException {
        int lowValue = 0;
        int highValue = 0;
        int i = 0;
        int currIndex = offset;
        while (i < length && value[currIndex] != 45) {
            if (value[currIndex] < 48 || value[currIndex] > 57) {
                throw new ParseException("Invalid packetization period:" + new String(value, offset, length), 0);
            }
            lowValue = lowValue * 10 + (value[currIndex] - 48);
            ++i;
            ++currIndex;
        }
        if (i == length) {
            return new PacketizationPeriod(lowValue);
        }
        ++i;
        ++currIndex;
        while (i < length) {
            if (value[currIndex] < 48 || value[currIndex] > 57) {
                throw new ParseException("Invalid packetization period:" + new String(value, offset, length), 0);
            }
            highValue = highValue * 10 + (value[currIndex] - 48);
            ++i;
            ++currIndex;
        }
        return new PacketizationPeriod(lowValue, highValue);
    }

    public static int encode(byte[] destination, int offset, PacketizationPeriod packetizationPeriod) {
        int usedLength = StringFunctions.encodeInt(destination, offset, packetizationPeriod.getPacketizationPeriodLowerBound());
        if (packetizationPeriod.getPacketizationPeriodLowerBound() != packetizationPeriod.getPacketizationPeriodUpperBound()) {
            destination[offset + usedLength] = 45;
            ++usedLength;
            usedLength += StringFunctions.encodeInt(destination, offset + usedLength, packetizationPeriod.getPacketizationPeriodUpperBound());
        }
        return usedLength;
    }
}

