/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.client.mgcp.parser.params;

import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import java.text.ParseException;
import org.restcomm.media.client.mgcp.parser.StringFunctions;

public class ReturnCodeHandler {
    public static ReturnCode decode(byte[] value, int offset, int length) throws ParseException {
        int currIndex = offset;
        int numericValue = 0;
        int i = 0;
        while (i < length) {
            if (value[currIndex] < 48 || value[currIndex] > 57) {
                throw new ParseException("Invalid return code:" + new String(value, offset, length), 0);
            }
            numericValue = numericValue * 10 + (value[currIndex] - 48);
            ++i;
            ++currIndex;
        }
        switch (numericValue) {
            case 530: {
                return ReturnCode.CAS_Signaling_Protocol_Error;
            }
            case 250: {
                return ReturnCode.Connection_Was_Deleted;
            }
            case 519: {
                return ReturnCode.Endpoint_Has_No_Digit_Map;
            }
            case 502: {
                return ReturnCode.Endpoint_Insufficient_Resources;
            }
            case 520: {
                return ReturnCode.Endpoint_Is_Restarting;
            }
            case 501: {
                return ReturnCode.Endpoint_Not_Ready;
            }
            case 521: {
                return ReturnCode.Endpoint_Redirected;
            }
            case 500: {
                return ReturnCode.Endpoint_Unknown;
            }
            case 512: {
                return ReturnCode.Gateway_Cannot_Detect_Requested_Event;
            }
            case 513: {
                return ReturnCode.Gateway_Cannot_Generate_Requested_Signal;
            }
            case 514: {
                return ReturnCode.Gateway_Cannot_Send_Specified_Announcement;
            }
            case 528: {
                return ReturnCode.Incompatible_Protocol_Version;
            }
            case 515: {
                return ReturnCode.Incorrect_Connection_ID;
            }
            case 526: {
                return ReturnCode.Insufficient_Bandwidth;
            }
            case 404: {
                return ReturnCode.Insufficient_Bandwidth_Now;
            }
            case 403: {
                return ReturnCode.Insufficient_Resources_Now;
            }
            case 529: {
                return ReturnCode.Internal_Hardware_Failure;
            }
            case 524: {
                return ReturnCode.Internal_Inconsistency_In_LocalConnectionOptions;
            }
            case 527: {
                return ReturnCode.Missing_RemoteConnectionDescriptor;
            }
            case 522: {
                return ReturnCode.No_Such_Event_Or_Signal;
            }
            case 401: {
                return ReturnCode.Phone_Off_Hook;
            }
            case 402: {
                return ReturnCode.Phone_On_Hook;
            }
            case 510: {
                return ReturnCode.Protocol_Error;
            }
            case 100: {
                return ReturnCode.Transaction_Being_Executed;
            }
            case 200: {
                return ReturnCode.Transaction_Executed_Normally;
            }
            case 400: {
                return ReturnCode.Transient_Error;
            }
            case 531: {
                return ReturnCode.Trunk_Group_Failure;
            }
            case 516: {
                return ReturnCode.Unknown_Call_ID;
            }
            case 525: {
                return ReturnCode.Unknown_Extension_In_LocalConnectionOptions;
            }
            case 523: {
                return ReturnCode.Unknown_Or_Illegal_Combination_Of_Actions;
            }
            case 511: {
                return ReturnCode.Unrecognized_Extension;
            }
            case 517: {
                return ReturnCode.Unsupported_Or_Invalid_Mode;
            }
            case 518: {
                return ReturnCode.Unsupported_Or_Unknown_Package;
            }
        }
        if (numericValue > 99 && numericValue < 200) {
            return ReturnCode.Transaction_Being_Executed;
        }
        if (numericValue > 199 && numericValue < 300) {
            return ReturnCode.Transaction_Executed_Normally;
        }
        if (numericValue > 299 && numericValue < 400) {
            return ReturnCode.Endpoint_Redirected;
        }
        if (numericValue > 399 && numericValue < 500) {
            return ReturnCode.Transient_Error;
        }
        if (numericValue > 499 && numericValue < 1000) {
            return ReturnCode.Protocol_Error;
        }
        throw new ParseException("unknown response code: " + numericValue, 0);
    }

    public static int encode(byte[] destination, int offset, ReturnCode returnCode) {
        return StringFunctions.encodeInt(destination, offset, returnCode.getValue());
    }
}

