/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.codec.g711.alaw;

import org.restcomm.media.spi.dsp.Codec;
import org.restcomm.media.spi.format.Format;
import org.restcomm.media.spi.format.FormatFactory;
import org.restcomm.media.spi.memory.Frame;
import org.restcomm.media.spi.memory.Memory;

public class Decoder
implements Codec {
    private static final Format alaw = FormatFactory.createAudioFormat((String)"pcma", (int)8000, (int)8, (int)1);
    private static final Format linear = FormatFactory.createAudioFormat((String)"linear", (int)8000, (int)16, (int)1);
    private int j = 0;
    private int i = 0;
    private int sourceLen = 0;
    private int destinationLen = 0;
    private int currentIndex;
    private static byte[] aLawDecompressTable_low = new byte[]{-128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, 64, -64, 64, -64, 64, -64, 64, -64, 64, -64, 64, -64, 64, -64, 64, -64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -88, -72, -120, -104, -24, -8, -56, -40, 40, 56, 8, 24, 104, 120, 72, 88, -88, -72, -120, -104, -24, -8, -56, -40, 40, 56, 8, 24, 104, 120, 72, 88, -96, -32, 32, 96, -96, -32, 32, 96, -96, -32, 32, 96, -96, -32, 32, 96, 80, 112, 16, 48, -48, -16, -112, -80, 80, 112, 16, 48, -48, -16, -112, -80, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -64, 64, -64, 64, -64, 64, -64, 64, -64, 64, -64, 64, -64, 64, -64, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 88, 72, 120, 104, 24, 8, 56, 40, -40, -56, -8, -24, -104, -120, -72, -88, 88, 72, 120, 104, 24, 8, 56, 40, -40, -56, -8, -24, -104, -120, -72, -88, 96, 32, -32, -96, 96, 32, -32, -96, 96, 32, -32, -96, 96, 32, -32, -96, -80, -112, -16, -48, 48, 16, 112, 80, -80, -112, -16, -48, 48, 16, 112, 80};
    private static byte[] aLawDecompressTable_high = new byte[]{-22, -21, -24, -23, -18, -17, -20, -19, -30, -29, -32, -31, -26, -25, -28, -27, -11, -11, -12, -12, -9, -9, -10, -10, -15, -15, -16, -16, -13, -13, -14, -14, -86, -82, -94, -90, -70, -66, -78, -74, -118, -114, -126, -122, -102, -98, -110, -106, -43, -41, -47, -45, -35, -33, -39, -37, -59, -57, -63, -61, -51, -49, -55, -53, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -6, -6, -6, -6, -5, -5, -5, -5, -8, -8, -8, -8, -7, -7, -7, -7, -3, -3, -3, -3, -3, -3, -3, -3, -4, -4, -4, -4, -4, -4, -4, -4, 21, 20, 23, 22, 17, 16, 19, 18, 29, 28, 31, 30, 25, 24, 27, 26, 10, 10, 11, 11, 8, 8, 9, 9, 14, 14, 15, 15, 12, 12, 13, 13, 86, 82, 94, 90, 70, 66, 78, 74, 118, 114, 126, 122, 102, 98, 110, 106, 43, 41, 47, 45, 35, 33, 39, 37, 59, 57, 63, 61, 51, 49, 55, 53, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 5, 5, 5, 4, 4, 4, 4, 7, 7, 7, 7, 6, 6, 6, 6, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3};

    public Format getSupportedInputFormat() {
        return alaw;
    }

    public Format getSupportedOutputFormat() {
        return linear;
    }

    public Frame process(Frame frame) {
        this.sourceLen = frame.getLength();
        this.destinationLen = this.sourceLen * 2;
        Frame res = Memory.allocate((int)this.destinationLen);
        byte[] data = frame.getData();
        byte[] resData = res.getData();
        this.i = 0;
        this.j = 0;
        while (this.i < this.sourceLen) {
            this.currentIndex = data[this.i] & 0xFF;
            resData[this.j++] = aLawDecompressTable_low[this.currentIndex];
            resData[this.j++] = aLawDecompressTable_high[this.currentIndex];
            ++this.i;
        }
        res.setOffset(0);
        res.setLength(this.destinationLen);
        res.setTimestamp(frame.getTimestamp());
        res.setDuration(frame.getDuration());
        res.setSequenceNumber(frame.getSequenceNumber());
        res.setEOM(frame.isEOM());
        res.setFormat(linear);
        res.setHeader(frame.getHeader());
        return res;
    }
}

