/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.codec.g711.ulaw;

import org.restcomm.media.codec.g711.ulaw.EncoderData;
import org.restcomm.media.spi.dsp.Codec;
import org.restcomm.media.spi.format.Format;
import org.restcomm.media.spi.format.FormatFactory;
import org.restcomm.media.spi.memory.Frame;
import org.restcomm.media.spi.memory.Memory;

public class Encoder
implements Codec {
    private static final Format ulaw = FormatFactory.createAudioFormat((String)"pcmu", (int)8000, (int)8, (int)1);
    private static final Format linear = FormatFactory.createAudioFormat((String)"linear", (int)8000, (int)16, (int)1);
    private int i;
    private int j;
    private int count;

    public Format getSupportedInputFormat() {
        return linear;
    }

    public Format getSupportedOutputFormat() {
        return ulaw;
    }

    public Frame process(Frame frame) {
        this.count = frame.getLength() / 2;
        Frame res = Memory.allocate((int)this.count);
        byte[] data = frame.getData();
        byte[] resData = res.getData();
        this.i = 0;
        this.j = 0;
        while (this.i < this.count) {
            resData[this.i] = EncoderData.muLawCompressTable[data[this.j + 1] & 0xFF][data[this.j++] & 0xFF];
            ++this.i;
            ++this.j;
        }
        res.setOffset(0);
        res.setLength(this.count);
        res.setFormat(ulaw);
        res.setTimestamp(frame.getTimestamp());
        res.setDuration(frame.getDuration());
        res.setEOM(frame.isEOM());
        res.setSequenceNumber(frame.getSequenceNumber());
        return res;
    }
}

