/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.codec.ilbc;

import org.restcomm.media.codec.ilbc.BasicFunctions;
import org.restcomm.media.codec.ilbc.Constants;
import org.restcomm.media.codec.ilbc.CorrData;
import org.restcomm.media.codec.ilbc.DecoderState;
import org.restcomm.media.codec.ilbc.EncoderBits;
import org.restcomm.media.spi.dsp.Codec;
import org.restcomm.media.spi.format.Format;
import org.restcomm.media.spi.format.FormatFactory;
import org.restcomm.media.spi.memory.Frame;
import org.restcomm.media.spi.memory.Memory;

public class Decoder
implements Codec {
    private static final Format ilbc = FormatFactory.createAudioFormat((String)"ilbc", (int)8000, (int)16, (int)1);
    private static final Format linear = FormatFactory.createAudioFormat((String)"linear", (int)8000, (int)16, (int)1);
    private short[] decResidual = new short[240];
    private short[] plcResidual = new short[250];
    private short[] syntDenum = new short[66];
    private short[] output = new short[240];
    private short[] plcLpc = new short[11];
    private short[] signal = new short[25];
    private int i;
    private int j;
    private int k;
    private int n;
    private int s;
    private int mode;
    private int pos;
    private int cbPos;
    private int len;
    private int tempShift;
    private int crossCorr;
    private int energy;
    private int shifts;
    private int newCrit;
    private int maxCrit;
    private int measure;
    private int maxMeasure;
    private int ind;
    private int tempIndex1;
    private int tempIndex2;
    private int tempIndex3;
    private int tempIndex4;
    private int tempIndex5;
    private int tempIndex6;
    private int tempIndex7;
    private int temp;
    private int temp2;
    private int[] tempLMemory = new int[100];
    private short tempS;
    private short tempS2;
    private short xHi;
    private short xLow;
    private short orderPlusOne;
    private short max;
    private short lag;
    private short memlGotten;
    private short nFor;
    private short nBack;
    private short diff;
    private short startPos;
    private short subCount;
    private short subFrame;
    private short baseSize;
    private short maxLag;
    private short crossCorrScale;
    private short energyScale;
    private short crossCorrSqMod;
    private short crossCorrSqModMax;
    private short crossCorrMod;
    private short energyMod;
    private short energyModMax;
    private short totScale;
    private short totScaleMax;
    private short scaleDiff;
    private short pick;
    private short crossSquareMax;
    private short crossSquare;
    private short shift1;
    private short shift2;
    private short shift3;
    private short shiftMax;
    private short scale1;
    private short scale2;
    private short scale3;
    private short nom;
    private short corrLen;
    private short useGain;
    private short totGain;
    private short maxPerSquare;
    private short denom;
    private short pitchFact;
    private short useLag;
    private short randLag;
    private EncoderBits encoderBits = new EncoderBits();
    private DecoderState decoderState = new DecoderState();
    private CorrData corrData = new CorrData();
    private CorrData tempCorrData = new CorrData();
    private short[] tempMemory = new short[350];

    public Frame process(Frame frame) {
        Frame res;
        byte[] inputData = frame.getData();
        if (inputData.length == 50) {
            this.mode = 30;
        } else if (inputData.length == 38) {
            this.mode = 20;
        } else {
            throw new IllegalArgumentException("INVALID FRAME SIZE");
        }
        this.decoderState.setMode(this.mode);
        this.temp = inputData.length / 2;
        this.i = 0;
        while (this.i < this.temp) {
            this.signal[this.i] = (short)(inputData[this.i * 2] << 8 | inputData[this.i * 2 + 1] & 0xFF);
            ++this.i;
        }
        this.unpackBits(this.signal, this.mode);
        if (this.encoderBits.getStartIdx() < 1) {
            this.mode = 0;
        }
        if (this.decoderState.DECODER_MODE == 20 && this.encoderBits.getStartIdx() > 3) {
            this.mode = 0;
        }
        if (this.decoderState.DECODER_MODE == 30 && this.encoderBits.getStartIdx() > 5) {
            this.mode = 0;
        }
        if (this.mode > 0) {
            short[] lsfDeq = this.tempMemory;
            short[] weightDenum = this.tempMemory;
            this.updateDecIndex();
            this.simpleLsfDeq(lsfDeq, 0, this.encoderBits.getLSF(), 0);
            this.lsfCheck(lsfDeq, 0, 10);
            this.decoderInterpolateLsp(this.syntDenum, 0, weightDenum, 20, lsfDeq, 0, (short)10);
            this.decodeResidual(this.decResidual, 0, this.syntDenum, 0);
            this.doThePlc(this.plcResidual, 0, this.plcLpc, 0, (short)0, this.decResidual, 0, this.syntDenum, 11 * (this.decoderState.SUBFRAMES - 1), (short)this.decoderState.getLastTag());
            System.arraycopy(this.plcResidual, 0, this.decResidual, 0, this.decoderState.SIZE);
        }
        if (this.mode == 0) {
            this.doThePlc(this.plcResidual, 0, this.plcLpc, 0, (short)1, this.decResidual, 0, this.syntDenum, 0, (short)this.decoderState.getLastTag());
            System.arraycopy(this.plcResidual, 0, this.decResidual, 0, this.decoderState.SIZE);
            this.orderPlusOne = (short)11;
            this.i = 0;
            while (this.i < this.decoderState.SUBFRAMES) {
                System.arraycopy(this.plcLpc, 0, this.syntDenum, this.i * this.orderPlusOne, this.orderPlusOne);
                ++this.i;
            }
        }
        this.lag = (short)20;
        this.lag = this.mode == 20 ? (short)this.xCorrCoef(this.decResidual, this.decoderState.SIZE - 60, this.decResidual, this.decoderState.SIZE - 60 - this.lag, (short)60, (short)80, this.lag, (short)-1) : (short)this.xCorrCoef(this.decResidual, this.decoderState.SIZE - 80, this.decResidual, this.decoderState.SIZE - 80 - this.lag, (short)80, (short)100, this.lag, (short)-1);
        this.decoderState.setLastTag(this.lag);
        System.arraycopy(this.decResidual, 0, this.plcResidual, 10, this.decoderState.SIZE);
        System.arraycopy(this.decoderState.getSynthMem(), 0, this.plcResidual, 0, 10);
        this.i = 0;
        while (this.i < this.decoderState.SUBFRAMES) {
            BasicFunctions.filterAR(this.plcResidual, 10 + 40 * this.i, this.plcResidual, 10 + 40 * this.i, this.syntDenum, 11 * this.i, 11, 40);
            ++this.i;
        }
        System.arraycopy(this.plcResidual, this.decoderState.SIZE, this.decoderState.getSynthMem(), 0, 10);
        System.arraycopy(this.plcResidual, 10, this.output, 0, this.decoderState.SIZE);
        this.hpOutput(this.output, Constants.HP_OUT_COEFICIENTS, this.decoderState.getHpiMemY(), this.decoderState.getHpiMemX(), this.decoderState.SIZE);
        System.arraycopy(this.syntDenum, 0, this.decoderState.getOldSyntDenum(), 0, this.decoderState.SUBFRAMES * 11);
        this.decoderState.setPrevEnchPl(0);
        if (this.mode == 0) {
            this.decoderState.setPrevEnchPl(1);
        }
        if (this.decoderState.DECODER_MODE == 20) {
            res = Memory.allocate((int)320);
            inputData = res.getData();
            this.i = 0;
            while (this.i < 160) {
                inputData[this.i * 2] = (byte)(this.output[this.i] >> 8 & 0xFF);
                inputData[this.i * 2 + 1] = (byte)(this.output[this.i] & 0xFF);
                ++this.i;
            }
        } else {
            res = Memory.allocate((int)480);
            inputData = res.getData();
            this.i = 0;
            while (this.i < 240) {
                inputData[this.i * 2] = (byte)(this.output[this.i] >> 8 & 0xFF);
                inputData[this.i * 2 + 1] = (byte)(this.output[this.i] & 0xFF);
                ++this.i;
            }
        }
        res.setOffset(0);
        res.setLength(res.getData().length);
        res.setTimestamp(frame.getTimestamp());
        res.setDuration(frame.getDuration());
        res.setSequenceNumber(frame.getSequenceNumber());
        res.setEOM(frame.isEOM());
        res.setFormat(linear);
        return res;
    }

    public Format getSupportedInputFormat() {
        return ilbc;
    }

    public Format getSupportedOutputFormat() {
        return linear;
    }

    private void doThePlc(short[] plcResidual, int plcResidualIndex, short[] plcLpc, int plcLpcIndex, short pli, short[] decResidual, int decResidualIndex, short[] lpc, int lpcIndex, short inLag) {
        short[] randVec = this.tempMemory;
        this.tempCorrData.setEnergy(0);
        if (pli == 1) {
            this.decoderState.setConsPliCount(this.decoderState.getConsPliCount() + 1);
            if (this.decoderState.getPrevPli() != 1) {
                this.max = BasicFunctions.getMaxAbsValue(this.decoderState.getPrevResidual(), 0, this.decoderState.SIZE);
                this.scale3 = (short)((BasicFunctions.getSize(this.max) << 1) - 25);
                if (this.scale3 < 0) {
                    this.scale3 = 0;
                }
                this.decoderState.setPrevScale(this.scale3);
                this.lag = (short)(inLag - 3);
                this.corrLen = 60 > this.decoderState.SIZE - inLag - 3 ? (short)60 : (short)(this.decoderState.SIZE - inLag - 3);
                this.compCorr(this.corrData, this.decoderState.getPrevResidual(), 0, this.lag, this.decoderState.SIZE, this.corrLen, this.scale3);
                this.shiftMax = (short)(BasicFunctions.getSize(Math.abs(this.corrData.getCorrelation())) - 15);
                if (this.shiftMax > 0) {
                    this.tempShift = this.corrData.getCorrelation() >> this.shiftMax;
                    this.tempShift *= this.tempShift;
                    this.crossSquareMax = (short)(this.tempShift >> 15);
                } else {
                    this.tempShift = this.corrData.getCorrelation() << 0 - this.shiftMax;
                    this.tempShift *= this.tempShift;
                    this.crossSquareMax = (short)(this.tempShift >> 15);
                }
                this.j = inLag - 2;
                while (this.j <= inLag + 3) {
                    this.compCorr(this.tempCorrData, this.decoderState.getPrevResidual(), 0, (short)this.j, this.decoderState.SIZE, this.corrLen, this.scale3);
                    this.shift1 = BasicFunctions.getSize(Math.abs(this.tempCorrData.getCorrelation()) - 15);
                    if (this.shift1 > 0) {
                        this.tempShift = this.tempCorrData.getCorrelation() >> this.shift1;
                        this.tempShift *= this.tempShift;
                        this.crossSquare = (short)(this.tempShift >> 15);
                    } else {
                        this.tempShift = this.tempCorrData.getCorrelation() << 0 - this.shift1;
                        this.tempShift *= this.tempShift;
                        this.crossSquare = (short)(this.tempShift >> 15);
                    }
                    this.shift2 = (short)(BasicFunctions.getSize(this.corrData.getEnergy()) - 15);
                    this.measure = this.shift2 > 0 ? (this.corrData.getEnergy() >> this.shift2) * this.crossSquare : (this.corrData.getEnergy() << 0 - this.shift2) * this.crossSquare;
                    this.shift3 = (short)(BasicFunctions.getSize(this.tempCorrData.getEnergy()) - 15);
                    this.maxMeasure = this.shift3 > 0 ? (this.tempCorrData.getEnergy() >> this.shift3) * this.crossSquareMax : (this.tempCorrData.getEnergy() << 0 - this.shift3) * this.crossSquareMax;
                    if ((this.shiftMax << 1) + this.shift3 > (this.shift1 << 1) + this.shift2) {
                        this.tempShift = this.shiftMax << 1;
                        this.tempShift -= this.shift1 << 1;
                        this.tempShift = this.tempShift + this.shift3 - this.shift2;
                        this.tempS = this.tempShift > 31 ? (short)31 : (short)this.tempShift;
                        this.tempS2 = 0;
                    } else {
                        this.tempS = 0;
                        this.tempShift = this.shift1 << 1;
                        this.tempShift -= this.shiftMax << 1;
                        this.tempShift = this.tempShift + this.shift2 - this.shift3;
                        this.tempS2 = this.tempShift > 31 ? (short)31 : (short)this.tempShift;
                    }
                    if (this.measure >> this.tempS > this.maxMeasure >> this.tempS2) {
                        this.lag = (short)this.j;
                        this.crossSquareMax = this.crossSquare;
                        this.corrData.setCorrelation(this.tempCorrData.getCorrelation());
                        this.shiftMax = this.shift1;
                        this.corrData.setEnergy(this.tempCorrData.getEnergy());
                    }
                    ++this.j;
                }
                BasicFunctions.scaleRight(this.decoderState.getPrevResidual(), this.decoderState.SIZE - this.corrLen, this.decoderState.getPrevResidual(), this.decoderState.SIZE - this.corrLen, this.corrLen, this.scale3);
                if (this.temp2 > 0 && this.tempCorrData.getEnergy() > 0) {
                    this.scale1 = (short)(BasicFunctions.norm(this.temp2) - 16);
                    this.tempS = this.scale1 > 0 ? (short)(this.temp2 << this.scale1) : (short)(this.temp2 >> 0 - this.scale1);
                    this.scale2 = (short)(BasicFunctions.norm(this.corrData.getEnergy()) - 16);
                    this.tempS2 = this.scale2 > 0 ? (short)(this.corrData.getEnergy() << this.scale2) : (short)(this.corrData.getEnergy() >> 0 - this.scale2);
                    this.denom = (short)(this.tempS * this.tempS2 >> 16);
                    this.totScale = (short)(this.scale1 + this.scale2 - 1);
                    this.tempShift = this.totScale >> 1;
                    this.tempS = this.tempShift > 0 ? (short)(this.corrData.getCorrelation() << this.tempShift) : (short)(this.corrData.getCorrelation() >> 0 - this.tempShift);
                    this.tempShift = this.totScale - this.tempShift;
                    this.tempS2 = this.tempShift > 0 ? (short)(this.corrData.getCorrelation() << this.tempShift) : (short)(this.corrData.getCorrelation() >> 0 - this.tempShift);
                    this.nom = (short)(this.tempS * this.tempS2);
                    this.maxPerSquare = (short)(this.nom / this.denom);
                } else {
                    this.maxPerSquare = 0;
                }
            } else {
                this.lag = this.decoderState.getPrevLag();
                this.maxPerSquare = this.decoderState.getPerSquare();
            }
            this.useGain = Short.MAX_VALUE;
            if (this.decoderState.getConsPliCount() * this.decoderState.SIZE > 320) {
                this.useGain = (short)29491;
            } else if (this.decoderState.getConsPliCount() * this.decoderState.SIZE > 640) {
                this.useGain = (short)22938;
            } else if (this.decoderState.getConsPliCount() * this.decoderState.SIZE > 960) {
                this.useGain = (short)16384;
            } else if (this.decoderState.getConsPliCount() * this.decoderState.SIZE > 1280) {
                this.useGain = 0;
            }
            if (this.maxPerSquare > 7868) {
                this.pitchFact = Short.MAX_VALUE;
            } else if (this.maxPerSquare > 839) {
                this.ind = 5;
                while (this.maxPerSquare < Constants.PLC_PER_SQR[this.ind] && this.ind > 0) {
                    --this.ind;
                }
                this.temp = Constants.PLC_PITCH_FACT[this.ind];
                this.temp += Constants.PLC_PF_SLOPE[this.ind] * (this.maxPerSquare - Constants.PLC_PER_SQR[this.ind]) >> 11;
                this.pitchFact = this.temp > Short.MIN_VALUE ? (short)Short.MIN_VALUE : (short)this.temp;
            } else {
                this.pitchFact = 0;
            }
            this.useLag = this.lag;
            if (this.lag < 80) {
                this.useLag = (short)(2 * this.lag);
            }
            this.energy = 0;
            this.i = 0;
            while (this.i < this.decoderState.SIZE) {
                this.decoderState.setSeed((short)(this.decoderState.getSeed() * 31821 + 13849));
                this.randLag = (short)(53 + (this.decoderState.getSeed() & 0x3F));
                this.pick = (short)(this.i - this.randLag);
                randVec[86 + this.i] = this.pick < 0 ? this.decoderState.getPrevResidual()[this.decoderState.SIZE + this.pick] : this.decoderState.getPrevResidual()[this.pick];
                this.pick = (short)(this.i - this.useLag);
                plcResidual[plcResidualIndex + this.i] = this.pick < 0 ? this.decoderState.getPrevResidual()[this.decoderState.SIZE + this.pick] : plcResidual[plcResidualIndex + this.pick];
                this.totGain = this.i < 80 ? this.useGain : (this.i < 160 ? (short)(31130 * this.useGain >> 15) : (short)(29491 * this.useGain >> 15));
                this.tempShift = this.pitchFact * plcResidual[plcResidualIndex + this.i];
                this.tempShift += (Short.MAX_VALUE - this.pitchFact) * randVec[86 + this.i];
                this.tempShift += 16384;
                this.temp = (short)(this.tempShift >> 15);
                plcResidual[plcResidualIndex + this.i] = (short)(this.totGain * this.temp >> 15);
                this.tempShift = plcResidual[plcResidualIndex + this.i] * plcResidual[plcResidualIndex + this.i];
                this.energy += (short)(this.tempShift >> this.decoderState.getPrevScale() + 1);
                ++this.i;
            }
            this.tempShift = this.decoderState.SIZE * 900;
            this.tempShift = this.decoderState.getPrevScale() + 1 > 0 ? (this.tempShift >>= this.decoderState.getPrevScale() + 1) : (this.tempShift <<= 0 - this.decoderState.getPrevScale() - 1);
            if (this.energy < this.tempShift) {
                this.energy = 0;
                this.i = 0;
                while (this.i < this.decoderState.SIZE) {
                    plcResidual[plcResidualIndex + this.i] = randVec[86 + this.i];
                    ++this.i;
                }
            }
            System.arraycopy(this.decoderState.getPrevLpc(), 0, plcLpc, plcLpcIndex, 10);
            this.decoderState.setPrevLag(this.lag);
            this.decoderState.setPerSquare(this.maxPerSquare);
        } else {
            System.arraycopy(decResidual, decResidualIndex, plcResidual, plcResidualIndex, this.decoderState.SIZE);
            System.arraycopy(lpc, lpcIndex, plcLpc, plcLpcIndex, 11);
            this.decoderState.setConsPliCount(0);
        }
        this.decoderState.setPrevPli(pli);
        System.arraycopy(plcLpc, plcLpcIndex, this.decoderState.getPrevLpc(), 0, 11);
        System.arraycopy(plcResidual, plcResidualIndex, this.decoderState.getPrevResidual(), 0, this.decoderState.SIZE);
    }

    private void compCorr(CorrData currData, short[] buffer, int bufferIndex, short lag, short bLen, short sRange, short scale) {
        this.tempIndex7 = bLen - sRange - lag;
        if (scale > 0) {
            currData.setCorrelation(BasicFunctions.scaleRight(buffer, bufferIndex + bLen - sRange, buffer, this.tempIndex7, sRange, scale));
            currData.setEnergy(BasicFunctions.scaleRight(buffer, this.tempIndex7, buffer, this.tempIndex7, sRange, scale));
        } else {
            currData.setCorrelation(BasicFunctions.scaleLeft(buffer, bufferIndex + bLen - sRange, buffer, this.tempIndex7, sRange, 0 - scale));
            currData.setEnergy(BasicFunctions.scaleLeft(buffer, this.tempIndex7, buffer, this.tempIndex7, sRange, scale));
        }
        if (currData.getCorrelation() == 0) {
            currData.setCorrelation(0);
            currData.setEnergy(1);
        }
    }

    private void hpOutput(short[] signal, short[] ba, short[] y, short[] x, short len) {
        this.i = 0;
        while (this.i < len) {
            this.temp = y[1] * ba[3];
            this.temp += y[3] * ba[4];
            this.temp >>= 15;
            this.temp += y[0] * ba[3];
            this.temp += y[2] * ba[4];
            this.temp <<= 1;
            this.temp += signal[this.i] * ba[0];
            this.temp += x[0] * ba[1];
            this.temp += x[1] * ba[2];
            x[1] = x[0];
            x[0] = signal[this.i];
            this.temp2 = this.temp + 1024;
            if (this.temp2 > 0x3FFFFFF) {
                this.temp2 = 0x3FFFFFF;
            } else if (this.temp2 < -67108864) {
                this.temp2 = -67108864;
            }
            signal[this.i] = (short)(this.temp2 >> 11);
            y[2] = y[0];
            y[3] = y[1];
            this.temp = this.temp > 0xFFFFFFF ? Integer.MAX_VALUE : (this.temp < -268435456 ? Integer.MIN_VALUE : (this.temp <<= 3));
            y[0] = (short)(this.temp >> 16);
            this.tempShift = y[0] << 16;
            y[1] = (short)(this.temp - this.tempShift >> 1);
            ++this.i;
        }
    }

    private int xCorrCoef(short[] target, int targetIndex, short[] regressor, int regressorIndex, short subl, short searchLen, short offset, short step) {
        this.crossCorrSqModMax = 0;
        this.energyModMax = Short.MAX_VALUE;
        this.totScaleMax = (short)-500;
        this.maxLag = 0;
        this.pos = 0;
        if (step == 1) {
            this.max = BasicFunctions.getMaxAbsValue(regressor, regressorIndex, subl + searchLen - 1);
            this.tempIndex1 = regressorIndex;
            this.tempIndex2 = regressorIndex + subl;
        } else {
            this.max = BasicFunctions.getMaxAbsValue(regressor, regressorIndex - searchLen, subl + searchLen - 1);
            this.tempIndex1 = regressorIndex - 1;
            this.tempIndex2 = regressorIndex + subl - 1;
        }
        this.shifts = this.max > 5000 ? 2 : 0;
        this.energy = BasicFunctions.scaleRight(regressor, regressorIndex, regressor, regressorIndex, subl, this.shifts);
        this.k = 0;
        while (this.k < searchLen) {
            this.tempIndex3 = targetIndex;
            this.tempIndex4 = regressorIndex + this.pos;
            this.crossCorr = BasicFunctions.scaleRight(target, this.tempIndex3, regressor, this.tempIndex4, subl, this.shifts);
            if (this.energy > 0 && this.crossCorr > 0) {
                this.crossCorrScale = (short)(BasicFunctions.norm(this.crossCorr) - 16);
                this.crossCorrMod = this.crossCorrScale > 0 ? (short)(this.crossCorr << this.crossCorrScale) : (short)(this.crossCorr >> 0 - this.crossCorrScale);
                this.energyScale = (short)(BasicFunctions.norm(this.energy) - 16);
                this.energyMod = this.energyScale > 0 ? (short)(this.energy << this.energyScale) : (short)(this.energy >> 0 - this.energyScale);
                this.crossCorrSqMod = (short)(this.crossCorrMod * this.crossCorrMod >> 16);
                this.totScale = (short)(this.energyScale - (this.crossCorrScale << 1));
                this.scaleDiff = (short)(this.totScale - this.totScaleMax);
                if (this.scaleDiff > 31) {
                    this.scaleDiff = (short)31;
                } else if (this.scaleDiff < -31) {
                    this.scaleDiff = (short)-31;
                }
                if (this.scaleDiff < 0) {
                    this.newCrit = this.crossCorrSqMod * this.energyModMax >> -this.scaleDiff;
                    this.maxCrit = this.crossCorrSqModMax * this.energyMod;
                } else {
                    this.newCrit = this.crossCorrSqMod * this.energyModMax;
                    this.maxCrit = this.crossCorrSqModMax * this.energyMod >> this.scaleDiff;
                }
                if (this.newCrit > this.maxCrit) {
                    this.crossCorrSqModMax = this.crossCorrSqMod;
                    this.energyModMax = this.energyMod;
                    this.totScaleMax = this.totScale;
                    this.maxLag = (short)this.k;
                }
            }
            this.pos += step;
            this.temp = regressor[this.tempIndex2] * regressor[this.tempIndex2] - regressor[this.tempIndex1] * regressor[this.tempIndex1];
            this.temp >>= this.shifts;
            this.energy += step * this.temp;
            this.tempIndex1 += step;
            this.tempIndex2 += step;
            ++this.k;
        }
        return this.maxLag + offset;
    }

    private void decodeResidual(short[] decResidual, int decResidualIndex, short[] syntDenum, int syntDenumIndex) {
        short[] reverseDecresidual = this.decoderState.getEnhancementBuffer();
        short[] memVec = this.decoderState.getPrevResidual();
        this.diff = (short)(80 - this.decoderState.STATE_SHORT_LEN);
        this.startPos = this.encoderBits.getStateFirst() ? (short)((this.encoderBits.getStartIdx() - 1) * 40) : (short)((this.encoderBits.getStartIdx() - 1) * 40 + this.diff);
        this.stateConstruct(syntDenum, syntDenumIndex + (this.encoderBits.getStartIdx() - 1) * 11, decResidual, decResidualIndex + this.startPos);
        if (this.encoderBits.getStateFirst()) {
            this.i = 4;
            while (this.i < 151 - this.decoderState.STATE_SHORT_LEN) {
                memVec[this.i] = 0;
                ++this.i;
            }
            System.arraycopy(decResidual, this.startPos, memVec, 151 - this.decoderState.STATE_SHORT_LEN, this.decoderState.STATE_SHORT_LEN);
            this.cbConstruct(decResidual, decResidualIndex + this.startPos + this.decoderState.STATE_SHORT_LEN, memVec, 66, (short)85, this.diff, 0, 0);
        } else {
            BasicFunctions.reverseCopy(reverseDecresidual, this.diff, decResidual, decResidualIndex + (this.encoderBits.getStartIdx() + 1) * 40 - 80, this.diff);
            this.memlGotten = this.decoderState.STATE_SHORT_LEN;
            BasicFunctions.reverseCopy(memVec, 150, decResidual, decResidualIndex + this.startPos, this.memlGotten);
            this.i = 4;
            while (this.i < 151 - this.memlGotten) {
                memVec[this.i] = 0;
                ++this.i;
            }
            this.cbConstruct(reverseDecresidual, 0, memVec, 66, (short)85, this.diff, 0, 0);
            BasicFunctions.reverseCopy(decResidual, decResidualIndex + this.startPos - 1, reverseDecresidual, 0, this.diff);
        }
        this.subCount = 1;
        this.nFor = (short)(this.decoderState.SUBFRAMES - this.encoderBits.getStartIdx() - 1);
        if (this.nFor > 0) {
            this.i = 4;
            while (this.i < 71) {
                memVec[this.i] = 0;
                ++this.i;
            }
            System.arraycopy(decResidual, decResidualIndex + 40 * (this.encoderBits.getStartIdx() - 1), memVec, 71, 80);
            this.subFrame = 0;
            while (this.subFrame < this.nFor) {
                this.cbConstruct(decResidual, decResidualIndex + 40 * (this.encoderBits.getStartIdx() + 1 + this.subFrame), memVec, 4, (short)147, (short)40, this.subCount * 3, this.subCount * 3);
                this.i = 4;
                while (this.i < 111) {
                    memVec[this.i] = memVec[this.i + 40];
                    ++this.i;
                }
                System.arraycopy(reverseDecresidual, 40 * (this.encoderBits.getStartIdx() + 1 + this.subFrame), memVec, 111, 40);
                this.subCount = (short)(this.subCount + 1);
                this.subFrame = (short)(this.subFrame + 1);
            }
        }
        this.nBack = (short)(this.encoderBits.getStartIdx() - 1);
        if (this.nBack > 0) {
            this.memlGotten = (short)(40 * (this.decoderState.SUBFRAMES + 1 - this.encoderBits.getStartIdx()));
            if (this.memlGotten > 147) {
                this.memlGotten = (short)147;
            }
            BasicFunctions.reverseCopy(memVec, 150, decResidual, decResidualIndex + 40 * (this.encoderBits.getStartIdx() - 1), this.memlGotten);
            this.i = 4;
            while (this.i < 151 - this.memlGotten) {
                memVec[this.i] = 0;
                ++this.i;
            }
            this.subFrame = 0;
            while (this.subFrame < this.nBack) {
                this.cbConstruct(reverseDecresidual, 40 * this.subFrame, memVec, 4, (short)147, (short)40, this.subCount * 3, this.subCount * 3);
                this.i = 4;
                while (this.i < 111) {
                    memVec[this.i] = memVec[this.i + 40];
                    ++this.i;
                }
                System.arraycopy(reverseDecresidual, 40 * this.subFrame, memVec, 111, 40);
                this.subCount = (short)(this.subCount + 1);
                this.subFrame = (short)(this.subFrame + 1);
            }
            BasicFunctions.reverseCopy(decResidual, decResidualIndex + 40 * this.nBack - 1, reverseDecresidual, 0, 40 * this.nBack);
        }
    }

    private void lsf2Poly(short[] a, int aIndex, short[] lsf, int lsfIndex) {
        int[] f = this.tempLMemory;
        this.tempIndex3 = 0;
        this.tempIndex4 = 6;
        short[] lsp = this.tempMemory;
        this.lsf2Lsp(lsf, lsfIndex, lsp, 61, 10);
        this.getLspPoly(lsp, 61, f, 0);
        this.getLspPoly(lsp, 62, f, 6);
        this.tempIndex3 = 5;
        this.tempIndex4 = 11;
        this.k = 5;
        while (this.k > 0) {
            int n = this.tempIndex3;
            f[n] = f[n] + f[this.tempIndex3 - 1];
            int n2 = this.tempIndex4;
            f[n2] = f[n2] - f[this.tempIndex4 - 1];
            --this.tempIndex3;
            --this.tempIndex4;
            --this.k;
        }
        a[aIndex] = 4096;
        this.tempIndex5 = aIndex + 1;
        this.tempIndex6 = aIndex + 10;
        this.tempIndex3 = 1;
        this.tempIndex4 = 7;
        this.k = 5;
        while (this.k > 0) {
            this.temp2 = f[this.tempIndex3] + f[this.tempIndex4];
            a[this.tempIndex5++] = (short)(this.temp2 + 4096 >> 13);
            this.temp2 = f[this.tempIndex3] - f[this.tempIndex4];
            ++this.tempIndex3;
            ++this.tempIndex4;
            a[this.tempIndex6--] = (short)(this.temp2 + 4096 >> 13);
            --this.k;
        }
    }

    private void getLspPoly(short[] lsp, int lspIndex, int[] f, int fIndex) {
        this.tempIndex5 = lspIndex;
        this.tempIndex6 = fIndex;
        f[this.tempIndex6++] = 0x1000000;
        f[this.tempIndex6++] = lsp[this.tempIndex5] * -1024;
        this.tempIndex5 += 2;
        this.k = 2;
        while (this.k <= 5) {
            f[this.tempIndex6] = f[this.tempIndex6 - 2];
            this.j = this.k;
            while (this.j > 1) {
                this.xHi = (short)(f[this.tempIndex6 - 1] >> 16);
                this.tempShift = this.xHi << 16;
                this.xLow = (short)(f[this.tempIndex6 - 1] - this.tempShift >> 1);
                this.temp2 = this.tempShift = this.xHi * lsp[this.tempIndex5] << 2;
                this.tempShift = this.xLow * lsp[this.tempIndex5] >> 15 << 2;
                this.temp2 += this.tempShift;
                int n = this.tempIndex6;
                f[n] = f[n] + f[this.tempIndex6 - 2];
                int n2 = this.tempIndex6--;
                f[n2] = f[n2] - this.temp2;
                --this.j;
            }
            int n = this.tempIndex6;
            f[n] = f[n] - (lsp[this.tempIndex5] << 10);
            this.tempIndex6 += this.k;
            this.tempIndex5 += 2;
            ++this.k;
        }
    }

    private void interpolate(short[] out, int outIndex, short[] in1, int in1Index, short[] in2, int in2Index, short coef, int length) {
        this.tempIndex3 = outIndex;
        this.tempIndex4 = in1Index;
        this.tempIndex5 = in2Index;
        this.tempS = (short)(16384 - coef);
        this.k = 0;
        while (this.k < length) {
            out[this.tempIndex3++] = (short)(coef * in1[this.tempIndex4++] + this.tempS * in2[this.tempIndex5++] + 8192 >> 14);
            ++this.k;
        }
    }

    private void lsf2Lsp(short[] lsf, int lsfIndex, short[] lsp, int lspIndex, int count) {
        this.tempIndex6 = lspIndex;
        this.j = 0;
        while (this.j < count) {
            this.tempS = (short)(lsf[lsfIndex++] * 20861 >> 15);
            this.tempS2 = (short)(this.tempS >> 8);
            this.tempS = (short)(this.tempS & 0xFF);
            if (this.tempS2 > 63 || this.tempS2 < 0) {
                this.tempS2 = (short)63;
            }
            this.temp2 = Constants.COS_DERIVATIVE[this.tempS2] * this.tempS;
            this.temp2 >>= 12;
            lsp[lspIndex++] = (short)(this.temp2 + Constants.COS[this.tempS2]);
            ++this.j;
        }
    }

    private void decoderInterpolateLsp(short[] syntDenum, int syntDenumIndex, short[] weightDenum, int weightDenumIndex, short[] lsfDeq, int lsfDeqIndex, short length) {
        short[] lp = this.tempMemory;
        this.tempIndex2 = lsfDeqIndex + length;
        this.len = length + 1;
        if (this.decoderState.DECODER_MODE == 30) {
            this.lspInterpolate2PolyDec(lp, 86, this.decoderState.getLsfDeqOld(), 0, lsfDeq, lsfDeqIndex, Constants.LSF_WEIGHT_30MS[0], length);
            System.arraycopy(lp, 86, syntDenum, syntDenumIndex, this.len);
            BasicFunctions.expand(weightDenum, weightDenumIndex, lp, 86, Constants.LPC_CHIRP_SYNT_DENUM, this.len);
            this.tempIndex1 = this.len;
            this.s = 1;
            while (this.s < 6) {
                this.lspInterpolate2PolyDec(lp, 86, lsfDeq, lsfDeqIndex, lsfDeq, this.tempIndex2, Constants.LSF_WEIGHT_30MS[this.i], length);
                System.arraycopy(lp, 86, syntDenum, syntDenumIndex + this.tempIndex1, this.len);
                BasicFunctions.expand(weightDenum, weightDenumIndex + this.tempIndex1, lp, 86, Constants.LPC_CHIRP_SYNT_DENUM, this.len);
                this.tempIndex1 += this.len;
                ++this.s;
            }
        } else {
            this.tempIndex1 = 0;
            this.s = 0;
            while (this.s < this.decoderState.SUBFRAMES) {
                this.lspInterpolate2PolyDec(lp, 86, this.decoderState.getLsfDeqOld(), 0, lsfDeq, lsfDeqIndex, Constants.LSF_WEIGHT_20MS[this.i], length);
                System.arraycopy(lp, 86, syntDenum, syntDenumIndex + this.tempIndex1, this.len);
                BasicFunctions.expand(weightDenum, weightDenumIndex + this.tempIndex1, lp, 86, Constants.LPC_CHIRP_SYNT_DENUM, this.len);
                this.tempIndex1 += this.len;
                ++this.s;
            }
        }
        if (this.decoderState.DECODER_MODE == 30) {
            System.arraycopy(lsfDeq, this.tempIndex2, this.decoderState.getLsfDeqOld(), 0, length);
        } else {
            System.arraycopy(lsfDeq, lsfDeqIndex, this.decoderState.getLsfDeqOld(), 0, length);
        }
    }

    private void simpleLsfDeq(short[] lsfDeq, int lsfDeqIndex, short[] index, int indexIndex) {
        this.i = 0;
        while (this.i < 3) {
            this.tempIndex2 = Constants.LSF_INDEX_CB[this.i];
            this.j = 0;
            while (this.j < Constants.LSF_DIM_CB[this.i]) {
                lsfDeq[lsfDeqIndex++] = Constants.LSF_CB[this.tempIndex2 + index[indexIndex] * Constants.LSF_DIM_CB[this.i] + this.j];
                ++this.j;
            }
            ++indexIndex;
            ++this.i;
        }
        if (this.decoderState.LPC_N > 1) {
            this.tempIndex3 = 3 + indexIndex;
            this.i = 0;
            while (this.i < 3) {
                this.tempIndex2 = Constants.LSF_INDEX_CB[this.i];
                this.j = 0;
                while (this.j < Constants.LSF_DIM_CB[this.i]) {
                    lsfDeq[lsfDeqIndex++] = Constants.LSF_CB[this.tempIndex2 + index[indexIndex] * Constants.LSF_DIM_CB[this.i] + this.j];
                    ++this.j;
                }
                ++indexIndex;
                ++this.i;
            }
        }
    }

    private void lspInterpolate2PolyDec(short[] a, int aIndex, short[] lsf1, int lsf1Index, short[] lsf2, int lsf2Index, short coef, int length) {
        short[] lsfTemp = this.tempMemory;
        this.interpolate(lsfTemp, 97, lsf1, lsf1Index, lsf2, lsf2Index, coef, length);
        this.lsf2Poly(a, aIndex, lsfTemp, 97);
    }

    private void lsfCheck(short[] lsf, int lsfIndex, int lsfSize) {
        this.n = 0;
        while (this.n < 2) {
            this.j = 0;
            while (this.j < this.decoderState.LPC_N) {
                this.k = 0;
                while (this.k < lsfSize - 1) {
                    this.tempIndex1 = lsfIndex + this.j * lsfSize + this.k;
                    this.tempIndex2 = this.tempIndex1 + 1;
                    if (lsf[this.tempIndex2] - lsf[this.tempIndex1] < 319) {
                        if (lsf[this.tempIndex2] < lsf[this.tempIndex1]) {
                            lsf[this.tempIndex2] = (short)(lsf[this.tempIndex1] + 160);
                            lsf[this.tempIndex1] = (short)(lsf[this.tempIndex2] - 160);
                        } else {
                            int n = this.tempIndex1;
                            lsf[n] = (short)(lsf[n] - 160);
                            int n2 = this.tempIndex2;
                            lsf[n2] = (short)(lsf[n2] + 160);
                        }
                    }
                    if (lsf[this.tempIndex1] < 82) {
                        lsf[this.tempIndex1] = 82;
                    }
                    if (lsf[this.tempIndex1] > 25723) {
                        lsf[this.tempIndex1] = 25723;
                    }
                    ++this.k;
                }
                ++this.j;
            }
            ++this.n;
        }
    }

    private void updateDecIndex() {
        short[] index = this.encoderBits.getCbIndex();
        this.k = 4;
        while (this.k < 6) {
            if (index[this.k] >= 44 && index[this.k] < 108) {
                int n = this.k;
                index[n] = (short)(index[n] + 64);
            } else if (index[this.k] >= 108 && index[this.k] < 128) {
                int n = this.k;
                index[n] = (short)(index[n] + 128);
            }
            ++this.k;
        }
    }

    private void unpackBits(short[] data, int mode) {
        short[] lsf = this.encoderBits.getLSF();
        short[] cbIndex = this.encoderBits.getCbIndex();
        short[] gainIndex = this.encoderBits.getGainIndex();
        short[] idxVec = this.encoderBits.getIdxVec();
        this.tempIndex1 = 0;
        lsf[0] = (short)(data[this.tempIndex1] >> 10 & 0x3F);
        lsf[1] = (short)(data[this.tempIndex1] >> 3 & 0x7F);
        lsf[2] = (short)((data[this.tempIndex1] & 7) << 4);
        ++this.tempIndex1;
        lsf[2] = (short)(lsf[2] | data[this.tempIndex1] >> 12 & 0xF);
        if (mode == 20) {
            this.encoderBits.setStartIdx((short)(data[this.tempIndex1] >> 10 & 3));
            this.encoderBits.setStateFirst(false);
            if ((data[this.tempIndex1] >> 9 & 1) != 0) {
                this.encoderBits.setStateFirst(true);
            }
            this.encoderBits.setIdxForMax((short)(data[this.tempIndex1] >> 3 & 0x3F));
            cbIndex[0] = (short)((data[this.tempIndex1] & 7) << 4);
            ++this.tempIndex1;
            cbIndex[0] = (short)(cbIndex[0] | data[this.tempIndex1] >> 12 & 0xE);
            gainIndex[0] = (short)(data[this.tempIndex1] >> 8 & 0x18);
            gainIndex[1] = (short)(data[this.tempIndex1] >> 7 & 8);
            cbIndex[3] = (short)(data[this.tempIndex1] >> 2 & 0xFE);
            gainIndex[3] = (short)(data[this.tempIndex1] << 2 & 0x10);
            gainIndex[4] = (short)(data[this.tempIndex1] << 2 & 8);
            gainIndex[6] = (short)(data[this.tempIndex1] << 4 & 0x10);
        } else {
            lsf[3] = (short)(data[this.tempIndex1] >> 6 & 0x3F);
            lsf[4] = (short)(data[this.tempIndex1] << 1 & 0x7E);
            ++this.tempIndex1;
            lsf[4] = (short)(lsf[4] | data[this.tempIndex1] >> 15 & 1);
            lsf[5] = (short)(data[this.tempIndex1] >> 8 & 0x7F);
            this.encoderBits.setStartIdx((short)(data[this.tempIndex1] >> 5 & 7));
            this.encoderBits.setStateFirst(false);
            if ((short)(data[this.tempIndex1] >> 4 & 1) != 0) {
                this.encoderBits.setStateFirst(true);
            }
            this.tempS = (short)(data[this.tempIndex1] << 2 & 0x3C);
            ++this.tempIndex1;
            this.tempS = (short)(this.tempS | data[this.tempIndex1] >> 14 & 3);
            this.encoderBits.setIdxForMax(this.tempS);
            cbIndex[0] = (short)(data[this.tempIndex1] >> 7 & 0x78);
            gainIndex[0] = (short)(data[this.tempIndex1] >> 5 & 0x10);
            gainIndex[1] = (short)(data[this.tempIndex1] >> 5 & 8);
            cbIndex[3] = (short)(data[this.tempIndex1] & 0xFC);
            gainIndex[3] = (short)(data[this.tempIndex1] << 3 & 0x10);
            gainIndex[4] = (short)(data[this.tempIndex1] << 3 & 8);
        }
        ++this.tempIndex1;
        this.tempIndex2 = 0;
        this.k = 0;
        while (this.k < 3) {
            this.i = 15;
            while (this.i >= 0) {
                idxVec[this.tempIndex2++] = (short)(data[this.tempIndex1] >> this.i << 2 & 4);
                --this.i;
            }
            ++this.tempIndex1;
            ++this.k;
        }
        if (mode == 20) {
            this.i = 15;
            while (this.i > 6) {
                idxVec[this.tempIndex2++] = (short)(data[this.tempIndex1] >> this.i << 2 & 4);
                --this.i;
            }
            gainIndex[1] = (short)(gainIndex[1] | data[this.tempIndex1] >> 4 & 4);
            gainIndex[3] = (short)(gainIndex[3] | data[this.tempIndex1] >> 2 & 0xC);
            gainIndex[4] = (short)(gainIndex[4] | data[this.tempIndex1] >> 1 & 4);
            gainIndex[6] = (short)(gainIndex[6] | data[this.tempIndex1] << 1 & 8);
            gainIndex[7] = (short)(data[this.tempIndex1] << 2 & 0xC);
        } else {
            this.i = 15;
            while (this.i > 5) {
                idxVec[this.tempIndex2++] = (short)(data[this.tempIndex1] >> this.i << 2 & 4);
                --this.i;
            }
            cbIndex[0] = (short)(cbIndex[0] | data[this.tempIndex1] >> 3 & 6);
            gainIndex[0] = (short)(gainIndex[0] | data[this.tempIndex1] & 8);
            gainIndex[1] = (short)(gainIndex[1] | data[this.tempIndex1] & 4);
            cbIndex[3] = (short)(cbIndex[3] | data[this.tempIndex1] & 2);
            cbIndex[6] = (short)(data[this.tempIndex1] << 7 & 0x80);
            ++this.tempIndex1;
            cbIndex[6] = (short)(cbIndex[6] | data[this.tempIndex1] >> 9 & 0x7E);
            cbIndex[9] = (short)(data[this.tempIndex1] >> 2 & 0xFE);
            cbIndex[12] = (short)(data[this.tempIndex1] << 5 & 0xE0);
            ++this.tempIndex1;
            cbIndex[12] = (short)(cbIndex[12] | data[this.tempIndex1] >> 11 & 0x1E);
            gainIndex[3] = (short)(gainIndex[3] | data[this.tempIndex1] >> 8 & 0xC);
            gainIndex[4] = (short)(gainIndex[4] | data[this.tempIndex1] >> 7 & 6);
            gainIndex[6] = (short)(data[this.tempIndex1] >> 3 & 0x18);
            gainIndex[7] = (short)(data[this.tempIndex1] >> 2 & 0xC);
            gainIndex[9] = (short)(data[this.tempIndex1] << 1 & 0x10);
            gainIndex[10] = (short)(data[this.tempIndex1] << 1 & 8);
            gainIndex[12] = (short)(data[this.tempIndex1] << 3 & 0x10);
            gainIndex[13] = (short)(data[this.tempIndex1] << 3 & 8);
        }
        ++this.tempIndex1;
        this.tempIndex2 = 0;
        this.k = 0;
        while (this.k < 7) {
            this.i = 14;
            while (this.i >= 0) {
                int n = this.tempIndex2++;
                idxVec[n] = (short)(idxVec[n] | data[this.tempIndex1] >> this.i & 3);
                this.i -= 2;
            }
            ++this.tempIndex1;
            ++this.k;
        }
        if (mode == 20) {
            idxVec[56] = (short)(idxVec[56] | data[this.tempIndex1] >> 14 & 3);
            cbIndex[0] = (short)(cbIndex[0] | data[this.tempIndex1] >> 13 & 1);
            cbIndex[1] = (short)(data[this.tempIndex1] >> 6 & 0x7F);
            cbIndex[2] = (short)(data[this.tempIndex1] << 1 & 0x7E);
            ++this.tempIndex1;
            cbIndex[2] = (short)(cbIndex[2] | data[this.tempIndex1] >> 15 & 1);
            gainIndex[0] = (short)(gainIndex[0] | data[this.tempIndex1] >> 12 & 7);
            gainIndex[1] = (short)(gainIndex[1] | data[this.tempIndex1] >> 10 & 3);
            gainIndex[2] = (short)(data[this.tempIndex1] >> 7 & 7);
            cbIndex[3] = (short)(cbIndex[3] | data[this.tempIndex1] >> 6 & 1);
            cbIndex[4] = (short)(data[this.tempIndex1] << 1 & 0x7E);
            ++this.tempIndex1;
            cbIndex[4] = (short)(cbIndex[4] | data[this.tempIndex1] >> 15 & 1);
            cbIndex[5] = (short)(data[this.tempIndex1] >> 8 & 0x7F);
            cbIndex[6] = (short)(data[this.tempIndex1] & 0xFF);
            ++this.tempIndex1;
            cbIndex[7] = (short)(data[this.tempIndex1] >> 8 & 0xFF);
            cbIndex[8] = (short)(data[this.tempIndex1] & 0xFF);
            ++this.tempIndex1;
            gainIndex[3] = (short)(gainIndex[3] | data[this.tempIndex1] >> 14 & 3);
            gainIndex[4] = (short)(gainIndex[4] | data[this.tempIndex1] >> 12 & 3);
            gainIndex[5] = (short)(data[this.tempIndex1] >> 9 & 7);
            gainIndex[6] = (short)(gainIndex[6] | data[this.tempIndex1] >> 6 & 7);
            gainIndex[7] = (short)(gainIndex[7] | data[this.tempIndex1] >> 4 & 3);
            gainIndex[8] = (short)(data[this.tempIndex1] >> 1 & 7);
        } else {
            idxVec[56] = (short)(idxVec[56] | data[this.tempIndex1] >> 14 & 3);
            idxVec[57] = (short)(idxVec[57] | data[this.tempIndex1] >> 12 & 3);
            cbIndex[0] = (short)(cbIndex[0] | data[this.tempIndex1] >> 11 & 1);
            cbIndex[1] = (short)(data[this.tempIndex1] >> 4 & 0x7F);
            cbIndex[2] = (short)(data[this.tempIndex1] << 3 & 0x78);
            ++this.tempIndex1;
            cbIndex[2] = (short)(cbIndex[2] | data[this.tempIndex1] >> 13 & 7);
            gainIndex[0] = (short)(gainIndex[0] | data[this.tempIndex1] >> 10 & 7);
            gainIndex[1] = (short)(gainIndex[1] | data[this.tempIndex1] >> 8 & 3);
            gainIndex[2] = (short)(data[this.tempIndex1] >> 5 & 7);
            cbIndex[3] = (short)(cbIndex[3] | data[this.tempIndex1] >> 4 & 1);
            cbIndex[4] = (short)(data[this.tempIndex1] << 3 & 0x78);
            ++this.tempIndex1;
            cbIndex[4] = (short)(cbIndex[4] | data[this.tempIndex1] >> 13 & 7);
            cbIndex[5] = (short)(data[this.tempIndex1] >> 6 & 0x7F);
            cbIndex[6] = (short)(cbIndex[6] | data[this.tempIndex1] >> 5 & 1);
            cbIndex[7] = (short)(data[this.tempIndex1] << 3 & 0xF8);
            ++this.tempIndex1;
            cbIndex[7] = (short)(cbIndex[7] | data[this.tempIndex1] >> 13 & 7);
            cbIndex[8] = (short)(data[this.tempIndex1] >> 5 & 0xFF);
            cbIndex[9] = (short)(cbIndex[9] | data[this.tempIndex1] >> 4 & 1);
            cbIndex[10] = (short)(data[this.tempIndex1] << 4 & 0xF0);
            ++this.tempIndex1;
            cbIndex[10] = (short)(cbIndex[10] | data[this.tempIndex1] >> 12 & 0xF);
            cbIndex[11] = (short)(data[this.tempIndex1] >> 4 & 0xFF);
            cbIndex[12] = (short)(cbIndex[12] | data[this.tempIndex1] >> 3 & 1);
            cbIndex[13] = (short)(data[this.tempIndex1] << 5 & 0xE0);
            ++this.tempIndex1;
            cbIndex[13] = (short)(cbIndex[13] | data[this.tempIndex1] >> 11 & 0x1F);
            cbIndex[14] = (short)(data[this.tempIndex1] >> 3 & 0xFF);
            gainIndex[3] = (short)(gainIndex[3] | data[this.tempIndex1] >> 1 & 3);
            gainIndex[4] = (short)(gainIndex[4] | data[this.tempIndex1] & 1);
            ++this.tempIndex1;
            gainIndex[5] = (short)(data[this.tempIndex1] >> 13 & 7);
            gainIndex[6] = (short)(gainIndex[6] | data[this.tempIndex1] >> 10 & 7);
            gainIndex[7] = (short)(gainIndex[7] | data[this.tempIndex1] >> 8 & 3);
            gainIndex[8] = (short)(data[this.tempIndex1] >> 5 & 7);
            gainIndex[9] = (short)(gainIndex[9] | data[this.tempIndex1] >> 1 & 0xF);
            gainIndex[10] = (short)(gainIndex[10] | data[this.tempIndex1] << 2 & 4);
            ++this.tempIndex1;
            gainIndex[10] = (short)(gainIndex[10] | data[this.tempIndex1] >> 14 & 3);
            gainIndex[11] = (short)(data[this.tempIndex1] >> 11 & 7);
            gainIndex[12] = (short)(gainIndex[12] | data[this.tempIndex1] >> 7 & 0xF);
            gainIndex[13] = (short)(gainIndex[13] | data[this.tempIndex1] >> 4 & 7);
            gainIndex[14] = (short)(data[this.tempIndex1] >> 1 & 7);
        }
    }

    private void cbConstruct(short[] decVector, int decVectorIndex, short[] mem, int memIndex, short length, short vectorLength, int cbIndexIndex, int gainIndexIndex) {
        short[] cbIndex = this.encoderBits.getCbIndex();
        short[] gainIndex = this.encoderBits.getGainIndex();
        short[] gain = this.tempMemory;
        short[] cbVec0 = this.tempMemory;
        short[] cbVec1 = this.tempMemory;
        short[] cbVec2 = this.tempMemory;
        gain[86] = this.gainDequant(gainIndex[gainIndexIndex], (short)16384, (short)0);
        gain[87] = this.gainDequant(gainIndex[gainIndexIndex + 1], gain[86], (short)1);
        gain[88] = this.gainDequant(gainIndex[gainIndexIndex + 2], gain[87], (short)2);
        this.i = 0;
        while (this.i < 40) {
            cbVec0[89 + this.i] = 0;
            cbVec1[129 + this.i] = 0;
            cbVec2[169 + this.i] = 0;
            ++this.i;
        }
        this.getCbVec(cbVec0, 89, mem, memIndex, cbIndex[cbIndexIndex], length, vectorLength);
        this.getCbVec(cbVec1, 129, mem, memIndex, cbIndex[cbIndexIndex + 1], length, vectorLength);
        this.getCbVec(cbVec2, 169, mem, memIndex, cbIndex[cbIndexIndex + 2], length, vectorLength);
        this.tempIndex5 = 89;
        this.tempIndex6 = 129;
        this.tempIndex7 = 169;
        this.i = 0;
        while (this.i < vectorLength) {
            this.temp = gain[86] * cbVec0[this.tempIndex5++];
            this.temp += gain[87] * cbVec1[this.tempIndex6++];
            this.temp += gain[88] * cbVec2[this.tempIndex7++];
            this.tempShift = this.temp + 8192 >> 14;
            decVector[decVectorIndex++] = (short)this.tempShift;
            ++this.i;
        }
    }

    private short gainDequant(short index, short maxIn, short stage) {
        if (maxIn < 0) {
            maxIn = (short)(0 - maxIn);
        }
        if (maxIn < 1638) {
            maxIn = (short)1638;
        }
        return (short)(maxIn * Constants.GAIN[stage][index] + 8192 >> 14);
    }

    private void getCbVec(short[] cbVec, int cbVecIndex, short[] mem, int memIndex, short index, int length, int vectorLength) {
        short[] tempbuff2 = this.tempMemory;
        this.baseSize = (short)(length - vectorLength + 1);
        if (vectorLength == 40) {
            this.baseSize = (short)(this.baseSize + (vectorLength >> 1));
        }
        if (index < length - vectorLength + 1) {
            this.k = index + vectorLength;
            System.arraycopy(mem, memIndex + length - this.k, cbVec, cbVecIndex, vectorLength);
        } else if (index < this.baseSize) {
            this.k = 2 * (index - (length - vectorLength + 1)) + vectorLength;
            this.createAugmentVector((short)(this.k >> 1), mem, memIndex + length, cbVec, cbVecIndex);
        } else if (index - this.baseSize < length - vectorLength + 1) {
            this.tempIndex7 = memIndex - 4;
            this.n = 0;
            while (this.n < 4) {
                mem[this.tempIndex7++] = 0;
                ++this.n;
            }
            this.tempIndex7 = memIndex + length;
            this.n = 0;
            while (this.n < 4) {
                mem[this.tempIndex7++] = 0;
                ++this.n;
            }
            BasicFunctions.filterMA(mem, memIndex + length - (index - this.baseSize + vectorLength) + 4, cbVec, cbVecIndex, Constants.CB_FILTERS_REV, 0, 8, vectorLength);
        } else {
            this.tempIndex7 = memIndex + length;
            this.n = 0;
            while (this.n < 4) {
                mem[this.tempIndex7++] = 0;
                ++this.n;
            }
            BasicFunctions.filterMA(mem, memIndex + length - vectorLength - 1, tempbuff2, 209, Constants.CB_FILTERS_REV, 0, 8, vectorLength + 5);
            this.createAugmentVector((short)((vectorLength << 1) - 20 + index - this.baseSize - length - 1), tempbuff2, 254, cbVec, cbVecIndex);
        }
    }

    private void createAugmentVector(short index, short[] buf, int bufIndex, short[] cbVec, int cbVecIndex) {
        short[] cbVecTmp = this.tempMemory;
        this.tempIndex7 = cbVecIndex + index - 4;
        System.arraycopy(buf, bufIndex - index, cbVec, cbVecIndex, index);
        BasicFunctions.multWithRightShift(cbVec, this.tempIndex7, buf, bufIndex - index - 4, Constants.ALPHA, 0, 4, 15);
        BasicFunctions.reverseMultiplyRight(cbVecTmp, 254, buf, bufIndex - 4, Constants.ALPHA, 3, 4, 15);
        BasicFunctions.addWithRightShift(cbVec, this.tempIndex7, cbVec, this.tempIndex7, cbVecTmp, 254, 4, 0);
        System.arraycopy(buf, bufIndex - index, cbVec, cbVecIndex + index, 40 - index);
    }

    private void stateConstruct(short[] syntDenum, int syntDenumIndex, short[] outFix, int outFixIndex) {
        short[] numerator = this.tempMemory;
        short[] sampleValVec = this.tempMemory;
        short[] sampleMaVec = this.tempMemory;
        short[] sampleVal = this.tempMemory;
        short[] sampleMa = this.tempMemory;
        short[] sampleAr = this.tempMemory;
        short[] idxVec = this.encoderBits.getIdxVec();
        this.tempIndex1 = 86;
        this.tempIndex2 = syntDenumIndex + 10;
        this.k = 0;
        while (this.k < 11) {
            numerator[this.tempIndex1++] = syntDenum[this.tempIndex2--];
            ++this.k;
        }
        this.max = Constants.FRQ_QUANT_MOD[this.encoderBits.getIdxForMax()];
        this.tempIndex1 = 107;
        this.tempIndex2 = this.decoderState.STATE_SHORT_LEN - 1;
        if (this.encoderBits.getIdxForMax() < 37) {
            this.k = 0;
            while (this.k < this.decoderState.STATE_SHORT_LEN) {
                sampleVal[this.tempIndex1++] = (short)(this.max * Constants.STATE_SQ3[idxVec[this.tempIndex2--]] + 0x200000 >> 22);
                ++this.k;
            }
        } else if (this.encoderBits.getIdxForMax() < 59) {
            this.k = 0;
            while (this.k < this.decoderState.STATE_SHORT_LEN) {
                sampleVal[this.tempIndex1++] = (short)(this.max * Constants.STATE_SQ3[idxVec[this.tempIndex2--]] + 262144 >> 19);
                ++this.k;
            }
        } else {
            this.k = 0;
            while (this.k < this.decoderState.STATE_SHORT_LEN) {
                sampleVal[this.tempIndex1++] = (short)(this.max * Constants.STATE_SQ3[idxVec[this.tempIndex2--]] + 65536 >> 17);
                ++this.k;
            }
        }
        this.tempIndex1 = 107 + this.decoderState.STATE_SHORT_LEN;
        this.i = 0;
        while (this.i < this.decoderState.STATE_SHORT_LEN) {
            sampleVal[this.tempIndex1++] = 0;
            ++this.i;
        }
        this.tempIndex1 = 97;
        this.i = 0;
        while (this.i < 10) {
            sampleValVec[this.tempIndex1++] = 0;
            ++this.i;
        }
        BasicFunctions.filterMA(sampleVal, 107, sampleMa, 233, numerator, 86, 11, 11 + this.decoderState.STATE_SHORT_LEN);
        this.tempIndex1 = 243 + this.decoderState.STATE_SHORT_LEN;
        this.i = 0;
        while (this.i < this.decoderState.STATE_SHORT_LEN - 10) {
            sampleMa[this.tempIndex1++] = 0;
            ++this.i;
        }
        BasicFunctions.filterAR(sampleMa, 233, sampleAr, 107, syntDenum, syntDenumIndex, 11, 2 * this.decoderState.STATE_SHORT_LEN);
        this.tempIndex1 = 107 + this.decoderState.STATE_SHORT_LEN - 1;
        this.tempIndex2 = 107 + 2 * this.decoderState.STATE_SHORT_LEN - 1;
        this.tempIndex3 = outFixIndex;
        this.k = 0;
        while (this.k < this.decoderState.STATE_SHORT_LEN) {
            outFix[this.tempIndex3++] = (short)(sampleAr[this.tempIndex1--] + sampleAr[this.tempIndex2--]);
            ++this.k;
        }
    }
}

