/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.codec.ilbc;

public class BasicFunctions {
    public static short abs(short var1) {
        if (var1 == Short.MIN_VALUE) {
            return Short.MAX_VALUE;
        }
        if (var1 < 0) {
            return -var1;
        }
        return var1;
    }

    public static short getSize(int var1) throws ArithmeticException {
        short count = (0xFFFF0000 & var1) != 0 ? (short)16 : 0;
        if ((0xFF00 & var1 >> count) != 0) {
            count = (short)(count + 8);
        }
        if ((0xF0 & var1 >> count) != 0) {
            count = (short)(count + 4);
        }
        if ((0xC & var1 >> count) != 0) {
            count = (short)(count + 2);
        }
        if ((2 & var1 >> count) != 0) {
            count = (short)(count + 1);
        }
        if ((1 & var1 >> count) != 0) {
            count = (short)(count + 1);
        }
        return count;
    }

    public static short norm(int var1) throws ArithmeticException {
        short count = 0;
        int currValue = var1;
        if (currValue <= 0) {
            currValue ^= 0xFFFFFFFF;
        }
        if ((0xFF800000 & currValue << (count = (Short.MIN_VALUE & currValue) == 0 ? (short)16 : 0)) == 0) {
            count = (short)(count + 8);
        }
        if ((0xF8000000 & currValue << count) == 0) {
            count = (short)(count + 4);
        }
        if ((0xE0000000 & currValue << count) == 0) {
            count = (short)(count + 2);
        }
        if ((0xC0000000 & currValue << count) == 0) {
            count = (short)(count + 1);
        }
        return count;
    }

    public static int div(int num, short hi, short low) {
        int approx = hi != 0 ? 0x1FFFFFFF / hi : Integer.MAX_VALUE;
        int tempL = hi * approx;
        int temp = tempL <<= 1;
        tempL = low * approx;
        tempL >>= 15;
        temp += (tempL <<= 1);
        temp = Integer.MAX_VALUE - temp;
        short temp1 = (short)(temp >> 16);
        int tempShift = temp1 << 16;
        short temp2 = (short)(temp - tempShift >> 1);
        temp = tempL = temp1 * approx;
        tempL = temp2 * approx;
        temp += (tempL >>= 15);
        temp1 = (short)((temp <<= 1) >> 16);
        tempShift = temp1 << 16;
        temp2 = (short)(temp - tempShift >> 1);
        short numHi = (short)(num >> 16);
        tempShift = numHi << 16;
        short numLow = (short)(num - tempShift >> 1);
        temp = tempL = numHi * temp1;
        tempL = numHi * temp2;
        temp += (tempL >>= 15);
        tempL = numLow * temp1;
        temp += (tempL >>= 15);
        return temp <<= 3;
    }

    public static short getMaxAbsValue(short[] input, int inputIndex, int length) {
        short currValue = 0;
        int total = inputIndex + length;
        for (int i = inputIndex; i < total; ++i) {
            if (input[i] > 0 && input[i] > currValue) {
                currValue = input[i];
                continue;
            }
            if (input[i] >= 0 || 0 - input[i] <= currValue) continue;
            currValue = (short)(0 - input[i]);
        }
        return currValue;
    }

    public static int scaleRight(short[] input1, int input1Index, short[] input2, int input2Index, int length, int rightShifts) {
        int sum = 0;
        for (int n = 0; n < length; ++n) {
            sum += input1[input1Index++] * input2[input2Index++] >> rightShifts;
        }
        return sum;
    }

    public static int scaleLeft(short[] input1, int input1Index, short[] input2, int input2Index, int length, int leftShifts) {
        int sum = 0;
        for (int n = 0; n < length; ++n) {
            sum += input1[input1Index++] * input2[input2Index++] << leftShifts;
        }
        return sum;
    }

    public static void scaleVector(short[] input, int inputIndex, short[] output, int outputIndex, short gain, int length, int rightShifts) {
        for (int i = 0; i < length; ++i) {
            int temp;
            output[outputIndex++] = (temp = input[inputIndex++] * gain >> rightShifts) > Short.MAX_VALUE ? Short.MAX_VALUE : (temp < Short.MIN_VALUE ? Short.MIN_VALUE : (short)temp);
        }
    }

    public static void multWithRightShift(short[] output, int outputIndex, short[] input1, int input1Index, short[] input2, int input2Index, int length, int rightShifts) {
        for (int n = 0; n < length; ++n) {
            output[outputIndex++] = (short)(input1[input1Index++] * input2[input2Index++] >> rightShifts);
        }
    }

    public static void multWithLeftShift(short[] output, int outputIndex, short[] input1, int input1Index, short[] input2, int input2Index, int length, int leftShifts) {
        for (int n = 0; n < length; ++n) {
            output[outputIndex++] = (short)(input1[input1Index++] * input2[input2Index++] << leftShifts);
        }
    }

    public static void reverseMultiplyRight(short[] out, int outIndex, short[] in, int inIndex, short[] win, int winIndex, int length, int rightShifts) {
        for (int n = 0; n < length; ++n) {
            out[outIndex++] = (short)(in[inIndex++] * win[winIndex--] >> rightShifts);
        }
    }

    public static void reverseMultiplyLeft(short[] out, int outIndex, short[] in, int inIndex, short[] win, int winIndex, int length, int leftShifts) {
        for (int n = 0; n < length; ++n) {
            out[outIndex++] = (short)(in[inIndex++] * win[winIndex--] << leftShifts);
        }
    }

    public static void bitShiftRight(int[] output, int outputIndex, int[] input, int inputIndex, int length, int rightShifts) {
        for (int n = 0; n < length; ++n) {
            output[outputIndex++] = input[inputIndex++] >> rightShifts;
        }
    }

    public static void bitShiftLeft(int[] output, int outputIndex, int[] input, int inputIndex, int length, int leftShifts) {
        for (int n = 0; n < length; ++n) {
            output[outputIndex++] = input[inputIndex++] << leftShifts;
        }
    }

    public static void addWithRightShift(short[] out, int outIndex, short[] in1, int in1Index, short[] in2, int in2Index, int length, int rightShifts) {
        for (int i = length; i > 0; --i) {
            out[outIndex++] = (short)(in1[in1Index++] + in2[in2Index++] >> rightShifts);
        }
    }

    public static void addWithLeftShift(short[] out, int outIndex, short[] in1, int in1Index, short[] in2, int in2Index, int length, int leftShifts) {
        for (int i = length; i > 0; --i) {
            out[outIndex++] = (short)(in1[in1Index++] + in2[in2Index++] << leftShifts);
        }
    }

    public static void addAffineVectorToVector(short[] out, int outIndex, short[] in, int inIndex, short gain, int addConstant, short rightShifts, int length) {
        for (int n = 0; n < length; ++n) {
            int n2 = outIndex++;
            out[n2] = (short)(out[n2] + (short)(in[inIndex++] * gain + addConstant >> rightShifts));
        }
    }

    public static void expand(short[] output, int outputIndex, short[] input, int inputIndex, short[] coeficient, int length) {
        output[outputIndex++] = input[inputIndex++];
        for (int i = 1; i < length; ++i) {
            output[outputIndex++] = (short)(coeficient[i] * input[inputIndex++] + 16384 >> 15);
        }
    }

    public static void reverseCopy(short[] dest, int destIndex, short[] source, int sourceIndex, int length) {
        while (length > 0) {
            dest[destIndex--] = source[sourceIndex++];
            --length;
        }
    }

    public static void filterMA(short[] input, int inputIndex, short[] output, int outputIndex, short[] B, int bIndex, int bLength, int length) {
        for (int i = 0; i < length; ++i) {
            int temp2 = inputIndex + i;
            int temp1 = bIndex;
            int o = 0;
            for (int j = 0; j < bLength; ++j) {
                o += B[temp1++] * input[temp2--];
            }
            if (o > 0x7FFF7FF) {
                o = 0x7FFF7FF;
            } else if (o < -134217728) {
                o = -134217728;
            }
            output[outputIndex++] = (short)(o + 2048 >> 12);
        }
    }

    public static void filterAR(short[] input, int inputIndex, short[] output, int outputIndex, short[] coefs, int coefsIndex, int coefsLength, int length) {
        int result = 0;
        int sum = 0;
        for (int i = 0; i < length; ++i) {
            result = 0;
            sum = 0;
            int temp2 = outputIndex + i - coefsLength + 1;
            int temp3 = coefsIndex + coefsLength - 1;
            for (int j = coefsLength - 1; j > 0; --j) {
                sum += coefs[temp3--] * output[temp2++];
            }
            result = coefs[coefsIndex] * input[inputIndex++];
            if ((result -= sum) > 0x7FFF7FF) {
                result = 0x7FFF7FF;
            } else if (result < -134217728) {
                result = -134217728;
            }
            output[temp2] = (short)(result + 2048 >> 12);
        }
    }
}

