/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.codec.l16;

import org.restcomm.media.spi.dsp.Codec;
import org.restcomm.media.spi.format.Format;
import org.restcomm.media.spi.format.FormatFactory;
import org.restcomm.media.spi.memory.Frame;
import org.restcomm.media.spi.memory.Memory;

public class Decoder
implements Codec {
    private static final Format l16 = FormatFactory.createAudioFormat((String)"l16", (int)8000, (int)16, (int)1);
    private static final Format linear = FormatFactory.createAudioFormat((String)"linear", (int)8000, (int)16, (int)1);

    public Frame process(Frame frame) {
        Frame res = Memory.allocate((int)frame.getData().length);
        System.arraycopy(frame.getData(), 0, res.getData(), 0, frame.getData().length);
        res.setOffset(0);
        res.setLength(frame.getData().length);
        res.setTimestamp(frame.getTimestamp());
        res.setDuration(frame.getDuration());
        res.setSequenceNumber(frame.getSequenceNumber());
        res.setEOM(frame.isEOM());
        res.setFormat(linear);
        return res;
    }

    public Format getSupportedInputFormat() {
        return l16;
    }

    public Format getSupportedOutputFormat() {
        return linear;
    }
}

