/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.component.audio;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.restcomm.media.component.audio.AudioInput;
import org.restcomm.media.component.audio.AudioOutput;
import org.restcomm.media.concurrent.ConcurrentMap;
import org.restcomm.media.spi.format.AudioFormat;
import org.restcomm.media.spi.format.Format;
import org.restcomm.media.spi.format.FormatFactory;
import org.restcomm.media.spi.memory.Frame;
import org.restcomm.media.spi.memory.Memory;

public class AudioComponent {
    private static final AudioFormat FORMAT = FormatFactory.createAudioFormat((String)"LINEAR", (int)8000, (int)16, (int)1);
    private static final long PERIOD = 20000000L;
    private static final int PACKET_SIZE = 20 * FORMAT.getSampleRate() / 1000 * FORMAT.getSampleSize() / 8;
    private final int componentId;
    private final ConcurrentMap<AudioInput> inputs;
    private final ConcurrentMap<AudioOutput> outputs;
    protected final AtomicBoolean shouldRead;
    protected final AtomicBoolean shouldWrite;
    private final int[] data;
    final AtomicBoolean first;

    public AudioComponent(int componentId) {
        this.componentId = componentId;
        this.inputs = new ConcurrentMap();
        this.outputs = new ConcurrentMap();
        this.shouldRead = new AtomicBoolean(false);
        this.shouldWrite = new AtomicBoolean(false);
        this.data = new int[PACKET_SIZE / 2];
        this.first = new AtomicBoolean(false);
    }

    public int getComponentId() {
        return this.componentId;
    }

    public void updateMode(boolean shouldRead, boolean shouldWrite) {
        this.shouldRead.set(shouldRead);
        this.shouldWrite.set(shouldWrite);
    }

    public void addInput(AudioInput input) {
        this.inputs.put((Object)input.getInputId(), (Object)input);
    }

    public void addOutput(AudioOutput output) {
        this.outputs.put((Object)output.getOutputId(), (Object)output);
    }

    public void remove(AudioInput input) {
        this.inputs.remove((Object)input.getInputId());
    }

    public void remove(AudioOutput output) {
        this.outputs.remove((Object)output.getOutputId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform() {
        this.first.set(true);
        Iterator activeInputs = this.inputs.valuesIterator();
        while (activeInputs.hasNext()) {
            AudioInput input = (AudioInput)activeInputs.next();
            Frame inputFrame = input.poll();
            if (inputFrame == null) continue;
            try {
                byte[] dataArray = inputFrame.getData();
                int inputIndex = 0;
                for (int inputCount = 0; inputCount < dataArray.length; inputCount += 2) {
                    this.data[inputIndex++] = (short)(dataArray[inputCount + 1] << 8 | dataArray[inputCount] & 0xFF);
                }
                if (!this.first.get()) continue;
                this.first.set(false);
            }
            finally {
                inputFrame.recycle();
            }
        }
    }

    public int[] getData() {
        if (!this.shouldRead.get()) {
            return null;
        }
        if (this.first.get()) {
            return null;
        }
        return this.data;
    }

    public void offer(int[] data) {
        if (!this.shouldWrite.get()) {
            return;
        }
        Frame outputFrame = Memory.allocate((int)PACKET_SIZE);
        byte[] dataArray = outputFrame.getData();
        int outputIndex = 0;
        int outputCount = 0;
        while (outputCount < data.length) {
            dataArray[outputIndex++] = (byte)data[outputCount];
            dataArray[outputIndex++] = (byte)(data[outputCount++] >> 8);
        }
        outputFrame.setOffset(0);
        outputFrame.setLength(PACKET_SIZE);
        outputFrame.setDuration(20000000L);
        outputFrame.setFormat((Format)FORMAT);
        Iterator activeOutputs = this.outputs.valuesIterator();
        while (activeOutputs.hasNext()) {
            AudioOutput output = (AudioOutput)activeOutputs.next();
            if (!activeOutputs.hasNext()) {
                output.offer(outputFrame);
            } else {
                output.offer(outputFrame.clone());
            }
            output.wakeup();
        }
    }
}

