/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.component.oob;

import java.io.IOException;
import org.restcomm.media.component.AbstractSink;
import org.restcomm.media.concurrent.ConcurrentCyclicFIFO;
import org.restcomm.media.spi.memory.Frame;

public class OOBInput
extends AbstractSink {
    private static final long serialVersionUID = -5568937038806140983L;
    private int inputId;
    private int limit = 10;
    private ConcurrentCyclicFIFO<Frame> buffer = new ConcurrentCyclicFIFO();

    public OOBInput(int inputId) {
        super("compound.input");
        this.inputId = inputId;
    }

    public int getInputId() {
        return this.inputId;
    }

    @Override
    public void activate() {
    }

    @Override
    public void deactivate() {
    }

    @Override
    public void onMediaTransfer(Frame frame) throws IOException {
        if (this.buffer.size() >= this.limit) {
            ((Frame)this.buffer.poll()).recycle();
        }
        this.buffer.offer((Object)frame);
    }

    public boolean isEmpty() {
        return this.buffer.size() == 0;
    }

    public Frame poll() {
        return (Frame)this.buffer.poll();
    }

    public void recycle() {
        while (this.buffer.size() > 0) {
            ((Frame)this.buffer.poll()).recycle();
        }
    }

    public void resetBuffer() {
        while (this.buffer.size() > 0) {
            ((Frame)this.buffer.poll()).recycle();
        }
    }
}

