/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.component.oob;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.restcomm.media.component.oob.OOBComponent;
import org.restcomm.media.concurrent.ConcurrentMap;
import org.restcomm.media.scheduler.PriorityQueueScheduler;
import org.restcomm.media.scheduler.Task;
import org.restcomm.media.spi.memory.Frame;

public class OOBMixer {
    private final PriorityQueueScheduler scheduler;
    private final ConcurrentMap<OOBComponent> components;
    private final MixTask mixer;
    private final AtomicBoolean started;
    private final AtomicLong mixCount;

    public OOBMixer(PriorityQueueScheduler scheduler) {
        this.scheduler = scheduler;
        this.components = new ConcurrentMap();
        this.mixer = new MixTask();
        this.started = new AtomicBoolean(false);
        this.mixCount = new AtomicLong(0L);
    }

    public long getMixCount() {
        return this.mixCount.get();
    }

    public void addComponent(OOBComponent component) {
        this.components.put((Object)component.getComponentId(), (Object)component);
    }

    public void release(OOBComponent component) {
        this.components.remove((Object)component.getComponentId());
    }

    public void start() {
        if (!this.started.get()) {
            this.started.set(true);
            this.mixCount.set(0L);
            this.scheduler.submit((Task)this.mixer, PriorityQueueScheduler.MIXER_MIX_QUEUE);
        }
    }

    public void stop() {
        if (this.started.get()) {
            this.started.set(false);
            this.mixer.cancel();
        }
    }

    private final class MixTask
    extends Task {
        public int getQueueNumber() {
            return PriorityQueueScheduler.MIXER_MIX_QUEUE;
        }

        public long perform() {
            OOBComponent component;
            int sourceComponent = 0;
            Frame current = null;
            Iterator activeComponents = OOBMixer.this.components.valuesIterator();
            while (activeComponents.hasNext()) {
                component = (OOBComponent)activeComponents.next();
                component.perform();
                current = component.getData();
                if (current == null) continue;
                sourceComponent = component.getComponentId();
                break;
            }
            if (current == null) {
                OOBMixer.this.scheduler.submit((Task)this, PriorityQueueScheduler.MIXER_MIX_QUEUE);
                OOBMixer.this.mixCount.incrementAndGet();
                return 0L;
            }
            activeComponents = OOBMixer.this.components.valuesIterator();
            while (activeComponents.hasNext()) {
                component = (OOBComponent)activeComponents.next();
                if (component.getComponentId() == sourceComponent) continue;
                component.offer(current.clone());
            }
            current.recycle();
            OOBMixer.this.scheduler.submit((Task)this, PriorityQueueScheduler.MIXER_MIX_QUEUE);
            OOBMixer.this.mixCount.incrementAndGet();
            return 0L;
        }
    }
}

