/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.control.mgcp.connection;

import java.io.IOException;
import org.restcomm.media.component.audio.AudioComponent;
import org.restcomm.media.component.oob.OOBComponent;
import org.restcomm.media.control.mgcp.connection.BaseConnection;
import org.restcomm.media.rtp.ChannelsManager;
import org.restcomm.media.rtp.LocalDataChannel;
import org.restcomm.media.spi.Connection;
import org.restcomm.media.spi.ConnectionFailureListener;
import org.restcomm.media.spi.ConnectionMode;
import org.restcomm.media.spi.ConnectionType;
import org.restcomm.media.spi.ModeNotSupportedException;
import org.restcomm.media.spi.pooling.PooledObject;
import org.restcomm.media.spi.utils.Text;

public class LocalConnectionImpl
extends BaseConnection
implements PooledObject {
    private LocalDataChannel localAudioChannel;

    public LocalConnectionImpl(int id, ChannelsManager channelsManager) {
        super(id, channelsManager.getScheduler());
        this.localAudioChannel = channelsManager.getLocalChannel();
    }

    public void generateCname() {
        throw new UnsupportedOperationException("Not supported!");
    }

    public String getCname() {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public AudioComponent getAudioComponent() {
        return this.localAudioChannel.getAudioComponent();
    }

    @Override
    public OOBComponent getOOBComponent() {
        return this.localAudioChannel.getOOBComponent();
    }

    public void generateOffer(boolean webrtc) throws IOException {
        throw new UnsupportedOperationException("Not supported yet!");
    }

    @Override
    public void setOtherParty(Connection other) throws IOException {
        if (!(other instanceof LocalConnectionImpl)) {
            throw new IOException("Not compatible");
        }
        this.localAudioChannel.join(((LocalConnectionImpl)other).localAudioChannel);
        try {
            this.join();
            ((LocalConnectionImpl)other).join();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void setOtherParty(Text descriptor) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setOtherParty(byte[] descriptor) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public long getPacketsReceived() {
        return 0L;
    }

    public long getBytesReceived() {
        return 0L;
    }

    public long getPacketsTransmitted() {
        return 0L;
    }

    public long getBytesTransmitted() {
        return 0L;
    }

    public String toString() {
        return "Local Connection [" + this.getId() + "]";
    }

    public double getJitter() {
        return 0.0;
    }

    @Override
    public void setConnectionFailureListener(ConnectionFailureListener connectionListener) {
    }

    @Override
    protected void onCreated() throws Exception {
    }

    @Override
    protected void onFailed() {
        this.disconnect();
    }

    @Override
    public void setMode(ConnectionMode mode) throws ModeNotSupportedException {
        this.localAudioChannel.updateMode(mode);
        super.setMode(mode);
    }

    @Override
    protected void onOpened() throws Exception {
    }

    @Override
    protected void onClosed() {
        this.disconnect();
    }

    private void disconnect() {
        try {
            this.setMode(ConnectionMode.INACTIVE);
        }
        catch (ModeNotSupportedException modeNotSupportedException) {
            // empty catch block
        }
        this.localAudioChannel.unjoin();
        this.releaseConnection(ConnectionType.LOCAL);
    }

    public boolean isAvailable() {
        return true;
    }

    public void checkIn() {
    }

    public void checkOut() {
    }
}

