/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.control.mgcp.controller;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.restcomm.media.control.mgcp.MgcpProvider;
import org.restcomm.media.control.mgcp.controller.Matcher;
import org.restcomm.media.control.mgcp.controller.MgcpEndpoint;
import org.restcomm.media.control.mgcp.controller.signal.MgcpPackage;
import org.restcomm.media.control.mgcp.pkg.PackageFactory;
import org.restcomm.media.spi.Endpoint;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Configurator {
    private Matcher matcher = new Matcher();
    private PackageFactory packageFactory;
    private ArrayList<EndpointDescriptor> endpoints = new ArrayList();

    public Configurator(InputStream stream) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        Document document = builder.parse(stream);
        NodeList list = document.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            if (list.item(i).getNodeName() == null || !list.item(i).getNodeName().equalsIgnoreCase("mgcp")) continue;
            this.loadConfig(list.item(i));
        }
    }

    private void loadConfig(Node node) {
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            if (list.item(i).getNodeName() != null && list.item(i).getNodeName().equalsIgnoreCase("packages")) {
                this.packageFactory = new PackageFactory(list.item(i));
            }
            if (list.item(i).getNodeName() == null || !list.item(i).getNodeName().equalsIgnoreCase("endpoints")) continue;
            this.loadEndpoints(list.item(i));
        }
    }

    private void loadEndpoints(Node node) {
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            if (!list.item(i).getNodeName().equalsIgnoreCase("endpoint")) continue;
            NamedNodeMap attributes = list.item(i).getAttributes();
            String pattern = attributes.getNamedItem("local-name").getNodeValue();
            String pkgList = attributes.getNamedItem("packages").getNodeValue();
            EndpointDescriptor descriptor = new EndpointDescriptor(pattern, pkgList.split(","));
            this.endpoints.add(descriptor);
        }
    }

    public MgcpEndpoint activate(Endpoint endpoint, MgcpProvider mgcpProvider, String address, int port) throws Exception {
        EndpointDescriptor descriptor = null;
        for (EndpointDescriptor d : this.endpoints) {
            if (!this.matcher.match(d.namePattern, endpoint.getLocalName())) continue;
            descriptor = d;
            break;
        }
        ArrayList<MgcpPackage> packages = new ArrayList<MgcpPackage>();
        if (descriptor != null) {
            for (int i = 0; i < descriptor.packages.length; ++i) {
                packages.add(this.packageFactory.getPackage(descriptor.packages[i].trim()));
            }
        }
        return new MgcpEndpoint(endpoint, mgcpProvider, address, port, packages);
    }

    private class EndpointDescriptor {
        private String namePattern;
        private String[] packages;

        public EndpointDescriptor(String namePattern, String[] packages) {
            this.namePattern = namePattern;
            this.packages = packages;
        }
    }
}

