/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.control.mgcp.controller;

import java.util.Iterator;
import org.restcomm.media.concurrent.ConcurrentMap;
import org.restcomm.media.control.mgcp.controller.CallManager;
import org.restcomm.media.control.mgcp.controller.MgcpConnection;

public class MgcpCall {
    private CallManager callManager;
    protected int id;
    protected ConcurrentMap<MgcpConnection> connections = new ConcurrentMap();
    private Iterator<Integer> keyIterator;

    protected MgcpCall(CallManager callManager, int id) {
        this.id = id;
        this.callManager = callManager;
    }

    public MgcpConnection getMgcpConnection(Integer id) {
        return (MgcpConnection)this.connections.get((Object)id);
    }

    public int getId() {
        return this.id;
    }

    public void exclude(MgcpConnection activity) {
        this.connections.remove((Object)activity.id);
        if (this.connections.isEmpty()) {
            this.callManager.terminate(this);
        }
    }

    public int size() {
        return this.connections.size();
    }

    public void deleteConnections() {
        this.keyIterator = this.connections.keysIterator();
        while (this.keyIterator.hasNext()) {
            MgcpConnection currConnection = (MgcpConnection)this.connections.remove((Object)this.keyIterator.next());
            currConnection.mgcpEndpoint.deleteConnection(currConnection.getID());
        }
        if (this.connections.isEmpty()) {
            this.callManager.terminate(this);
        }
    }

    public String toString() {
        return "call[" + this.id + "]";
    }
}

