/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.control.mgcp.controller;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Iterator;
import org.restcomm.media.concurrent.ConcurrentCyclicFIFO;
import org.restcomm.media.control.mgcp.MgcpEvent;
import org.restcomm.media.control.mgcp.controller.MgcpConnection;
import org.restcomm.media.control.mgcp.controller.MgcpEndpoint;
import org.restcomm.media.control.mgcp.controller.NotifiedEntity;
import org.restcomm.media.control.mgcp.controller.UnknownActivityException;
import org.restcomm.media.control.mgcp.controller.UnknownEventException;
import org.restcomm.media.control.mgcp.controller.UnknownPackageException;
import org.restcomm.media.control.mgcp.controller.UnknownSignalException;
import org.restcomm.media.control.mgcp.controller.signal.MgcpPackage;
import org.restcomm.media.control.mgcp.controller.signal.Signal;
import org.restcomm.media.control.mgcp.message.MgcpRequest;
import org.restcomm.media.control.mgcp.message.Parameter;
import org.restcomm.media.spi.Connection;
import org.restcomm.media.spi.Endpoint;
import org.restcomm.media.spi.utils.Text;

public class Request {
    private Text ID = new Text(new byte[15], 0, 15);
    private NotifiedEntity callAgent = new NotifiedEntity();
    private Collection<MgcpPackage> packages;
    private Signal currentSignal;
    private MgcpEndpoint endpoint;
    private ConcurrentCyclicFIFO<Signal> executors = new ConcurrentCyclicFIFO();
    private InetSocketAddress address;

    public Request(MgcpEndpoint endpoint, Collection<MgcpPackage> packages) {
        this.endpoint = endpoint;
        this.packages = packages;
        this.setRequest();
    }

    private void setRequest() {
        for (MgcpPackage p : this.packages) {
            p.setRequest(this);
        }
    }

    public void accept(Text ID, Text callAgent, Collection<Text> events, Collection<Text> signals) throws UnknownPackageException, UnknownEventException, UnknownSignalException {
        this.executors.clear();
        for (MgcpPackage p : this.packages) {
            p.reset();
        }
        ID.duplicate(this.ID);
        this.callAgent.setValue(callAgent);
        if (events != null) {
            for (Text evt : events) {
                this.queueEvent(evt);
            }
        }
        if (signals != null) {
            Iterator<Text> it = signals.iterator();
            while (it.hasNext()) {
                this.queueSignal(it.next());
            }
        }
    }

    public void cancel() {
        if (this.currentSignal != null) {
            this.currentSignal.cancel();
        }
    }

    public void execute() {
        this.currentSignal = (Signal)this.executors.poll();
        if (this.currentSignal != null) {
            this.currentSignal.execute();
        }
    }

    public void onEvent(Text event) {
        this.address = new InetSocketAddress(this.callAgent.getHostName().toString(), this.callAgent.getPort());
        MgcpEvent evt = this.endpoint.mgcpProvider.createEvent(1, this.address);
        MgcpRequest msg = (MgcpRequest)evt.getMessage();
        msg.setCommand(new Text("NTFY"));
        msg.setEndpoint(this.endpoint.fullName);
        msg.setParameter(Parameter.OBSERVED_EVENT, event);
        msg.setParameter(Parameter.NOTIFIED_ENTITY, this.callAgent.getValue());
        msg.setParameter(Parameter.REQUEST_ID, this.ID);
        msg.setTxID(MgcpEndpoint.txID.incrementAndGet());
        this.endpoint.send(evt, this.address);
    }

    public void completed() {
        this.execute();
    }

    public Endpoint getEndpoint() {
        return this.endpoint.getEndpoint();
    }

    public NotifiedEntity getCallAgent() {
        return this.callAgent;
    }

    public Connection getConnection(String ID) throws UnknownActivityException {
        MgcpConnection mgcpConnection = this.endpoint.getConnection(Integer.valueOf(ID));
        if (mgcpConnection == null) {
            return null;
        }
        return mgcpConnection.getConnection();
    }

    private void queueEvent(Text event) throws UnknownPackageException, UnknownEventException {
        event.trim();
        Text pkgName = new Text();
        Text eventName = new Text();
        Text[] evt = new Text[]{pkgName, eventName};
        event.divide('/', evt);
        MgcpPackage p = this.getPackage(pkgName);
        if (p == null) {
            throw new UnknownPackageException(eventName.toString());
        }
        p.accept(eventName);
    }

    private void queueSignal(Text event) throws UnknownPackageException, UnknownSignalException {
        Text pkgName = new Text();
        Text eventName = new Text();
        Text[] evt = new Text[]{pkgName, eventName};
        event.divide('/', evt);
        Text signalName = new Text();
        Text options = new Text();
        Text[] signal = new Text[]{signalName, options};
        eventName.divide(new char[]{'(', ')'}, signal);
        MgcpPackage p = this.getPackage(pkgName);
        Signal s = p.getSignal(signalName);
        if (s == null) {
            throw new UnknownSignalException(eventName.toString());
        }
        s.setTrigger(pkgName, eventName, options);
        this.executors.offer((Object)s);
    }

    private MgcpPackage getPackage(Text name) throws UnknownPackageException {
        for (MgcpPackage p : this.packages) {
            if (!p.getName().equals((Object)name)) continue;
            return p;
        }
        throw new UnknownPackageException(name.toString());
    }
}

