/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.control.mgcp.controller.naming;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.restcomm.media.concurrent.ConcurrentCyclicFIFO;
import org.restcomm.media.control.mgcp.controller.MgcpEndpoint;
import org.restcomm.media.control.mgcp.controller.MgcpEndpointStateListener;
import org.restcomm.media.spi.EndpointInstaller;
import org.restcomm.media.spi.utils.Text;

public class EndpointQueue
implements MgcpEndpointStateListener {
    private static final int SIZE = 100;
    private static final Text ANY = new Text("$");
    private static final Text ALL = new Text("*");
    private ArrayList<Holder> completeList = new ArrayList(100);
    private ConcurrentCyclicFIFO<MgcpEndpoint> queue = new ConcurrentCyclicFIFO();
    private int k;
    private EndpointInstaller installer;
    public Logger logger = Logger.getLogger(EndpointQueue.class);

    public void setInstaller(EndpointInstaller installer) {
        this.installer = installer;
    }

    public void add(MgcpEndpoint endpoint) {
        Holder holder = new Holder(endpoint);
        endpoint.setMgcpEndpointStateListener(this);
        this.completeList.add(holder);
        this.queue.offer((Object)endpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int find(Text name, MgcpEndpoint[] endpoints) {
        if (name.equals((Object)ALL)) {
            this.k = 0;
            for (int i = 0; i < this.completeList.size(); ++i) {
                endpoints[this.k++] = this.completeList.get((int)i).endpoint;
            }
            return this.completeList.size();
        }
        if (name.equals((Object)ANY)) {
            MgcpEndpoint endp = (MgcpEndpoint)this.queue.poll();
            while (endp == null && this.installer != null && this.installer.canExpand()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"No free endpoints,expanding");
                }
                EndpointInstaller endpointInstaller = this.installer;
                synchronized (endpointInstaller) {
                    this.installer.newEndpoint();
                }
                endp = (MgcpEndpoint)this.queue.poll();
            }
            if (endp != null) {
                endp.lock();
                endpoints[0] = endp;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Endpoint " + endp.getName() + " taken (free=" + this.queue.size() + ")"));
                }
                return 1;
            }
            return 0;
        }
        int value = name.toInteger();
        if (value > 0 && value <= this.completeList.size()) {
            endpoints[0] = this.completeList.get((int)(value - 1)).endpoint;
            return 1;
        }
        return 0;
    }

    @Override
    public void onFreed(MgcpEndpoint endpoint) {
        this.queue.offer((Object)endpoint);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Endpoint " + endpoint.getName() + " released (free=" + this.queue.size() + ")"));
        }
    }

    private class Holder {
        protected MgcpEndpoint endpoint;
        protected Text name;

        protected Holder(MgcpEndpoint endpoint) {
            this.endpoint = endpoint;
            String[] tokens = endpoint.getName().split("/");
            this.name = new Text(tokens[tokens.length - 1]);
        }
    }
}

