/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.control.mgcp.pkg.au;

import java.util.Collection;
import org.apache.log4j.Logger;
import org.restcomm.media.concurrent.ConcurrentCyclicFIFO;
import org.restcomm.media.control.mgcp.pkg.au.BufferListener;
import org.restcomm.media.spi.dtmf.DtmfDetectorListener;
import org.restcomm.media.spi.dtmf.DtmfEvent;
import org.restcomm.media.spi.utils.Text;

public class EventBuffer
implements DtmfDetectorListener {
    private String sequence = "";
    private String[] patterns = new String[0];
    private int count;
    private BufferListener listener;
    private volatile boolean isActive = false;
    private ConcurrentCyclicFIFO<DtmfEvent> queue = new ConcurrentCyclicFIFO();
    private Logger logger = Logger.getLogger(EventBuffer.class);

    public void activate() {
        this.isActive = true;
    }

    public void passivate() {
        this.isActive = false;
    }

    public int length() {
        return this.sequence.length();
    }

    public String getSequence() {
        return this.sequence;
    }

    public void flush() {
        if (!this.isActive) {
            return;
        }
        while (this.queue.size() != 0) {
            this.process((DtmfEvent)this.queue.poll());
        }
    }

    public void reset() {
        this.sequence = "";
        this.count = -1;
        this.queue.clear();
    }

    public void clear() {
        this.sequence = "";
        this.queue.clear();
    }

    public void setPatterns(Collection<Text> patterns) {
        if (patterns == null) {
            this.patterns = new String[0];
            return;
        }
        this.patterns = new String[patterns.size()];
        int i = 0;
        for (Text pattern : patterns) {
            this.patterns[i] = pattern.toString();
            this.patterns[i] = this.patterns[i].replace(".", "+");
            this.patterns[i] = this.patterns[i].replace("x", "\\d");
            this.patterns[i] = this.patterns[i].replace("*", "\\*");
            ++i;
        }
        this.sequence = "";
    }

    public void setCount(int count) {
        this.count = count;
        this.sequence = "";
    }

    public void setListener(BufferListener listener) {
        this.listener = listener;
    }

    public void process(DtmfEvent event) {
        this.logger.info((Object)("Receive " + event.getTone() + " tone"));
        if (!this.listener.tone(event.getTone())) {
            return;
        }
        if (this.isActive) {
            this.process(event.getTone());
        } else {
            this.queue.offer((Object)event);
        }
    }

    private void process(String tone) {
        this.sequence = this.sequence + tone;
        boolean sequenceFound = false;
        for (int i = 0; i < this.patterns.length; ++i) {
            if (!this.sequence.matches(this.patterns[i]) && !tone.matches(this.patterns[i])) continue;
            this.listener.patternMatches(i, this.sequence);
            this.sequence = "";
            sequenceFound = true;
            break;
        }
        if (!sequenceFound && this.count > 0 && this.sequence.length() == this.count) {
            this.listener.countMatches(this.sequence);
            this.sequence = "";
        }
    }
}

