/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.control.mgcp.pkg.au;

import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.restcomm.media.ComponentType;
import org.restcomm.media.control.mgcp.controller.signal.Event;
import org.restcomm.media.control.mgcp.controller.signal.NotifyImmediately;
import org.restcomm.media.control.mgcp.controller.signal.Signal;
import org.restcomm.media.control.mgcp.pkg.au.Options;
import org.restcomm.media.spi.MediaType;
import org.restcomm.media.spi.ResourceUnavailableException;
import org.restcomm.media.spi.listener.TooManyListenersException;
import org.restcomm.media.spi.player.Player;
import org.restcomm.media.spi.player.PlayerEvent;
import org.restcomm.media.spi.player.PlayerListener;
import org.restcomm.media.spi.utils.Text;

public class Play
extends Signal
implements PlayerListener {
    private static final Logger log = Logger.getLogger(Play.class);
    private static final Text MSG_NO_PLAYER = new Text("Endpoint has no player");
    private static final Text MSG_RC_301 = new Text("rc=301");
    private static final Text MSG_RC_312 = new Text("rc=312");
    private static final Text MSG_RC_100 = new Text("rc=100");
    private Player player;
    private volatile Options options;
    private Iterator<Text> segments;
    private int repeatCount;
    private int segCount;
    private long delay;
    private String uri;
    private final AtomicBoolean terminated = new AtomicBoolean(false);
    private final Event oc = new Event(new Text("oc"));
    private final Event of;
    private final Object lock;

    public Play(String name) {
        super(name);
        this.oc.add(new NotifyImmediately("N"));
        this.of = new Event(new Text("of"));
        this.of.add(new NotifyImmediately("N"));
        this.lock = new ReentrantLock();
    }

    @Override
    public void execute() {
        this.player = (Player)this.getEndpoint().getResource(MediaType.AUDIO, ComponentType.PLAYER);
        if (this.player == null) {
            this.of.fire(this, MSG_NO_PLAYER);
            this.complete();
            return;
        }
        try {
            this.player.addListener((PlayerListener)this);
        }
        catch (TooManyListenersException e) {
            log.error((Object)"OPERATION FAILURE", (Throwable)e);
        }
        this.options = Options.allocate(this.getTrigger().getParams());
        this.delay = 0L;
        this.segments = this.options.getSegments().iterator();
        this.repeatCount = this.options.getRepeatCount();
        this.segCount = 0;
        this.uri = this.segments.next().toString();
        this.terminated.set(false);
        this.startAnnouncementPhase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAnnouncementPhase() {
        Object object = this.lock;
        synchronized (object) {
            if (this.terminated.get()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Skipping announcement phase because play has been terminated.");
                }
                return;
            }
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("(%s) Start announcement (segment=%d)", this.getEndpoint().getLocalName(), this.segCount));
            }
            try {
                this.player.setURL(this.uri);
            }
            catch (MalformedURLException e) {
                if (log.isInfoEnabled()) {
                    log.warn((Object)("Invalid URL format: " + this.uri));
                }
                this.of.fire(this, MSG_RC_301);
                this.complete();
                return;
            }
            catch (ResourceUnavailableException e) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("URL cannot be found: " + this.uri));
                }
                this.of.fire(this, MSG_RC_312);
                this.complete();
                return;
            }
            if (this.options.getDuration() != -1L) {
                this.player.setDuration(this.options.getDuration());
            }
            if (this.options.getOffset() > 0L) {
                this.player.setMediaTime(this.options.getOffset());
            }
            this.player.setInitialDelay(this.delay);
            this.player.activate();
        }
    }

    @Override
    public boolean doAccept(Text event) {
        if (!this.oc.isActive() && this.oc.matches(event)) {
            return true;
        }
        return !this.of.isActive() && this.of.matches(event);
    }

    @Override
    public void cancel() {
        this.terminate();
    }

    @Override
    public void reset() {
        super.reset();
        this.terminate();
        this.oc.reset();
        this.of.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminate() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.terminated.get()) {
                this.terminated.set(true);
                this.cleanup();
            }
        }
    }

    private void cleanup() {
        if (this.player != null) {
            this.player.removeListener((PlayerListener)this);
            this.player.deactivate();
            this.player = null;
        }
        if (this.options != null) {
            Options.recycle(this.options);
            this.options = null;
        }
    }

    private void repeat(long delay) {
        this.delay = delay;
        this.startAnnouncementPhase();
    }

    private void next(long delay) {
        this.uri = this.segments.next().toString();
        ++this.segCount;
        this.delay = delay;
        this.startAnnouncementPhase();
    }

    public void process(PlayerEvent event) {
        switch (event.getID()) {
            case 2: {
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("(%s) Announcement (segment=%d) has completed", this.getEndpoint().getLocalName(), this.segCount));
                }
                if (this.repeatCount == -1) {
                    this.repeat(this.options.getInterval());
                    return;
                }
                --this.repeatCount;
                if (this.repeatCount > 0) {
                    this.repeat(this.options.getInterval());
                    return;
                }
                if (this.segments.hasNext()) {
                    this.repeatCount = this.options.getRepeatCount();
                    this.next(this.options.getInterval());
                    return;
                }
                this.terminate();
                this.oc.fire(this, MSG_RC_100);
                this.complete();
                break;
            }
            case 3: {
                this.terminate();
                this.oc.fire(this, null);
                this.complete();
            }
        }
    }
}

