/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.control.mgcp.pkg.dtmf;

import org.restcomm.media.ComponentType;
import org.restcomm.media.control.mgcp.controller.signal.Event;
import org.restcomm.media.control.mgcp.controller.signal.NotifyImmediately;
import org.restcomm.media.control.mgcp.controller.signal.Signal;
import org.restcomm.media.spi.MediaType;
import org.restcomm.media.spi.dtmf.DtmfDetector;
import org.restcomm.media.spi.dtmf.DtmfDetectorListener;
import org.restcomm.media.spi.dtmf.DtmfEvent;
import org.restcomm.media.spi.listener.TooManyListenersException;
import org.restcomm.media.spi.utils.Text;

public abstract class AbstractDtmfEvent
extends Signal
implements DtmfDetectorListener {
    private DtmfDetector dtmfDetector;
    protected Event tone = this.getTone();

    public AbstractDtmfEvent(String name) {
        super(name);
        this.tone.add(new NotifyImmediately("N"));
    }

    @Override
    public void execute() {
        this.dtmfDetector = this.getDetector();
        if (this.dtmfDetector == null) {
            return;
        }
        try {
            this.dtmfDetector.addListener((DtmfDetectorListener)this);
            this.dtmfDetector.activate();
        }
        catch (TooManyListenersException tooManyListenersException) {
            // empty catch block
        }
    }

    @Override
    public boolean doAccept(Text event) {
        boolean b;
        boolean bl = b = !this.tone.isActive() && this.tone.matches(event);
        if (b) {
            this.execute();
        }
        return b;
    }

    @Override
    public void cancel() {
        if (this.dtmfDetector != null) {
            this.dtmfDetector.removeListener((DtmfDetectorListener)this);
            this.dtmfDetector.deactivate();
            this.dtmfDetector = null;
        }
    }

    public void process(DtmfEvent event) {
        this.onEvent(event.getTone());
    }

    @Override
    public void reset() {
        this.tone.reset();
    }

    public abstract void onEvent(String var1);

    protected abstract Event getTone();

    private DtmfDetector getDetector() {
        return (DtmfDetector)this.getEndpoint().getResource(MediaType.AUDIO, ComponentType.DTMF_DETECTOR);
    }
}

