/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.control.mgcp.pkg.sl;

import java.util.concurrent.ArrayBlockingQueue;
import org.restcomm.media.concurrent.ConcurrentCyclicFIFO;
import org.restcomm.media.control.mgcp.pkg.sl.DtmfSignal;
import org.restcomm.media.spi.utils.Text;

public final class Options {
    private static final ConcurrentCyclicFIFO<ArrayBlockingQueue<DtmfSignal>> cache = new ConcurrentCyclicFIFO();

    public static void recycle(ArrayBlockingQueue<DtmfSignal> queue) {
        queue.clear();
        cache.offer(queue);
    }

    public static ArrayBlockingQueue<DtmfSignal> parse(Text data) {
        ArrayBlockingQueue<DtmfSignal> result = (ArrayBlockingQueue<DtmfSignal>)cache.poll();
        if (result == null) {
            result = new ArrayBlockingQueue<DtmfSignal>(100);
        }
        int index = 0;
        int length = data.length();
        boolean subToneEnded = false;
        boolean numberEnded = false;
        int subElements = 0;
        int defaultDuration = 0;
        while (index < length - 2) {
            char currChar;
            String currentTone = null;
            defaultDuration = 200;
            if ((currChar = data.charAt(index++)) != 'd' && currChar != 'D') {
                Options.recycle(result);
                throw new IllegalArgumentException();
            }
            if ((currChar = data.charAt(index++)) != '/') {
                Options.recycle(result);
                throw new IllegalArgumentException();
            }
            if ((currChar = data.charAt(index++)) >= '0' && currChar <= '9') {
                currentTone = DtmfSignal.ALL_TONES[currChar - 48];
            } else {
                switch (currChar) {
                    case 'A': 
                    case 'a': {
                        currentTone = "A";
                        break;
                    }
                    case 'B': 
                    case 'b': {
                        currentTone = "B";
                        break;
                    }
                    case 'C': 
                    case 'c': {
                        currentTone = "C";
                        break;
                    }
                    case '#': {
                        currentTone = "#";
                        break;
                    }
                    case '*': {
                        currentTone = "*";
                        break;
                    }
                    case 'D': 
                    case 'd': {
                        if (index == length) {
                            currentTone = "D";
                            break;
                        }
                        if (index < length - 4) {
                            currChar = data.charAt(index);
                            if (currChar == ',') {
                                currentTone = "D";
                                break;
                            }
                            if (currChar != 'd' && currChar != 'D') break;
                            if (data.charAt(++index) != '(') {
                                Options.recycle(result);
                                throw new IllegalArgumentException();
                            }
                            subToneEnded = false;
                            subElements = 0;
                            ++index;
                            while (index < length - 4 && !subToneEnded && subElements < 2) {
                                ++subElements;
                                currChar = data.charAt(index++);
                                switch (currChar) {
                                    case 'D': 
                                    case 'd': {
                                        currChar = data.charAt(index++);
                                        if (currChar != 'g' && currChar != 'G') {
                                            Options.recycle(result);
                                            throw new IllegalArgumentException();
                                        }
                                        if ((currChar = data.charAt(index++)) != '=') {
                                            Options.recycle(result);
                                            throw new IllegalArgumentException();
                                        }
                                        if ((currChar = data.charAt(index++)) >= '0' && currChar <= '9') {
                                            currentTone = DtmfSignal.ALL_TONES[currChar - 48];
                                        } else {
                                            switch (currChar) {
                                                case 'A': 
                                                case 'a': {
                                                    currentTone = "A";
                                                    break;
                                                }
                                                case 'B': 
                                                case 'b': {
                                                    currentTone = "B";
                                                    break;
                                                }
                                                case 'C': 
                                                case 'c': {
                                                    currentTone = "C";
                                                    break;
                                                }
                                                case 'D': 
                                                case 'd': {
                                                    currentTone = "D";
                                                    break;
                                                }
                                                case '#': {
                                                    currentTone = "#";
                                                    break;
                                                }
                                                case '*': {
                                                    currentTone = "*";
                                                }
                                            }
                                        }
                                        currChar = data.charAt(index++);
                                        if (currChar == ')') {
                                            subToneEnded = true;
                                            break;
                                        }
                                        if (currChar == ',') break;
                                        Options.recycle(result);
                                        throw new IllegalArgumentException();
                                    }
                                    case 'T': 
                                    case 't': {
                                        currChar = data.charAt(index++);
                                        if (currChar != 'o' && currChar != 'O') {
                                            Options.recycle(result);
                                            throw new IllegalArgumentException();
                                        }
                                        if ((currChar = data.charAt(index++)) != '=') {
                                            Options.recycle(result);
                                            throw new IllegalArgumentException();
                                        }
                                        numberEnded = false;
                                        defaultDuration = 0;
                                        while (!numberEnded && index < length) {
                                            if ((currChar = data.charAt(index++)) >= '0' && currChar <= '9') {
                                                defaultDuration *= 10;
                                                defaultDuration += currChar - 48;
                                                continue;
                                            }
                                            if (currChar == ')') {
                                                numberEnded = true;
                                                subToneEnded = true;
                                                continue;
                                            }
                                            if (currChar == ',') {
                                                numberEnded = true;
                                                continue;
                                            }
                                            Options.recycle(result);
                                            throw new IllegalArgumentException();
                                        }
                                        if (numberEnded) break;
                                        Options.recycle(result);
                                        throw new IllegalArgumentException();
                                    }
                                }
                            }
                            if (subToneEnded) break;
                            Options.recycle(result);
                            throw new IllegalArgumentException();
                        }
                        Options.recycle(result);
                        throw new IllegalArgumentException();
                    }
                }
            }
            if (index < length && (currChar = data.charAt(index++)) != ',') {
                Options.recycle(result);
                throw new IllegalArgumentException();
            }
            result.offer(new DtmfSignal(currentTone, defaultDuration));
        }
        if (index != length) {
            Options.recycle(result);
            throw new IllegalArgumentException();
        }
        return result;
    }
}

