/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.control.mgcp.pkg.sl;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.restcomm.media.ComponentType;
import org.restcomm.media.control.mgcp.controller.signal.Event;
import org.restcomm.media.control.mgcp.controller.signal.NotifyImmediately;
import org.restcomm.media.control.mgcp.controller.signal.Signal;
import org.restcomm.media.control.mgcp.pkg.sl.DtmfSignal;
import org.restcomm.media.control.mgcp.pkg.sl.Options;
import org.restcomm.media.scheduler.PriorityQueueScheduler;
import org.restcomm.media.scheduler.Task;
import org.restcomm.media.spi.MediaType;
import org.restcomm.media.spi.dtmf.DtmfGenerator;
import org.restcomm.media.spi.dtmf.DtmfGeneratorEvent;
import org.restcomm.media.spi.dtmf.DtmfGeneratorListener;
import org.restcomm.media.spi.utils.Text;

public class SignalRequest
extends Signal
implements DtmfGeneratorListener {
    private static final Logger logger = Logger.getLogger(SignalRequest.class);
    private DtmfGenerator generator;
    private Event oc;
    private Event of;
    private ArrayBlockingQueue<DtmfSignal> signals;
    DtmfSignal currentSignal;
    private Semaphore terminateSemaphore = new Semaphore(1);
    private Heartbeat heartbeat;
    private PriorityQueueScheduler scheduler;

    public SignalRequest(String name) {
        super(name);
        this.oc = new Event(new Text("oc"));
        this.oc.add(new NotifyImmediately("N"));
        this.of = new Event(new Text("of"));
        this.of.add(new NotifyImmediately("N"));
        this.signals = null;
    }

    @Override
    public void execute() {
        try {
            Text parameters = this.getTrigger().getParams();
            this.signals = Options.parse(parameters);
        }
        catch (IllegalArgumentException exception) {
            logger.error((Object)"There was an error parsing the signal list.", (Throwable)exception);
            this.of.fire(this, new Text("rc=538"));
            return;
        }
        if (this.signals.size() == 0) {
            this.oc.fire(this, new Text("rc=100"));
            return;
        }
        this.scheduler = this.getEndpoint().getScheduler();
        this.heartbeat = new Heartbeat(this);
        this.generator = this.getDtmfGenerator();
        this.generator.addListener((DtmfGeneratorListener)this);
        this.currentSignal = this.signals.poll();
        this.generator.setOOBDigit(this.currentSignal.getDigit());
        this.generator.setToneDuration(this.currentSignal.getDuration());
        this.generator.activate();
    }

    @Override
    public boolean doAccept(Text event) {
        if (!this.oc.isActive() && this.oc.matches(event)) {
            return true;
        }
        return !this.of.isActive() && this.of.matches(event);
    }

    @Override
    public void cancel() {
        this.terminate();
    }

    private void terminate() {
        try {
            this.terminateSemaphore.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.generator != null) {
            this.generator.removeListener((DtmfGeneratorListener)this);
            this.generator.deactivate();
            this.generator = null;
        }
        if (this.signals != null) {
            Options.recycle(this.signals);
            this.signals = null;
        }
        if (this.heartbeat != null) {
            this.heartbeat.disable();
            this.heartbeat = null;
        }
        this.terminateSemaphore.release();
    }

    private DtmfGenerator getDtmfGenerator() {
        return (DtmfGenerator)this.getEndpoint().getResource(MediaType.AUDIO, ComponentType.DTMF_GENERATOR);
    }

    public void process(DtmfGeneratorEvent event) {
        this.generator.deactivate();
        this.heartbeat.activate();
        this.getEndpoint().getScheduler().submitHeatbeat((Task)this.heartbeat);
    }

    private class Heartbeat
    extends Task {
        private AtomicBoolean active = new AtomicBoolean(false);
        private Signal signal;

        public Heartbeat(Signal signal) {
            this.signal = signal;
        }

        public int getQueueNumber() {
            return PriorityQueueScheduler.HEARTBEAT_QUEUE;
        }

        public void disable() {
            this.active.set(false);
        }

        public void activate() {
            this.active.set(true);
        }

        public long perform() {
            SignalRequest.this.generator.deactivate();
            SignalRequest.this.currentSignal = (DtmfSignal)SignalRequest.this.signals.poll();
            if (SignalRequest.this.currentSignal != null) {
                SignalRequest.this.generator.setOOBDigit(SignalRequest.this.currentSignal.getDigit());
                SignalRequest.this.generator.setToneDuration(SignalRequest.this.currentSignal.getDuration());
                SignalRequest.this.generator.activate();
            } else {
                SignalRequest.this.terminate();
                SignalRequest.this.oc.fire(this.signal, new Text("rc=100"));
            }
            return 0L;
        }
    }
}

