/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.control.mgcp.tx;

import org.restcomm.media.control.mgcp.MgcpEvent;
import org.restcomm.media.control.mgcp.tx.ActionListener;
import org.restcomm.media.control.mgcp.tx.Transaction;
import org.restcomm.media.scheduler.Task;
import org.restcomm.media.scheduler.TaskChain;
import org.restcomm.media.scheduler.TaskChainListener;
import org.restcomm.media.scheduler.TaskListener;

public class Action
implements TaskChainListener {
    protected ActionListener listener;
    private TaskChain actionHandler;
    private Task rollbackHandler;
    private Transaction tx;
    private MgcpEvent event;
    private RollbackListener rollbackListener = new RollbackListener();

    protected Action() {
    }

    protected void setEvent(MgcpEvent event) {
        this.event = event;
    }

    public MgcpEvent getEvent() {
        return this.event;
    }

    public void setActionHandler(TaskChain handler) {
        this.actionHandler = handler;
        this.actionHandler.setListener((TaskChainListener)this);
    }

    public void setRollbackHandler(Task handler) {
        this.rollbackHandler = handler;
        this.rollbackHandler.setListener((TaskListener)this.rollbackListener);
    }

    public void start(Transaction tx) {
        this.tx = tx;
        this.actionHandler.setListener((TaskChainListener)this);
        this.actionHandler.start();
    }

    public void rollback() {
        if (this.rollbackHandler != null) {
            this.tx.scheduler().submit((Runnable)this.rollbackHandler);
        } else {
            this.tx.onRollback();
        }
    }

    public void onTermination() {
        if (this.listener != null) {
            this.listener.onComplete();
        }
    }

    public void onException(Exception e) {
        if (this.listener != null) {
            this.listener.onFailure(e);
        }
    }

    protected Transaction transaction() {
        return this.tx;
    }

    private class RollbackListener
    implements TaskListener {
        private RollbackListener() {
        }

        public void onTerminate() {
            Action.this.tx.onRollback();
        }

        public void handlerError(Exception e) {
        }
    }
}

