/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.control.mgcp.tx.cmd;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.restcomm.media.control.mgcp.MgcpEvent;
import org.restcomm.media.control.mgcp.controller.MgcpCall;
import org.restcomm.media.control.mgcp.controller.MgcpConnection;
import org.restcomm.media.control.mgcp.controller.MgcpEndpoint;
import org.restcomm.media.control.mgcp.message.MgcpRequest;
import org.restcomm.media.control.mgcp.message.MgcpResponse;
import org.restcomm.media.control.mgcp.message.Parameter;
import org.restcomm.media.control.mgcp.params.LocalConnectionOptions;
import org.restcomm.media.control.mgcp.tx.Action;
import org.restcomm.media.control.mgcp.tx.Transaction;
import org.restcomm.media.control.mgcp.tx.cmd.MgcpCommandException;
import org.restcomm.media.scheduler.PriorityQueueScheduler;
import org.restcomm.media.scheduler.Scheduler;
import org.restcomm.media.scheduler.Task;
import org.restcomm.media.scheduler.TaskChain;
import org.restcomm.media.spi.ConnectionMode;
import org.restcomm.media.spi.ConnectionType;
import org.restcomm.media.spi.ModeNotSupportedException;
import org.restcomm.media.spi.utils.Text;

public class CreateConnectionCmd
extends Action {
    private static final Text CALLID_MISSING = new Text("Missing call identifier");
    private static final Text MODE_MISSING = new Text("Missing mode value");
    private static final Text WILDCARD_ALL_NOT_ALLOWED = new Text("Wildcard <all> not allowed here");
    private static final Text SDP_NEGOTIATION_FAILED = new Text("SDP_NEGOTIATION_FAILED");
    private static final Text ERROR_ENDPOINT_UNAVAILAVALE = new Text("Endpoint not available");
    private static final Text SUCCESS = new Text("Success");
    private MgcpEndpoint[] endpoints = new MgcpEndpoint[2];
    private MgcpEndpoint endpoint;
    private MgcpEndpoint endpoint2;
    private MgcpConnection[] connections = new MgcpConnection[2];
    private Parameter callID;
    private Text localName = new Text();
    private Text domainName = new Text();
    private Text[] endpointName = new Text[]{this.localName, this.domainName};
    private Text localName2 = new Text();
    private Text domainName2 = new Text();
    private Text[] endpointName2 = new Text[]{this.localName2, this.domainName2};
    private Parameter mode;
    private Parameter sdp;
    private TaskChain handler;
    private Preprocessor preprocessor;
    private MgcpRequest request;
    private Responder responder;
    private ErrorHandle errorHandle;
    private MgcpCall call;
    private int code;
    private Text message;
    private LocalConnectionOptions lcOptions = new LocalConnectionOptions();
    private static final Logger logger = Logger.getLogger(CreateConnectionCmd.class);

    public CreateConnectionCmd(Scheduler scheduler) {
        this.handler = new TaskChain(2, scheduler);
        this.responder = new Responder();
        this.preprocessor = new Preprocessor();
        this.errorHandle = new ErrorHandle();
        this.handler.add((Task)this.preprocessor);
        this.handler.add((Task)this.responder);
        this.setActionHandler(this.handler);
        this.setRollbackHandler(this.errorHandle);
    }

    @Override
    public void start(Transaction tx) {
        this.handler.clean();
        this.handler.add((Task)this.preprocessor);
        this.handler.add((Task)this.responder);
        super.start(tx);
    }

    private class ErrorHandle
    extends Task {
        public int getQueueNumber() {
            return PriorityQueueScheduler.MANAGEMENT_QUEUE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long perform() {
            if (CreateConnectionCmd.this.endpoint != null) {
                CreateConnectionCmd.this.endpoint.share();
                if (CreateConnectionCmd.this.connections[0] != null) {
                    CreateConnectionCmd.this.endpoint.deleteConnection(CreateConnectionCmd.this.connections[0].getID());
                }
            }
            if (CreateConnectionCmd.this.endpoint2 != null) {
                CreateConnectionCmd.this.endpoint2.share();
                if (CreateConnectionCmd.this.connections[1] != null) {
                    CreateConnectionCmd.this.endpoint2.deleteConnection(CreateConnectionCmd.this.connections[1].getID());
                }
            }
            CreateConnectionCmd.this.code = ((MgcpCommandException)CreateConnectionCmd.this.transaction().getLastError()).getCode();
            CreateConnectionCmd.this.message = ((MgcpCommandException)CreateConnectionCmd.this.transaction().getLastError()).getErrorMessage();
            MgcpEvent evt = CreateConnectionCmd.this.transaction().getProvider().createEvent(2, CreateConnectionCmd.this.getEvent().getAddress());
            try {
                MgcpResponse response = (MgcpResponse)evt.getMessage();
                response.setResponseCode(CreateConnectionCmd.this.code);
                response.setResponseString(CreateConnectionCmd.this.message);
                response.setTxID(CreateConnectionCmd.this.transaction().getId());
                CreateConnectionCmd.this.transaction().getProvider().send(evt);
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
            finally {
                evt.recycle();
            }
            return 0L;
        }
    }

    private class Responder
    extends Task {
        public int getQueueNumber() {
            return PriorityQueueScheduler.MANAGEMENT_QUEUE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long perform() {
            MgcpEvent evt = CreateConnectionCmd.this.transaction().getProvider().createEvent(2, CreateConnectionCmd.this.getEvent().getAddress());
            try {
                MgcpResponse response = (MgcpResponse)evt.getMessage();
                response.setResponseCode(200);
                response.setResponseString(SUCCESS);
                response.setParameter(Parameter.CONNECTION_ID, CreateConnectionCmd.this.connections[0].getTextualID());
                response.setParameter(Parameter.ENDPOINT_ID, CreateConnectionCmd.this.endpoint.getFullName());
                if (CreateConnectionCmd.this.endpoint2 == null) {
                    response.setParameter(Parameter.SDP, CreateConnectionCmd.this.connections[0].getDescriptor());
                }
                response.setTxID(CreateConnectionCmd.this.transaction().getId());
                if (CreateConnectionCmd.this.endpoint2 != null) {
                    response.setParameter(Parameter.SECOND_ENDPOINT, CreateConnectionCmd.this.endpoint2.getFullName());
                }
                if (CreateConnectionCmd.this.connections[1] != null) {
                    response.setParameter(Parameter.CONNECTION_ID2, CreateConnectionCmd.this.connections[1].getTextualID());
                }
                CreateConnectionCmd.this.transaction().getProvider().send(evt);
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
            finally {
                evt.recycle();
            }
            return 0L;
        }
    }

    private class Preprocessor
    extends Task {
        public int getQueueNumber() {
            return PriorityQueueScheduler.MANAGEMENT_QUEUE;
        }

        public long perform() {
            int n;
            Parameter l;
            CreateConnectionCmd.this.endpoint = null;
            CreateConnectionCmd.this.endpoint2 = null;
            CreateConnectionCmd.this.request = (MgcpRequest)CreateConnectionCmd.this.getEvent().getMessage();
            Parameter z2 = CreateConnectionCmd.this.request.getParameter(Parameter.SECOND_ENDPOINT);
            CreateConnectionCmd.this.sdp = CreateConnectionCmd.this.request.getParameter(Parameter.SDP);
            if (z2 != null && CreateConnectionCmd.this.sdp != null) {
                throw new MgcpCommandException(510, new Text("Second endpoint and remote SDP present in message"));
            }
            CreateConnectionCmd.this.callID = CreateConnectionCmd.this.request.getParameter(Parameter.CALL_ID);
            if (CreateConnectionCmd.this.callID == null) {
                throw new MgcpCommandException(510, CALLID_MISSING);
            }
            CreateConnectionCmd.this.mode = CreateConnectionCmd.this.request.getParameter(Parameter.MODE);
            if (CreateConnectionCmd.this.mode == null) {
                throw new MgcpCommandException(510, MODE_MISSING);
            }
            CreateConnectionCmd.this.request.getEndpoint().divide('@', CreateConnectionCmd.this.endpointName);
            if (CreateConnectionCmd.this.localName.contains('*')) {
                throw new MgcpCommandException(503, WILDCARD_ALL_NOT_ALLOWED);
            }
            if (z2 != null) {
                z2.getValue().divide('@', CreateConnectionCmd.this.endpointName2);
                if (CreateConnectionCmd.this.localName2.contains('*')) {
                    throw new MgcpCommandException(503, new Text("Wildcard all is not allowed here"));
                }
            }
            if ((l = CreateConnectionCmd.this.request.getParameter(Parameter.LOCAL_CONNECTION_OPTIONS)) != null) {
                CreateConnectionCmd.this.lcOptions.setValue(l.getValue());
            } else {
                CreateConnectionCmd.this.lcOptions.setValue(null);
            }
            ((CreateConnectionCmd)CreateConnectionCmd.this).connections[0] = null;
            ((CreateConnectionCmd)CreateConnectionCmd.this).connections[1] = null;
            CreateConnectionCmd.this.call = CreateConnectionCmd.this.transaction().getCall(CreateConnectionCmd.this.callID.getValue().hexToInteger(), true);
            try {
                n = CreateConnectionCmd.this.transaction().find(CreateConnectionCmd.this.localName, CreateConnectionCmd.this.endpoints);
                if (n == 0) {
                    throw new MgcpCommandException(410, ERROR_ENDPOINT_UNAVAILAVALE);
                }
                CreateConnectionCmd.this.endpoint = CreateConnectionCmd.this.endpoints[0];
            }
            catch (Exception e) {
                throw new MgcpCommandException(410, ERROR_ENDPOINT_UNAVAILAVALE);
            }
            if (z2 != null) {
                try {
                    n = CreateConnectionCmd.this.transaction().find(CreateConnectionCmd.this.localName2, CreateConnectionCmd.this.endpoints);
                    if (n == 0) {
                        throw new MgcpCommandException(410, ERROR_ENDPOINT_UNAVAILAVALE);
                    }
                    CreateConnectionCmd.this.endpoint2 = CreateConnectionCmd.this.endpoints[0];
                }
                catch (Exception e) {
                    throw new MgcpCommandException(410, ERROR_ENDPOINT_UNAVAILAVALE);
                }
                try {
                    ((CreateConnectionCmd)CreateConnectionCmd.this).connections[0] = CreateConnectionCmd.this.endpoint.createConnection(CreateConnectionCmd.this.call, ConnectionType.LOCAL, false);
                }
                catch (Exception e) {
                    throw new MgcpCommandException(410, new Text("Problem with connection"));
                }
                try {
                    ((CreateConnectionCmd)CreateConnectionCmd.this).connections[1] = CreateConnectionCmd.this.endpoint2.createConnection(CreateConnectionCmd.this.call, ConnectionType.LOCAL, false);
                }
                catch (Exception e) {
                    throw new MgcpCommandException(410, new Text("Problem with connection"));
                }
                try {
                    CreateConnectionCmd.this.connections[0].setOtherParty(CreateConnectionCmd.this.connections[1]);
                }
                catch (Exception e) {
                    logger.error((Object)"Could not set remote peer", (Throwable)e);
                    throw new MgcpCommandException(410, new Text("Problem with joining"));
                }
                if (CreateConnectionCmd.this.mode == null) {
                    throw new MgcpCommandException(510, new Text("Mode was not specified"));
                }
                ConnectionMode m = ConnectionMode.fromDescription((String)CreateConnectionCmd.this.mode.getValue().toString());
                try {
                    CreateConnectionCmd.this.connections[0].setMode(m);
                    CreateConnectionCmd.this.connections[1].setMode(ConnectionMode.SEND_RECV);
                }
                catch (Exception e) {
                    throw new MgcpCommandException(517, new Text("Unsupported mode"));
                }
                CreateConnectionCmd.this.connections[0].setDtmfClamp(CreateConnectionCmd.this.lcOptions.getDtmfClamp());
            } else {
                try {
                    ((CreateConnectionCmd)CreateConnectionCmd.this).connections[0] = CreateConnectionCmd.this.endpoint.createConnection(CreateConnectionCmd.this.call, ConnectionType.RTP, CreateConnectionCmd.this.lcOptions.getIsLocal());
                    CreateConnectionCmd.this.connections[0].setCallAgent(CreateConnectionCmd.this.getEvent().getAddress());
                }
                catch (Exception e) {
                    throw new MgcpCommandException(410, new Text("Problem with connection" + e.getMessage()));
                }
                if (CreateConnectionCmd.this.sdp != null) {
                    try {
                        CreateConnectionCmd.this.connections[0].setOtherParty(CreateConnectionCmd.this.sdp.getValue());
                    }
                    catch (IOException e) {
                        logger.error((Object)"Could not set remote peer", (Throwable)e);
                        throw new MgcpCommandException(527, SDP_NEGOTIATION_FAILED);
                    }
                }
                try {
                    CreateConnectionCmd.this.connections[0].generateLocalDescriptor(CreateConnectionCmd.this.lcOptions.isWebRTC());
                }
                catch (IOException e) {
                    throw new MgcpCommandException(524, new Text("Could not generate local connection descriptor."));
                }
                try {
                    CreateConnectionCmd.this.connections[0].setMode(CreateConnectionCmd.this.mode.getValue());
                }
                catch (ModeNotSupportedException e) {
                    throw new MgcpCommandException(517, new Text("Not supported mode"));
                }
                CreateConnectionCmd.this.connections[0].setDtmfClamp(CreateConnectionCmd.this.lcOptions.getDtmfClamp());
            }
            return 0L;
        }
    }
}

