/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.control.mgcp.tx.cmd;

import java.io.IOException;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.restcomm.media.control.mgcp.MgcpEvent;
import org.restcomm.media.control.mgcp.controller.MgcpEndpoint;
import org.restcomm.media.control.mgcp.controller.UnknownEventException;
import org.restcomm.media.control.mgcp.controller.UnknownPackageException;
import org.restcomm.media.control.mgcp.controller.UnknownSignalException;
import org.restcomm.media.control.mgcp.controller.naming.UnknownEndpointException;
import org.restcomm.media.control.mgcp.message.MgcpRequest;
import org.restcomm.media.control.mgcp.message.MgcpResponse;
import org.restcomm.media.control.mgcp.message.Parameter;
import org.restcomm.media.control.mgcp.tx.Action;
import org.restcomm.media.control.mgcp.tx.cmd.MgcpCommandException;
import org.restcomm.media.scheduler.PriorityQueueScheduler;
import org.restcomm.media.scheduler.Scheduler;
import org.restcomm.media.scheduler.Task;
import org.restcomm.media.scheduler.TaskChain;
import org.restcomm.media.spi.utils.Text;

public class NotificationRequestCmd
extends Action {
    private static final Text SUCCESS = new Text("Success");
    private static final Text eventsSplit = new Text("),");
    private MgcpRequest request;
    private MgcpEndpoint endpoint;
    private MgcpEndpoint[] endpoints = new MgcpEndpoint[1];
    private TaskChain handler;
    private ErrorHandler errorHandler;
    private int code;
    private Text message;
    private static final Logger logger = Logger.getLogger(NotificationRequestCmd.class);

    public NotificationRequestCmd(Scheduler scheduler) {
        this.handler = new TaskChain(3, scheduler);
        Request req = new Request();
        Responder responder = new Responder();
        Executor executor = new Executor();
        this.errorHandler = new ErrorHandler();
        this.handler.add((Task)req);
        this.handler.add((Task)responder);
        this.handler.add((Task)executor);
        this.setActionHandler(this.handler);
        this.setRollbackHandler(this.errorHandler);
    }

    private class ErrorHandler
    extends Task {
        public int getQueueNumber() {
            return PriorityQueueScheduler.MANAGEMENT_QUEUE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long perform() {
            MgcpEvent evt = null;
            try {
                NotificationRequestCmd.this.code = ((MgcpCommandException)NotificationRequestCmd.this.transaction().getLastError()).getCode();
                NotificationRequestCmd.this.message = ((MgcpCommandException)NotificationRequestCmd.this.transaction().getLastError()).getErrorMessage();
                evt = NotificationRequestCmd.this.transaction().getProvider().createEvent(2, NotificationRequestCmd.this.getEvent().getAddress());
                MgcpResponse response = (MgcpResponse)evt.getMessage();
                response.setResponseCode(NotificationRequestCmd.this.code);
                response.setResponseString(NotificationRequestCmd.this.message);
                response.setTxID(NotificationRequestCmd.this.transaction().getId());
                NotificationRequestCmd.this.transaction().getProvider().send(evt);
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
            finally {
                evt.recycle();
            }
            return 0L;
        }
    }

    private class Executor
    extends Task {
        public int getQueueNumber() {
            return PriorityQueueScheduler.MANAGEMENT_QUEUE;
        }

        public long perform() {
            NotificationRequestCmd.this.endpoint.getRequest().execute();
            return 0L;
        }
    }

    private class Responder
    extends Task {
        public int getQueueNumber() {
            return PriorityQueueScheduler.MANAGEMENT_QUEUE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long perform() {
            MgcpEvent evt = NotificationRequestCmd.this.transaction().getProvider().createEvent(2, NotificationRequestCmd.this.getEvent().getAddress());
            MgcpResponse response = (MgcpResponse)evt.getMessage();
            response.setResponseCode(200);
            response.setResponseString(SUCCESS);
            response.setTxID(NotificationRequestCmd.this.transaction().getId());
            try {
                NotificationRequestCmd.this.transaction().getProvider().send(evt);
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
            finally {
                evt.recycle();
            }
            return 0L;
        }
    }

    private class Request
    extends Task {
        public int getQueueNumber() {
            return PriorityQueueScheduler.MANAGEMENT_QUEUE;
        }

        public long perform() {
            NotificationRequestCmd.this.request = (MgcpRequest)NotificationRequestCmd.this.getEvent().getMessage();
            Text localName = new Text();
            Text domainName = new Text();
            Text[] endpointName = new Text[]{localName, domainName};
            NotificationRequestCmd.this.request.getEndpoint().divide('@', endpointName);
            if (localName.contains('*')) {
                throw new MgcpCommandException(503, new Text("Wildcard all is not allowed here"));
            }
            try {
                int n = NotificationRequestCmd.this.transaction().find(localName, NotificationRequestCmd.this.endpoints);
                if (n == 0) {
                    throw new MgcpCommandException(500, new Text("Unknown endpoint"));
                }
            }
            catch (UnknownEndpointException e) {
                throw new MgcpCommandException(500, new Text("Endpoint not available"));
            }
            NotificationRequestCmd.this.endpoint = NotificationRequestCmd.this.endpoints[0];
            NotificationRequestCmd.this.endpoint.getRequest().cancel();
            Parameter reqID = NotificationRequestCmd.this.request.getParameter(Parameter.REQUEST_ID);
            if (reqID == null) {
                throw new MgcpCommandException(510, new Text("Request identifier is missing"));
            }
            Text callAgent = null;
            Parameter p = NotificationRequestCmd.this.request.getParameter(Parameter.NOTIFIED_ENTITY);
            if (p != null) {
                callAgent = p.getValue();
            }
            Parameter pe = NotificationRequestCmd.this.request.getParameter(Parameter.REQUESTED_EVENTS);
            Parameter ps = NotificationRequestCmd.this.request.getParameter(Parameter.REQUESTED_SIGNALS);
            Collection events = null;
            Collection signals = null;
            if (pe != null) {
                events = pe.getValue().split(eventsSplit);
            }
            if (ps != null) {
                signals = ps.getValue().split(eventsSplit);
            }
            if (pe != null || ps != null) {
                try {
                    NotificationRequestCmd.this.endpoint.getRequest().accept(reqID.getValue(), callAgent, events, signals);
                }
                catch (UnknownEventException e1) {
                    throw new MgcpCommandException(512, new Text(e1.getMessage()));
                }
                catch (UnknownSignalException e2) {
                    throw new MgcpCommandException(513, new Text(e2.getMessage()));
                }
                catch (UnknownPackageException e) {
                    throw new MgcpCommandException(512, new Text(e.getMessage()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new MgcpCommandException(400, new Text(e.getMessage()));
                }
            }
            return 0L;
        }
    }
}

