/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.control.mgcp.controller.signal;

import java.util.ArrayList;
import org.restcomm.media.control.mgcp.controller.UnknownActivityException;
import org.restcomm.media.control.mgcp.controller.signal.MgcpPackage;
import org.restcomm.media.control.mgcp.controller.signal.RequestedEvent;
import org.restcomm.media.spi.Connection;
import org.restcomm.media.spi.Endpoint;
import org.restcomm.media.spi.utils.Text;

public abstract class Signal {
    private Text name;
    private RequestedEvent trigger = new RequestedEvent();
    protected ArrayList<Text> events = new ArrayList(15);
    private MgcpPackage mgcpPackage;

    public Signal(String name) {
        this.name = new Text(name);
    }

    public Text getName() {
        return this.name;
    }

    protected void setPackage(MgcpPackage mgcpPackage) {
        this.mgcpPackage = mgcpPackage;
    }

    protected MgcpPackage getPackage() {
        return this.mgcpPackage;
    }

    public void setTrigger(Text packageName, Text eventName, Text options) {
        this.trigger.setPackageName(packageName);
        this.trigger.setEventName(eventName);
        this.trigger.setParams(options);
    }

    protected RequestedEvent getTrigger() {
        return this.trigger;
    }

    public abstract void execute();

    public boolean accept(Text event) {
        this.events.add(event);
        return this.doAccept(event);
    }

    public abstract boolean doAccept(Text var1);

    public void reset() {
        this.cancel();
        this.events.clear();
    }

    protected void sendEvent(Text evt) {
        for (Text event : this.events) {
            if (!event.equals((Object)evt)) continue;
            this.mgcpPackage.onEvent(event);
        }
    }

    protected void sendEvent(Text pckName, Text evtName, Text params) {
        String s = pckName.toString() + "/" + evtName.toString() + "(" + params + ")";
        this.mgcpPackage.onEvent(new Text(s));
    }

    public abstract void cancel();

    protected void complete() {
        this.mgcpPackage.completed();
    }

    public Endpoint getEndpoint() {
        return this.mgcpPackage.getEndpoint();
    }

    public Connection getConnection(String ID) {
        try {
            return this.mgcpPackage.getConnection(ID);
        }
        catch (UnknownActivityException e) {
            return null;
        }
    }
}

