/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.control.mgcp.endpoint;

import java.util.concurrent.Semaphore;
import org.restcomm.media.Component;
import org.restcomm.media.ComponentType;
import org.restcomm.media.component.audio.AudioComponent;
import org.restcomm.media.component.oob.OOBComponent;
import org.restcomm.media.control.mgcp.resources.ResourcesPool;
import org.restcomm.media.resource.dtmf.DetectorImpl;
import org.restcomm.media.resource.dtmf.GeneratorImpl;
import org.restcomm.media.resource.player.audio.AudioPlayerImpl;
import org.restcomm.media.resource.recorder.audio.AudioRecorderImpl;
import org.restcomm.media.spi.ConnectionMode;
import org.restcomm.media.spi.Endpoint;

public class MediaGroup {
    private Component player;
    private Component recorder;
    private Component dtmfDetector;
    private Component dtmfGenerator;
    private ResourcesPool resourcesPool;
    private AudioComponent audioComponent;
    private OOBComponent oobComponent;
    private Endpoint endpoint;
    private int readComponents = 0;
    private int writeComponents = 0;
    private int readDtmfComponents = 0;
    private int writeDtmfComponents = 0;
    private Semaphore resourceSemaphore = new Semaphore(1);

    public MediaGroup(ResourcesPool resourcesPool, Endpoint endpoint) {
        this.resourcesPool = resourcesPool;
        this.audioComponent = new AudioComponent(0);
        this.oobComponent = new OOBComponent(0);
        this.endpoint = endpoint;
    }

    public AudioComponent getAudioComponent() {
        return this.audioComponent;
    }

    public OOBComponent getOOBComponent() {
        return this.oobComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getPlayer() {
        try {
            this.resourceSemaphore.acquire();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.player == null) {
                this.player = this.resourcesPool.newAudioComponent(ComponentType.PLAYER);
                this.audioComponent.addInput(((AudioPlayerImpl)this.player).getAudioInput());
                ++this.readComponents;
                this.audioComponent.updateMode(true, this.writeComponents != 0);
                this.updateEndpoint(1, 0);
            }
        }
        finally {
            this.resourceSemaphore.release();
        }
        return this.player;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releasePlayer() {
        try {
            this.resourceSemaphore.acquire();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.player != null) {
                this.audioComponent.remove(((AudioPlayerImpl)this.player).getAudioInput());
                --this.readComponents;
                this.audioComponent.updateMode(this.readComponents != 0, this.writeComponents != 0);
                this.updateEndpoint(-1, 0);
                ((AudioPlayerImpl)this.player).clearAllListeners();
                this.player.deactivate();
                this.resourcesPool.releaseAudioComponent(this.player, ComponentType.PLAYER);
                this.player = null;
            }
        }
        finally {
            this.resourceSemaphore.release();
        }
    }

    public boolean hasPlayer() {
        return this.player != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getRecorder() {
        try {
            this.resourceSemaphore.acquire();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.recorder == null) {
                this.recorder = this.resourcesPool.newAudioComponent(ComponentType.RECORDER);
                this.audioComponent.addOutput(((AudioRecorderImpl)this.recorder).getAudioOutput());
                this.oobComponent.addOutput(((AudioRecorderImpl)this.recorder).getOOBOutput());
                ++this.writeComponents;
                ++this.writeDtmfComponents;
                this.audioComponent.updateMode(this.readComponents != 0, true);
                this.oobComponent.updateMode(this.readDtmfComponents != 0, true);
                this.updateEndpoint(0, 1);
            }
        }
        finally {
            this.resourceSemaphore.release();
        }
        return this.recorder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseRecorder() {
        try {
            this.resourceSemaphore.acquire();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.recorder != null) {
                this.audioComponent.remove(((AudioRecorderImpl)this.recorder).getAudioOutput());
                this.oobComponent.remove(((AudioRecorderImpl)this.recorder).getOOBOutput());
                --this.writeComponents;
                --this.writeDtmfComponents;
                this.audioComponent.updateMode(this.readComponents != 0, this.writeComponents != 0);
                this.oobComponent.updateMode(this.readDtmfComponents != 0, this.writeDtmfComponents != 0);
                this.updateEndpoint(0, -1);
                ((AudioRecorderImpl)this.recorder).clearAllListeners();
                this.recorder.deactivate();
                this.resourcesPool.releaseAudioComponent(this.recorder, ComponentType.RECORDER);
                this.recorder = null;
            }
        }
        finally {
            this.resourceSemaphore.release();
        }
    }

    public boolean hasRecorder() {
        return this.recorder != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getDtmfDetector() {
        try {
            this.resourceSemaphore.acquire();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.dtmfDetector == null) {
                this.dtmfDetector = this.resourcesPool.newAudioComponent(ComponentType.DTMF_DETECTOR);
                this.audioComponent.addOutput(((DetectorImpl)this.dtmfDetector).getAudioOutput());
                this.oobComponent.addOutput(((DetectorImpl)this.dtmfDetector).getOOBOutput());
                ++this.writeComponents;
                ++this.writeDtmfComponents;
                this.audioComponent.updateMode(this.readComponents != 0, true);
                this.oobComponent.updateMode(this.readDtmfComponents != 0, true);
                this.updateEndpoint(0, 1);
            }
        }
        finally {
            this.resourceSemaphore.release();
        }
        return this.dtmfDetector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseDtmfDetector() {
        try {
            this.resourceSemaphore.acquire();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.dtmfDetector != null) {
                this.audioComponent.remove(((DetectorImpl)this.dtmfDetector).getAudioOutput());
                this.oobComponent.remove(((DetectorImpl)this.dtmfDetector).getOOBOutput());
                --this.writeComponents;
                --this.writeDtmfComponents;
                this.audioComponent.updateMode(this.readComponents != 0, this.writeComponents != 0);
                this.oobComponent.updateMode(this.readDtmfComponents != 0, this.writeDtmfComponents != 0);
                this.updateEndpoint(0, -1);
                ((DetectorImpl)this.dtmfDetector).clearAllListeners();
                this.dtmfDetector.deactivate();
                ((DetectorImpl)this.dtmfDetector).clearBuffer();
                this.resourcesPool.releaseAudioComponent(this.dtmfDetector, ComponentType.DTMF_DETECTOR);
                this.dtmfDetector = null;
            }
        }
        finally {
            this.resourceSemaphore.release();
        }
    }

    public boolean hasDtmfDetector() {
        return this.dtmfDetector != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getDtmfGenerator() {
        try {
            this.resourceSemaphore.acquire();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.dtmfGenerator == null) {
                this.dtmfGenerator = this.resourcesPool.newAudioComponent(ComponentType.DTMF_GENERATOR);
                this.audioComponent.addInput(((GeneratorImpl)this.dtmfGenerator).getAudioInput());
                this.oobComponent.addInput(((GeneratorImpl)this.dtmfGenerator).getOOBInput());
                ++this.readComponents;
                ++this.readDtmfComponents;
                this.audioComponent.updateMode(true, this.writeComponents != 0);
                this.oobComponent.updateMode(true, this.writeDtmfComponents != 0);
                this.updateEndpoint(1, 0);
            }
        }
        finally {
            this.resourceSemaphore.release();
        }
        return this.dtmfGenerator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseDtmfGenerator() {
        try {
            this.resourceSemaphore.acquire();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.dtmfGenerator != null) {
                this.audioComponent.remove(((GeneratorImpl)this.dtmfGenerator).getAudioInput());
                this.oobComponent.remove(((GeneratorImpl)this.dtmfGenerator).getOOBInput());
                --this.readComponents;
                --this.readDtmfComponents;
                this.audioComponent.updateMode(this.readComponents != 0, this.writeComponents != 0);
                this.oobComponent.updateMode(this.readDtmfComponents != 0, this.writeDtmfComponents != 0);
                this.updateEndpoint(-1, 0);
                this.dtmfGenerator.deactivate();
                this.resourcesPool.releaseAudioComponent(this.dtmfGenerator, ComponentType.DTMF_GENERATOR);
                this.dtmfGenerator = null;
            }
        }
        finally {
            this.resourceSemaphore.release();
        }
    }

    public boolean hasDtmfGenerator() {
        return this.dtmfGenerator != null;
    }

    private void updateEndpoint(int readChange, int writeChange) {
        boolean newWrite;
        boolean oldRead = this.readComponents - readChange != 0;
        boolean oldWrite = this.writeComponents - writeChange != 0;
        boolean newRead = this.readComponents != 0;
        boolean bl = newWrite = this.writeComponents != 0;
        if (newRead == oldRead && newWrite == oldWrite) {
            return;
        }
        ConnectionMode oldMode = oldRead ? (oldWrite ? ConnectionMode.CONFERENCE : ConnectionMode.RECV_ONLY) : (oldWrite ? ConnectionMode.SEND_ONLY : ConnectionMode.INACTIVE);
        ConnectionMode newMode = newRead ? (newWrite ? ConnectionMode.CONFERENCE : ConnectionMode.RECV_ONLY) : (newWrite ? ConnectionMode.SEND_ONLY : ConnectionMode.INACTIVE);
        this.endpoint.modeUpdated(oldMode, newMode);
    }

    public void releaseAll() {
        this.releasePlayer();
        this.releaseRecorder();
        this.releaseDtmfDetector();
        this.releaseDtmfGenerator();
    }
}

