/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.control.mgcp.endpoint.factory;

import java.util.concurrent.atomic.AtomicInteger;
import org.restcomm.media.control.mgcp.endpoint.factory.EndpointFactory;
import org.restcomm.media.control.mgcp.endpoint.naming.EndpointNameGenerator;
import org.restcomm.media.spi.Endpoint;

public abstract class AbstractEndpointFactory<T extends Endpoint>
implements EndpointFactory<T> {
    protected final EndpointNameGenerator nameParser;
    protected final AtomicInteger idGenerator = new AtomicInteger(1);
    protected final String endpointPattern;
    protected final int initialSize;

    public AbstractEndpointFactory(String endpointPattern, int initialSize) {
        this.endpointPattern = endpointPattern;
        this.initialSize = initialSize;
        this.nameParser = new EndpointNameGenerator();
        this.nameParser.setPattern(endpointPattern);
    }

    public AbstractEndpointFactory(String endpointPattern) {
        this(endpointPattern, 0);
    }

    public String getEndpointPattern() {
        return this.endpointPattern;
    }

    protected String generateName() {
        return this.endpointPattern + this.idGenerator.getAndIncrement();
    }
}

