/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.control.mgcp.controller;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.restcomm.media.control.mgcp.MgcpEvent;
import org.restcomm.media.control.mgcp.MgcpListener;
import org.restcomm.media.control.mgcp.MgcpProvider;
import org.restcomm.media.control.mgcp.controller.Configurator;
import org.restcomm.media.control.mgcp.controller.MgcpEndpoint;
import org.restcomm.media.control.mgcp.controller.naming.NamingTree;
import org.restcomm.media.control.mgcp.endpoint.BaseEndpointImpl;
import org.restcomm.media.control.mgcp.endpoint.factory.VirtualEndpointInstaller;
import org.restcomm.media.control.mgcp.endpoint.naming.NamingService;
import org.restcomm.media.control.mgcp.resources.ResourcesPool;
import org.restcomm.media.control.mgcp.tx.GlobalTransactionManager;
import org.restcomm.media.control.mgcp.tx.Transaction;
import org.restcomm.media.network.deprecated.UdpManager;
import org.restcomm.media.scheduler.PriorityQueueScheduler;
import org.restcomm.media.scheduler.Scheduler;
import org.restcomm.media.spi.ControlProtocol;
import org.restcomm.media.spi.Endpoint;
import org.restcomm.media.spi.EndpointInstaller;
import org.restcomm.media.spi.ServerManager;
import org.restcomm.media.spi.listener.TooManyListenersException;

public class Controller
implements MgcpListener,
ServerManager {
    private static final String HOME_DIR = "MMS_HOME";
    private static final Logger logger = Logger.getLogger(Controller.class);
    private UdpManager udpInterface;
    private PriorityQueueScheduler mediaScheduler;
    private Scheduler taskScheduler;
    private ResourcesPool resourcesPool;
    private MgcpProvider mgcpProvider;
    private NamingTree namingTree = new NamingTree();
    private Configurator configurator;
    protected GlobalTransactionManager txManager;
    private final NamingService namingService = new NamingService();
    private final ArrayList<EndpointInstaller> installers = new ArrayList(5);
    private final Map<String, Endpoint> endpoints = new ConcurrentHashMap<String, Endpoint>();
    protected int port;
    protected int poolSize = 10;
    private boolean active = false;

    public void setUdpInterface(UdpManager udpInterface) {
        this.udpInterface = udpInterface;
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setMediaScheduler(PriorityQueueScheduler scheduler) {
        this.mediaScheduler = scheduler;
    }

    public void setTaskScheduler(Scheduler taskScheduler) {
        this.taskScheduler = taskScheduler;
    }

    public void setResourcesPool(ResourcesPool resourcesPool) {
        this.resourcesPool = resourcesPool;
    }

    public void setConfiguration(String url) throws Exception {
        try {
            if (url != null) {
                String home = Controller.getHomeDir();
                if (home == null) {
                    throw new IOException("MMS_HOME not set");
                }
                String path = home + "/conf/" + url;
                FileInputStream stream = new FileInputStream(path);
                this.configurator = new Configurator(stream);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Could not configure MGCP controller", (Throwable)e);
            throw e;
        }
    }

    public void setConfigurationByURL(URL url) throws Exception {
        try {
            this.configurator = new Configurator(url.openStream());
        }
        catch (Exception e) {
            logger.error((Object)"Could not configure MGCP controller", (Throwable)e);
            throw e;
        }
    }

    private static String getHomeDir() {
        String mmsHomeDir = System.getProperty(HOME_DIR);
        if (mmsHomeDir == null) {
            mmsHomeDir = System.getenv(HOME_DIR);
        }
        return mmsHomeDir;
    }

    public void createProvider() {
        this.mgcpProvider = new MgcpProvider(this.udpInterface, this.port);
    }

    public void createGlobalTransactionManager() {
        this.txManager = new GlobalTransactionManager(this.taskScheduler, this.mediaScheduler.getClock());
        this.txManager.setPoolSize(this.poolSize);
        this.txManager.setNamingService(this.namingTree);
        this.txManager.setMgcpProvider(this.mgcpProvider);
    }

    public void addInstaller(EndpointInstaller installer) {
        ((VirtualEndpointInstaller)installer).setController(this);
        this.installers.add(installer);
    }

    public void removeInstaller(EndpointInstaller installer) {
        this.installers.remove(installer);
        installer.uninstall();
    }

    public void start() {
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Starting MGCP provider");
        }
        this.createProvider();
        this.mgcpProvider.activate();
        try {
            this.mgcpProvider.addListener(this);
        }
        catch (TooManyListenersException e) {
            logger.error((Object)e);
        }
        this.createGlobalTransactionManager();
        for (EndpointInstaller installer : this.installers) {
            installer.install();
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Controller started");
        }
    }

    public void stop() {
        if (this.mgcpProvider != null) {
            this.mgcpProvider.shutdown();
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Controller stopped");
        }
    }

    public void process(MgcpEvent event) {
        int transactionId = event.getMessage().getTxID();
        Transaction tx = this.findTransaction(event.getEventID(), transactionId, (InetSocketAddress)event.getAddress());
        if (tx != null) {
            tx.process(event);
        } else {
            logger.warn((Object)("Could not find MGCP transaction id=" + transactionId));
        }
    }

    private Transaction findTransaction(int eventId, int transactionId, InetSocketAddress remoteAddress) {
        if (eventId == 1) {
            return this.txManager.allocateNew(remoteAddress, transactionId);
        }
        return this.txManager.find(remoteAddress, transactionId);
    }

    public void onStarted(Endpoint endpoint, EndpointInstaller installer) {
        try {
            MgcpEndpoint mgcpEndpoint = this.configurator.activate(endpoint, this.mgcpProvider, this.udpInterface.getLocalBindAddress(), this.port);
            mgcpEndpoint.setMgcpListener(this);
            this.namingTree.register(mgcpEndpoint, installer);
            logger.info((Object)("Endpoint restarted: " + endpoint.getLocalName()));
        }
        catch (Exception e) {
            logger.error((Object)("Could not register endpoint: " + endpoint.getLocalName()));
        }
    }

    public void onStopped(Endpoint endpoint) {
    }

    public void install(Endpoint endpoint, EndpointInstaller installer) {
        if (endpoint == null) {
            logger.error((Object)"Unknown endpoint");
            return;
        }
        BaseEndpointImpl baseEndpoint = null;
        try {
            baseEndpoint = (BaseEndpointImpl)endpoint;
        }
        catch (ClassCastException e) {
            logger.error((Object)("Unsupported endpoint implementation " + endpoint.getLocalName()));
            return;
        }
        baseEndpoint.setScheduler(this.mediaScheduler);
        baseEndpoint.setResourcesPool(this.resourcesPool);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Installing " + endpoint.getLocalName()));
        }
        try {
            endpoint.start();
        }
        catch (Exception e) {
            logger.error((Object)("Couldn't start endpoint " + endpoint.getLocalName()), (Throwable)e);
            return;
        }
        try {
            this.namingService.register(endpoint);
        }
        catch (Exception e) {
            endpoint.stop();
            logger.error((Object)("Could not register endpoint " + endpoint.getLocalName()), (Throwable)e);
        }
        this.endpoints.put(endpoint.getLocalName(), endpoint);
        this.onStarted(endpoint, installer);
    }

    public void uninstall(String name) {
        Endpoint endpoint = this.endpoints.remove(name);
        this.onStopped(endpoint);
        try {
            endpoint = this.namingService.lookup(name, true);
            if (endpoint != null) {
                endpoint.stop();
                this.namingService.unregister(endpoint);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public void activate() throws IllegalStateException {
        if (this.active) {
            throw new IllegalStateException("Controller is already active.");
        }
        this.active = true;
        this.start();
    }

    public void deactivate() throws IllegalStateException {
        if (!this.active) {
            throw new IllegalStateException("Controller is already inactive.");
        }
        this.active = false;
        this.stop();
    }

    public boolean isActive() {
        return this.active;
    }

    public ControlProtocol getControlProtocol() {
        return ControlProtocol.MGPC;
    }
}

