/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.control.mgcp.endpoint;

import java.util.Iterator;
import org.apache.log4j.Logger;
import org.restcomm.media.Component;
import org.restcomm.media.ComponentType;
import org.restcomm.media.concurrent.ConcurrentMap;
import org.restcomm.media.control.mgcp.connection.BaseConnection;
import org.restcomm.media.control.mgcp.endpoint.MediaGroup;
import org.restcomm.media.control.mgcp.resources.ResourcesPool;
import org.restcomm.media.scheduler.PriorityQueueScheduler;
import org.restcomm.media.spi.Connection;
import org.restcomm.media.spi.ConnectionType;
import org.restcomm.media.spi.Endpoint;
import org.restcomm.media.spi.EndpointState;
import org.restcomm.media.spi.MediaType;
import org.restcomm.media.spi.ResourceUnavailableException;

public abstract class BaseEndpointImpl
implements Endpoint {
    private static final Logger logger = Logger.getLogger(BaseEndpointImpl.class);
    private PriorityQueueScheduler scheduler;
    protected ResourcesPool resourcesPool;
    private final String localName;
    private EndpointState state = EndpointState.READY;
    protected MediaGroup mediaGroup;
    private final ConcurrentMap<Connection> connections;

    public BaseEndpointImpl(String localName) {
        this.localName = localName;
        this.connections = new ConcurrentMap();
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setScheduler(PriorityQueueScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public PriorityQueueScheduler getScheduler() {
        return this.scheduler;
    }

    public void setResourcesPool(ResourcesPool resourcesPool) {
        this.resourcesPool = resourcesPool;
    }

    public ResourcesPool getResourcesPool() {
        return this.resourcesPool;
    }

    public EndpointState getState() {
        return this.state;
    }

    public void setState(EndpointState state) {
        this.state = state;
    }

    public void start() throws ResourceUnavailableException {
        if (this.scheduler == null) {
            throw new ResourceUnavailableException("Scheduler is not available");
        }
        if (this.resourcesPool == null) {
            throw new ResourceUnavailableException("Resources pool is not available");
        }
        this.mediaGroup = new MediaGroup(this.resourcesPool, this);
    }

    public void stop() {
        this.mediaGroup.releaseAll();
        this.deleteAllConnections();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Stopped endpoint " + this.localName));
        }
    }

    public Connection createConnection(ConnectionType type, Boolean isLocal) throws ResourceUnavailableException {
        Connection connection = null;
        switch (type) {
            case RTP: {
                connection = this.resourcesPool.newConnection(false);
                break;
            }
            case LOCAL: {
                connection = this.resourcesPool.newConnection(true);
            }
        }
        connection.setIsLocal(isLocal.booleanValue());
        try {
            ((BaseConnection)connection).bind();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ResourceUnavailableException(e.getMessage());
        }
        connection.setEndpoint((Endpoint)this);
        this.connections.put((Object)connection.getId(), (Object)connection);
        return connection;
    }

    public void deleteConnection(Connection connection) {
        ((BaseConnection)connection).close();
    }

    public void deleteConnection(Connection connection, ConnectionType connectionType) {
        this.connections.remove((Object)connection.getId());
        switch (connectionType) {
            case RTP: {
                this.resourcesPool.releaseConnection(connection, false);
                break;
            }
            case LOCAL: {
                this.resourcesPool.releaseConnection(connection, true);
            }
        }
        if (this.connections.size() == 0) {
            this.mediaGroup.releaseAll();
        }
    }

    public void deleteAllConnections() {
        Iterator connectionsIterator = this.connections.valuesIterator();
        while (connectionsIterator.hasNext()) {
            ((BaseConnection)connectionsIterator.next()).close();
        }
    }

    public Connection getConnection(int connectionID) {
        return (Connection)this.connections.get((Object)connectionID);
    }

    public int getActiveConnectionsCount() {
        return this.connections.size();
    }

    public Component getResource(MediaType mediaType, ComponentType componentType) {
        switch (mediaType) {
            case AUDIO: {
                switch (componentType) {
                    case PLAYER: {
                        return this.mediaGroup.getPlayer();
                    }
                    case RECORDER: {
                        return this.mediaGroup.getRecorder();
                    }
                    case DTMF_DETECTOR: {
                        return this.mediaGroup.getDtmfDetector();
                    }
                    case DTMF_GENERATOR: {
                        return this.mediaGroup.getDtmfGenerator();
                    }
                }
                break;
            }
        }
        return null;
    }

    public boolean hasResource(MediaType mediaType, ComponentType componentType) {
        switch (mediaType) {
            case AUDIO: {
                switch (componentType) {
                    case PLAYER: {
                        return this.mediaGroup.hasPlayer();
                    }
                    case RECORDER: {
                        return this.mediaGroup.hasRecorder();
                    }
                    case DTMF_DETECTOR: {
                        return this.mediaGroup.hasDtmfDetector();
                    }
                    case DTMF_GENERATOR: {
                        return this.mediaGroup.hasDtmfGenerator();
                    }
                }
                break;
            }
        }
        return false;
    }

    public void releaseResource(MediaType mediaType, ComponentType componentType) {
        switch (mediaType) {
            case AUDIO: {
                switch (componentType) {
                    case PLAYER: {
                        this.mediaGroup.releasePlayer();
                    }
                    case RECORDER: {
                        this.mediaGroup.releaseRecorder();
                    }
                    case DTMF_DETECTOR: {
                        this.mediaGroup.releaseDtmfDetector();
                    }
                    case DTMF_GENERATOR: {
                        this.mediaGroup.releaseDtmfGenerator();
                    }
                }
                break;
            }
        }
    }
}

