/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.control.mgcp.endpoint.factory;

import java.lang.reflect.Constructor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.restcomm.media.control.mgcp.controller.Controller;
import org.restcomm.media.control.mgcp.endpoint.naming.EndpointNameGenerator;
import org.restcomm.media.core.Server;
import org.restcomm.media.spi.Endpoint;
import org.restcomm.media.spi.EndpointInstaller;

public class VirtualEndpointInstaller
implements EndpointInstaller {
    private static final Logger logger = Logger.getLogger(VirtualEndpointInstaller.class);
    private String namePattern;
    private String endpointClass;
    protected Integer initialSize;
    protected final EndpointNameGenerator nameParser;
    protected AtomicInteger lastEndpointID = new AtomicInteger(1);
    protected Controller controller;

    public VirtualEndpointInstaller() {
        this.nameParser = new EndpointNameGenerator();
    }

    public String getNamePattern() {
        return this.namePattern;
    }

    public void setNamePattern(String namePattern) {
        this.namePattern = namePattern;
    }

    public String getEndpointClass() {
        return this.endpointClass;
    }

    public void setEndpointClass(String endpointClass) {
        this.endpointClass = endpointClass;
    }

    public Integer getInitialSize() {
        return this.initialSize;
    }

    public void setInitialSize(Integer initialSize) {
        this.initialSize = initialSize;
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public void install() {
        for (int i = 0; i < this.initialSize; ++i) {
            this.newEndpoint();
        }
    }

    public void newEndpoint() {
        ClassLoader loader = Server.class.getClassLoader();
        this.nameParser.setPattern(this.namePattern);
        try {
            Constructor<?> constructor = loader.loadClass(this.endpointClass).getConstructor(String.class);
            Endpoint endpoint = (Endpoint)constructor.newInstance(this.namePattern + this.lastEndpointID.getAndIncrement());
            this.controller.install(endpoint, this);
        }
        catch (Exception e) {
            logger.error((Object)"Couldn't instantiate endpoint", (Throwable)e);
        }
    }

    public boolean canExpand() {
        return true;
    }

    public void uninstall() {
    }
}

