/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.control.mgcp.pkg.au;

import java.net.MalformedURLException;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.restcomm.media.ComponentType;
import org.restcomm.media.control.mgcp.controller.signal.Event;
import org.restcomm.media.control.mgcp.controller.signal.NotifyImmediately;
import org.restcomm.media.control.mgcp.controller.signal.Signal;
import org.restcomm.media.control.mgcp.pkg.au.BufferListener;
import org.restcomm.media.control.mgcp.pkg.au.EventBuffer;
import org.restcomm.media.control.mgcp.pkg.au.InteruptPrompt;
import org.restcomm.media.control.mgcp.pkg.au.Options;
import org.restcomm.media.control.mgcp.pkg.au.PlayerMode;
import org.restcomm.media.scheduler.PriorityQueueScheduler;
import org.restcomm.media.scheduler.Task;
import org.restcomm.media.spi.MediaType;
import org.restcomm.media.spi.ResourceUnavailableException;
import org.restcomm.media.spi.dtmf.DtmfDetector;
import org.restcomm.media.spi.dtmf.DtmfDetectorListener;
import org.restcomm.media.spi.listener.TooManyListenersException;
import org.restcomm.media.spi.player.Player;
import org.restcomm.media.spi.player.PlayerEvent;
import org.restcomm.media.spi.player.PlayerListener;
import org.restcomm.media.spi.utils.Text;

public class PlayCollect
extends Signal {
    private static final Logger logger = Logger.getLogger(PlayCollect.class);
    private static final Text RC_300 = new Text("rc=300");
    private static final Text RC_301 = new Text("rc=301");
    private final Event oc = new Event(new Text("oc"));
    private final Event of = new Event(new Text("of"));
    private PriorityQueueScheduler scheduler;
    private Player player;
    private DtmfDetector dtmfDetector;
    private Options options;
    private final EventBuffer buffer;
    private final PromptHandler promptHandler;
    private final DtmfHandler dtmfHandler;
    private volatile boolean isPromptActive;
    private Text[] prompt;
    private int promptLength;
    private int promptIndex;
    private long firstDigitTimer;
    private long nextDigitTimer;
    private int maxDuration;
    private int numberOfAttempts;
    private int segCount = 0;
    private PlayerMode playerMode;
    private Text eventContent;
    private Heartbeat heartbeat;
    private boolean dtmfListenerAdded = false;
    private boolean playerListenerAdded = false;
    private final AtomicBoolean terminated;
    private final Object LOCK;

    public PlayCollect(String name) {
        super(name);
        this.oc.add(new NotifyImmediately("N"));
        this.oc.add(new InteruptPrompt("S", this.player));
        this.of.add(new NotifyImmediately("N"));
        this.dtmfHandler = new DtmfHandler(this);
        this.promptHandler = new PromptHandler(this);
        this.buffer = new EventBuffer();
        this.isPromptActive = false;
        this.prompt = new Text[10];
        this.promptLength = 0;
        this.promptIndex = 0;
        this.firstDigitTimer = 0L;
        this.nextDigitTimer = 0L;
        this.maxDuration = 0;
        this.numberOfAttempts = 1;
        this.segCount = 0;
        this.playerMode = PlayerMode.PROMPT;
        this.dtmfListenerAdded = false;
        this.playerListenerAdded = false;
        this.terminated = new AtomicBoolean(false);
        this.LOCK = new Object();
    }

    @Override
    public void execute() {
        if (this.getEndpoint().getActiveConnectionsCount() == 0) {
            this.oc.fire(this, new Text("rc=326"));
            this.complete();
            return;
        }
        this.playerMode = PlayerMode.PROMPT;
        this.promptLength = 0;
        this.promptIndex = 0;
        this.segCount = 0;
        this.scheduler = this.getEndpoint().getScheduler();
        this.heartbeat = new Heartbeat(this);
        this.options = Options.allocate(this.getTrigger().getParams());
        if (logger.isInfoEnabled()) {
            logger.info((Object)String.format("(%s) Prepare digit collect phase", this.getEndpoint().getLocalName()));
        }
        this.prepareCollectPhase(this.options);
        this.firstDigitTimer = this.options.getFirstDigitTimer() > 0L ? this.options.getFirstDigitTimer() : 0L;
        this.nextDigitTimer = this.options.getInterDigitTimer() > 0L ? this.options.getInterDigitTimer() : 0L;
        this.maxDuration = this.options.getMaxDuration() > 0 ? this.options.getMaxDuration() : 0;
        this.numberOfAttempts = this.options.getNumberOfAttempts() > 1 ? this.options.getNumberOfAttempts() : 1;
        this.terminated.set(false);
        if (this.options.hasPrompt()) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)String.format("(%s) Start prompt phase", this.getEndpoint().getLocalName()));
            }
            this.isPromptActive = true;
            this.startPromptPhase(this.options.getPrompt());
            return;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)String.format("(%s) Start collect phase", this.getEndpoint().getLocalName()));
        }
        this.flushBuffer();
        this.startCollectPhase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startPromptPhase(Collection<Text> promptList) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.terminated.get()) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)"Skipping prompt phase because PlayCollect has been terminated.");
                }
                return;
            }
            this.player = this.getPlayer();
            try {
                if (!this.playerListenerAdded) {
                    this.player.addListener((PlayerListener)this.promptHandler);
                    this.playerListenerAdded = true;
                }
                this.promptLength = promptList.size();
                this.prompt = promptList.toArray(this.prompt);
                this.player.setURL(this.prompt[0].toString());
                this.player.activate();
            }
            catch (TooManyListenersException e) {
                this.of.fire(this, RC_300);
                logger.error((Object)"Too many listeners, firing of");
            }
            catch (MalformedURLException e) {
                this.of.fire(this, RC_301);
                logger.error((Object)"Received URL in invalid format, firing of");
            }
            catch (ResourceUnavailableException e) {
                this.of.fire(this, RC_301);
                logger.error((Object)"Received URL can not be found, firing of");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminatePrompt() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.promptLength > 0) {
                this.promptIndex = this.promptLength - 1;
            }
            if (this.player != null) {
                this.player.deactivate();
                this.player.removeListener((PlayerListener)this.promptHandler);
                this.playerListenerAdded = false;
                this.player = null;
            }
        }
    }

    private void prepareCollectPhase(Options options) {
        this.dtmfDetector = this.getDetector();
        if (options.isClearDigits()) {
            this.dtmfDetector.clearDigits();
        }
        this.buffer.reset();
        this.buffer.setListener(this.dtmfHandler);
        this.buffer.setPatterns(options.getDigitPattern());
        if (options.getMaxDigitsNumber() > 0) {
            this.buffer.setCount(options.getMaxDigitsNumber());
        } else {
            this.buffer.setCount(options.getDigitsNumber());
        }
        this.dtmfDetector.activate();
    }

    private void flushBuffer() {
        try {
            if (!this.dtmfListenerAdded) {
                this.dtmfDetector.addListener((DtmfDetectorListener)this.buffer);
                this.dtmfListenerAdded = true;
            }
            this.dtmfDetector.flushBuffer();
        }
        catch (TooManyListenersException e) {
            this.of.fire(this, RC_300);
            logger.error((Object)"Too many listeners for DTMF detector, firing of");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startCollectPhase() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.terminated.get()) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)"Skipping collect phase because PlayCollect has been terminated.");
                }
                return;
            }
            if (this.firstDigitTimer > 0L || this.maxDuration > 0) {
                if (this.firstDigitTimer > 0L) {
                    this.heartbeat.setTtl((int)this.firstDigitTimer);
                } else {
                    this.heartbeat.setTtl(-1);
                }
                if (this.maxDuration > 0) {
                    this.heartbeat.setOverallTtl(this.maxDuration);
                } else {
                    this.heartbeat.setOverallTtl(-1);
                }
                this.heartbeat.activate();
                this.getEndpoint().getScheduler().submitHeatbeat((Task)this.heartbeat);
            }
            this.buffer.activate();
            this.buffer.flush();
        }
    }

    private void terminateCollectPhase() {
        if (this.dtmfDetector != null) {
            this.dtmfDetector.removeListener((DtmfDetectorListener)this.buffer);
            this.dtmfDetector.deactivate();
            this.dtmfListenerAdded = false;
            this.buffer.passivate();
            this.buffer.clear();
            this.dtmfDetector = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminate() {
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.terminated.get()) {
                this.terminated.set(true);
                this.isPromptActive = false;
                this.terminatePrompt();
                this.terminateCollectPhase();
                if (this.heartbeat != null) {
                    this.heartbeat.disable();
                    this.heartbeat = null;
                }
                if (this.options != null) {
                    Options.recycle(this.options);
                    this.options = null;
                }
            }
        }
    }

    @Override
    public boolean doAccept(Text event) {
        if (!this.oc.isActive() && this.oc.matches(event)) {
            return true;
        }
        return !this.of.isActive() && this.of.matches(event);
    }

    @Override
    public void cancel() {
        if (this.heartbeat != null) {
            this.heartbeat.disable();
        }
        this.isPromptActive = false;
        this.terminate();
    }

    private Player getPlayer() {
        return (Player)this.getEndpoint().getResource(MediaType.AUDIO, ComponentType.PLAYER);
    }

    private DtmfDetector getDetector() {
        return (DtmfDetector)this.getEndpoint().getResource(MediaType.AUDIO, ComponentType.DTMF_DETECTOR);
    }

    @Override
    public void reset() {
        super.reset();
        this.isPromptActive = false;
        this.terminate();
        this.oc.reset();
        this.of.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void next(long delay) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.terminated.get() || !this.isPromptActive) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)"Skipping prompt phase because PlayCollect has been terminated.");
                }
                return;
            }
            ++this.segCount;
            ++this.promptIndex;
            try {
                String url = this.prompt[this.promptIndex].toString();
                if (logger.isInfoEnabled()) {
                    logger.info((Object)String.format("(%s) Processing player next with url - %s", this.getEndpoint().getLocalName(), url));
                }
                this.player.setURL(url);
                this.player.setInitialDelay(delay);
                this.player.start();
            }
            catch (MalformedURLException e) {
                this.of.fire(this, RC_301);
                logger.error((Object)"Received URL in invalid format , firing of");
            }
            catch (ResourceUnavailableException e) {
                this.of.fire(this, RC_301);
                logger.error((Object)"Received URL can not be found , firing of");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prev(long delay) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.terminated.get() || !this.isPromptActive) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)"Skipping prompt phase because PlayCollect has been terminated.");
                }
                return;
            }
            ++this.segCount;
            --this.promptIndex;
            try {
                String url = this.prompt[this.promptIndex].toString();
                if (logger.isInfoEnabled()) {
                    logger.info((Object)String.format("(%s) Processing player prev with url - %s", this.getEndpoint().getLocalName(), url));
                }
                this.player.setURL(url);
                this.player.setInitialDelay(delay);
                this.player.start();
            }
            catch (MalformedURLException e) {
                this.of.fire(this, RC_301);
                logger.error((Object)"Received URL in invalid format, firing of");
                return;
            }
            catch (ResourceUnavailableException e) {
                this.of.fire(this, RC_301);
                logger.error((Object)"Received URL can not be found, firing of");
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void curr(long delay) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.terminated.get() || !this.isPromptActive) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)"Skipping prompt phase because PlayCollect has been terminated.");
                }
                return;
            }
            ++this.segCount;
            try {
                String url = this.prompt[this.promptIndex].toString();
                if (logger.isInfoEnabled()) {
                    logger.info((Object)String.format("(%s) Processing player curr with url - %s", this.getEndpoint().getLocalName(), url));
                }
                this.player.setURL(url);
                this.player.setInitialDelay(delay);
                this.player.start();
            }
            catch (MalformedURLException e) {
                this.of.fire(this, RC_301);
                logger.error((Object)"Received URL in invalid format, firing of");
            }
            catch (ResourceUnavailableException e) {
                this.of.fire(this, RC_301);
                logger.error((Object)"Received URL can not be found, firing of");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void first(long delay) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.terminated.get() || !this.isPromptActive) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)"Skipping prompt phase because PlayCollect has been terminated.");
                }
                return;
            }
            ++this.segCount;
            this.promptIndex = 0;
            try {
                String url = this.prompt[this.promptIndex].toString();
                if (logger.isInfoEnabled()) {
                    logger.info((Object)String.format("(%s) Processing player first with url - %s", this.getEndpoint().getLocalName(), url));
                }
                this.player.setURL(url);
                this.player.setInitialDelay(delay);
                this.player.start();
            }
            catch (MalformedURLException e) {
                this.of.fire(this, RC_301);
                logger.error((Object)"Received URL in invalid format , firing of");
            }
            catch (ResourceUnavailableException e) {
                this.of.fire(this, RC_301);
                logger.error((Object)"Received URL can not be found , firing of");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void last(long delay) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.terminated.get() || !this.isPromptActive) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)"Skipping prompt phase because PlayCollect has been terminated.");
                }
                return;
            }
            ++this.segCount;
            this.promptIndex = this.promptLength - 1;
            try {
                String url = this.prompt[this.promptIndex].toString();
                if (logger.isInfoEnabled()) {
                    logger.info((Object)String.format("(%s) Processing player last with url - %s", this.getEndpoint().getLocalName(), url));
                }
                this.player.setURL(url);
                this.player.setInitialDelay(delay);
                this.player.start();
            }
            catch (MalformedURLException e) {
                this.of.fire(this, RC_301);
                logger.error((Object)"Received URL in invalid format , firing of");
            }
            catch (ResourceUnavailableException e) {
                this.of.fire(this, RC_301);
                logger.error((Object)"Received URL can not be found , firing of");
            }
        }
    }

    private void decreaseNa() {
        --this.numberOfAttempts;
        if (this.options.hasReprompt()) {
            this.buffer.passivate();
            this.isPromptActive = true;
            this.startPromptPhase(this.options.getReprompt());
            this.heartbeat.disable();
        } else if (this.options.hasPrompt()) {
            this.buffer.passivate();
            this.isPromptActive = true;
            this.startPromptPhase(this.options.getPrompt());
            this.heartbeat.disable();
        } else {
            this.startCollectPhase();
        }
    }

    private class Heartbeat
    extends Task {
        private final AtomicInteger ttl = new AtomicInteger(-1);
        private final AtomicInteger overallTtl = new AtomicInteger(-1);
        private final AtomicBoolean active = new AtomicBoolean(false);
        private Signal signal;

        public Heartbeat(Signal signal) {
            this.signal = signal;
        }

        public int getQueueNumber() {
            return PriorityQueueScheduler.HEARTBEAT_QUEUE;
        }

        public void setTtl(int value) {
            this.ttl.set(value);
        }

        public void setOverallTtl(int value) {
            this.overallTtl.set(value);
        }

        public void disable() {
            this.active.set(false);
        }

        public void activate() {
            this.active.set(true);
        }

        public boolean isActive() {
            return this.active.get();
        }

        public long perform() {
            if (!this.active.get()) {
                return 0L;
            }
            int ttlValue = this.ttl.get();
            int overallTtlValue = this.overallTtl.get();
            if (ttlValue != 0 && overallTtlValue != 0) {
                if (ttlValue > 0) {
                    this.ttl.set(ttlValue - 1);
                }
                if (overallTtlValue > 0) {
                    this.overallTtl.set(overallTtlValue - 1);
                }
                PlayCollect.this.scheduler.submitHeatbeat((Task)this);
                return 0L;
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)String.format("(%s) Timeout expired waiting for dtmf", PlayCollect.this.getEndpoint().getLocalName()));
            }
            if (PlayCollect.this.numberOfAttempts == 1) {
                String naContent = "";
                if (PlayCollect.this.options.getNumberOfAttempts() > 1) {
                    naContent = " na=" + PlayCollect.this.options.getNumberOfAttempts();
                }
                if (ttlValue == 0) {
                    int length = PlayCollect.this.buffer.getSequence().length();
                    if (PlayCollect.this.options.getDigitsNumber() > 0 && length >= PlayCollect.this.options.getDigitsNumber()) {
                        if (PlayCollect.this.options.hasSuccessAnnouncement()) {
                            PlayCollect.this.eventContent = new Text("rc=100 dc=" + PlayCollect.this.buffer.getSequence() + naContent);
                            PlayCollect.this.playerMode = PlayerMode.SUCCESS;
                            PlayCollect.this.startPromptPhase(PlayCollect.this.options.getSuccessAnnouncement());
                        } else {
                            PlayCollect.this.oc.fire(this.signal, new Text("rc=100 dc=" + PlayCollect.this.buffer.getSequence() + naContent));
                            PlayCollect.this.reset();
                            PlayCollect.this.complete();
                        }
                    } else if (length > 0) {
                        if (PlayCollect.this.options.hasNoDigitsReprompt()) {
                            PlayCollect.this.eventContent = new Text("rc=326 dc=" + PlayCollect.this.buffer.getSequence() + naContent);
                            PlayCollect.this.playerMode = PlayerMode.FAILURE;
                            PlayCollect.this.startPromptPhase(PlayCollect.this.options.getNoDigitsReprompt());
                        } else if (PlayCollect.this.options.hasFailureAnnouncement()) {
                            PlayCollect.this.eventContent = new Text("rc=326 dc=" + PlayCollect.this.buffer.getSequence() + naContent);
                            PlayCollect.this.playerMode = PlayerMode.FAILURE;
                            PlayCollect.this.startPromptPhase(PlayCollect.this.options.getFailureAnnouncement());
                        } else {
                            PlayCollect.this.oc.fire(this.signal, new Text("rc=326 dc=" + PlayCollect.this.buffer.getSequence() + naContent));
                            PlayCollect.this.reset();
                            PlayCollect.this.complete();
                        }
                    } else if (PlayCollect.this.options.hasNoDigitsReprompt()) {
                        PlayCollect.this.eventContent = new Text("rc=326" + naContent);
                        PlayCollect.this.playerMode = PlayerMode.FAILURE;
                        PlayCollect.this.startPromptPhase(PlayCollect.this.options.getNoDigitsReprompt());
                    } else if (PlayCollect.this.options.hasFailureAnnouncement()) {
                        PlayCollect.this.eventContent = new Text("rc=326" + naContent);
                        PlayCollect.this.playerMode = PlayerMode.FAILURE;
                        PlayCollect.this.startPromptPhase(PlayCollect.this.options.getFailureAnnouncement());
                    } else {
                        PlayCollect.this.oc.fire(this.signal, new Text("rc=326" + naContent));
                        PlayCollect.this.reset();
                        PlayCollect.this.complete();
                    }
                } else if (PlayCollect.this.options.hasNoDigitsReprompt()) {
                    PlayCollect.this.eventContent = new Text("rc=330" + naContent);
                    PlayCollect.this.playerMode = PlayerMode.FAILURE;
                    PlayCollect.this.startPromptPhase(PlayCollect.this.options.getNoDigitsReprompt());
                } else if (PlayCollect.this.options.hasFailureAnnouncement()) {
                    PlayCollect.this.eventContent = new Text("rc=330" + naContent);
                    PlayCollect.this.playerMode = PlayerMode.FAILURE;
                    PlayCollect.this.startPromptPhase(PlayCollect.this.options.getFailureAnnouncement());
                } else {
                    PlayCollect.this.oc.fire(this.signal, new Text("rc=330" + naContent));
                    PlayCollect.this.reset();
                    PlayCollect.this.complete();
                }
            } else {
                PlayCollect.this.buffer.reset();
                PlayCollect.this.decreaseNa();
            }
            return 0L;
        }
    }

    private class DtmfHandler
    implements BufferListener {
        private PlayCollect signal;

        public DtmfHandler(PlayCollect signal) {
            this.signal = signal;
        }

        @Override
        public void patternMatches(int index, String s) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)String.format("(%s) Collect phase: pattern has been detected", PlayCollect.this.getEndpoint().getLocalName()));
            }
            String naContent = "";
            if (PlayCollect.this.options.getNumberOfAttempts() > 1) {
                naContent = " na=" + (PlayCollect.this.options.getNumberOfAttempts() - PlayCollect.this.numberOfAttempts + 1);
            }
            if (PlayCollect.this.options.hasSuccessAnnouncement()) {
                PlayCollect.this.eventContent = new Text("rc=100 dc=" + s + " pi=" + index + naContent);
                PlayCollect.this.playerMode = PlayerMode.SUCCESS;
                PlayCollect.this.startPromptPhase(PlayCollect.this.options.getSuccessAnnouncement());
            } else {
                PlayCollect.this.oc.fire(this.signal, new Text("rc=100 dc=" + s + " pi=" + index + naContent));
                PlayCollect.this.reset();
                PlayCollect.this.complete();
            }
        }

        @Override
        public void countMatches(String s) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)String.format("(%s) Collect phase: max number of digits detected", PlayCollect.this.getEndpoint().getLocalName()));
            }
            String naContent = "";
            if (PlayCollect.this.options.getNumberOfAttempts() > 1) {
                naContent = " na=" + (PlayCollect.this.options.getNumberOfAttempts() - PlayCollect.this.numberOfAttempts + 1);
            }
            if (PlayCollect.this.options.hasSuccessAnnouncement()) {
                PlayCollect.this.eventContent = new Text("rc=100 dc=" + s + naContent);
                PlayCollect.this.playerMode = PlayerMode.SUCCESS;
                PlayCollect.this.startPromptPhase(PlayCollect.this.options.getSuccessAnnouncement());
            } else {
                PlayCollect.this.oc.fire(this.signal, new Text("rc=100 dc=" + s + naContent));
                PlayCollect.this.reset();
                PlayCollect.this.complete();
            }
        }

        @Override
        public boolean tone(String s) {
            if (PlayCollect.this.options.getMaxDigitsNumber() > 0 && s.charAt(0) == PlayCollect.this.options.getEndInputKey() && PlayCollect.this.buffer.length() >= PlayCollect.this.options.getDigitsNumber()) {
                String naContent = "";
                if (PlayCollect.this.options.getNumberOfAttempts() > 1) {
                    naContent = " na=" + (PlayCollect.this.options.getNumberOfAttempts() - PlayCollect.this.numberOfAttempts + 1);
                }
                if (logger.isInfoEnabled()) {
                    logger.info((Object)String.format("(%s) End Input Tone '%s' has been detected", PlayCollect.this.getEndpoint().getLocalName(), s));
                }
                if (PlayCollect.this.options.hasSuccessAnnouncement()) {
                    if (PlayCollect.this.options.isIncludeEndInputKey()) {
                        PlayCollect.this.eventContent = new Text("rc=100 dc=" + PlayCollect.this.buffer.getSequence() + s + naContent);
                    } else {
                        PlayCollect.this.eventContent = new Text("rc=100 dc=" + PlayCollect.this.buffer.getSequence() + naContent);
                    }
                    PlayCollect.this.playerMode = PlayerMode.SUCCESS;
                    PlayCollect.this.startPromptPhase(PlayCollect.this.options.getSuccessAnnouncement());
                } else {
                    if (PlayCollect.this.options.isIncludeEndInputKey()) {
                        PlayCollect.this.oc.fire(this.signal, new Text("rc=100 dc=" + PlayCollect.this.buffer.getSequence() + s + naContent));
                    } else {
                        PlayCollect.this.oc.fire(this.signal, new Text("rc=100 dc=" + PlayCollect.this.buffer.getSequence() + naContent));
                    }
                    PlayCollect.this.heartbeat.disable();
                    PlayCollect.this.reset();
                    PlayCollect.this.complete();
                }
                return true;
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)String.format("(%s) Tone '%s' has been detected", PlayCollect.this.getEndpoint().getLocalName(), s));
            }
            if (PlayCollect.this.isPromptActive) {
                if (PlayCollect.this.options.prevKeyValid() && PlayCollect.this.options.getPrevKey() == s.charAt(0)) {
                    PlayCollect.this.prev(PlayCollect.this.options.getInterval());
                    return false;
                }
                if (PlayCollect.this.options.firstKeyValid() && PlayCollect.this.options.getFirstKey() == s.charAt(0)) {
                    PlayCollect.this.first(PlayCollect.this.options.getInterval());
                    return false;
                }
                if (PlayCollect.this.options.currKeyValid() && PlayCollect.this.options.getCurrKey() == s.charAt(0)) {
                    PlayCollect.this.curr(PlayCollect.this.options.getInterval());
                    return false;
                }
                if (PlayCollect.this.options.nextKeyValid() && PlayCollect.this.options.getNextKey() == s.charAt(0)) {
                    PlayCollect.this.next(PlayCollect.this.options.getInterval());
                    return false;
                }
                if (PlayCollect.this.options.lastKeyValid() && PlayCollect.this.options.getLastKey() == s.charAt(0)) {
                    PlayCollect.this.last(PlayCollect.this.options.getInterval());
                    return false;
                }
            }
            if (!PlayCollect.this.options.isNonInterruptable()) {
                if (PlayCollect.this.isPromptActive) {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)String.format("(%s) Tone '%s' detected: prompt phase interrupted", PlayCollect.this.getEndpoint().getLocalName(), s));
                    }
                    PlayCollect.this.terminatePrompt();
                } else if (logger.isInfoEnabled()) {
                    logger.info((Object)String.format("(%s) Tone '%s' detected: collected", PlayCollect.this.getEndpoint().getLocalName(), s));
                }
            } else if (PlayCollect.this.isPromptActive) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)String.format("(%s) Tone '%s' detected, waiting for prompt phase termination", PlayCollect.this.getEndpoint().getLocalName(), s));
                }
                if (PlayCollect.this.options.isClearDigits()) {
                    return false;
                }
            } else if (logger.isInfoEnabled()) {
                logger.info((Object)String.format("(%s) Tone '%s' has been detected: collected", PlayCollect.this.getEndpoint().getLocalName(), s));
            }
            if (PlayCollect.this.nextDigitTimer > 0L) {
                PlayCollect.this.heartbeat.setTtl((int)PlayCollect.this.nextDigitTimer);
                if (!PlayCollect.this.heartbeat.isActive()) {
                    PlayCollect.this.heartbeat.activate();
                    PlayCollect.this.getEndpoint().getScheduler().submitHeatbeat((Task)PlayCollect.this.heartbeat);
                }
            } else if (PlayCollect.this.maxDuration == 0) {
                PlayCollect.this.heartbeat.disable();
            }
            return true;
        }
    }

    private class PromptHandler
    implements PlayerListener {
        private PlayCollect signal;

        protected PromptHandler(PlayCollect signal) {
            this.signal = signal;
        }

        public void process(PlayerEvent event) {
            switch (event.getID()) {
                case 1: {
                    if (PlayCollect.this.segCount != 0) break;
                    PlayCollect.this.flushBuffer();
                    break;
                }
                case 2: {
                    if (PlayCollect.this.promptIndex < PlayCollect.this.promptLength - 1) {
                        PlayCollect.this.next(PlayCollect.this.options.getInterval());
                        return;
                    }
                    switch (PlayCollect.this.playerMode) {
                        case PROMPT: {
                            if (!PlayCollect.this.isPromptActive) break;
                            PlayCollect.this.isPromptActive = false;
                            if (logger.isInfoEnabled()) {
                                logger.info((Object)String.format("(%s) Prompt phase terminated, start collect phase", PlayCollect.this.getEndpoint().getLocalName()));
                            }
                            PlayCollect.this.startCollectPhase();
                            break;
                        }
                        case SUCCESS: {
                            PlayCollect.this.oc.fire(this.signal, PlayCollect.this.eventContent);
                            PlayCollect.this.reset();
                            PlayCollect.this.complete();
                            break;
                        }
                        case FAILURE: {
                            if (PlayCollect.this.numberOfAttempts == 1) {
                                PlayCollect.this.oc.fire(this.signal, PlayCollect.this.eventContent);
                                PlayCollect.this.reset();
                                PlayCollect.this.complete();
                                break;
                            }
                            PlayCollect.this.decreaseNa();
                        }
                    }
                    break;
                }
                case 3: {
                    PlayCollect.this.of.fire(this.signal, RC_300);
                    PlayCollect.this.complete();
                }
            }
        }
    }
}

