/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.control.mgcp.call;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Logger;
import org.restcomm.media.control.mgcp.call.MgcpCall;
import org.restcomm.media.control.mgcp.call.MgcpCallManager;

public class GlobalMgcpCallManager
implements MgcpCallManager {
    private static final Logger log = Logger.getLogger(GlobalMgcpCallManager.class);
    private final ConcurrentMap<Integer, MgcpCall> calls = new ConcurrentHashMap<Integer, MgcpCall>();

    @Override
    public MgcpCall getCall(int callId) {
        return (MgcpCall)this.calls.get(callId);
    }

    @Override
    public boolean registerCall(MgcpCall call) {
        boolean registered;
        MgcpCall old = this.calls.putIfAbsent(call.getCallId(), call);
        boolean bl = registered = old == null;
        if (registered && log.isDebugEnabled()) {
            log.debug((Object)("Registered new call " + call.getCallIdHex() + ". Call count: " + this.calls.size()));
        }
        return registered;
    }

    @Override
    public MgcpCall unregisterCall(int callId) {
        boolean removed;
        MgcpCall call = (MgcpCall)this.calls.remove(callId);
        boolean bl = removed = call != null;
        if (removed && log.isDebugEnabled()) {
            log.debug((Object)("Unregistered call " + call.getCallIdHex() + ". Call count: " + this.calls.size()));
        }
        return call;
    }

    @Override
    public Set<MgcpCall> unregisterCalls() {
        Set<MgcpCall> values;
        if (this.calls.isEmpty()) {
            values = Collections.emptySet();
        } else {
            values = new HashSet(this.calls.values());
            this.calls.clear();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Unregistered " + values.size() + " calls: " + Arrays.toString(this.getCallHexId(values))));
            }
        }
        return values;
    }

    private String[] getCallHexId(Collection<MgcpCall> calls) {
        if (calls.isEmpty()) {
            return new String[0];
        }
        String[] hexIds = new String[calls.size()];
        int index = 0;
        for (MgcpCall call : calls) {
            hexIds[index] = call.getCallIdHex();
            ++index;
        }
        return hexIds;
    }
}

