/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.control.mgcp.controller;

import com.google.common.util.concurrent.FutureCallback;
import java.net.InetSocketAddress;
import org.apache.log4j.Logger;
import org.restcomm.media.control.mgcp.command.MgcpCommand;
import org.restcomm.media.control.mgcp.command.MgcpCommandProvider;
import org.restcomm.media.control.mgcp.controller.fsm.MgcpControllerEvent;
import org.restcomm.media.control.mgcp.controller.fsm.MgcpControllerFsm;
import org.restcomm.media.control.mgcp.controller.fsm.MgcpControllerFsmBuilder;
import org.restcomm.media.control.mgcp.controller.fsm.MgcpControllerGlobalContext;
import org.restcomm.media.control.mgcp.controller.fsm.MgcpControllerState;
import org.restcomm.media.control.mgcp.endpoint.MgcpEndpointManager;
import org.restcomm.media.control.mgcp.exception.DuplicateMgcpTransactionException;
import org.restcomm.media.control.mgcp.exception.MgcpTransactionNotFoundException;
import org.restcomm.media.control.mgcp.message.MessageDirection;
import org.restcomm.media.control.mgcp.message.MgcpMessage;
import org.restcomm.media.control.mgcp.message.MgcpMessageObserver;
import org.restcomm.media.control.mgcp.message.MgcpRequest;
import org.restcomm.media.control.mgcp.message.MgcpResponse;
import org.restcomm.media.control.mgcp.message.MgcpResponseCode;
import org.restcomm.media.control.mgcp.network.netty.AsyncMgcpChannel;
import org.restcomm.media.control.mgcp.transaction.MgcpTransactionManager;
import org.restcomm.media.spi.ControlProtocol;
import org.restcomm.media.spi.Endpoint;
import org.restcomm.media.spi.EndpointInstaller;
import org.restcomm.media.spi.ServerManager;

public class MgcpController
implements ServerManager,
MgcpMessageObserver {
    private static final Logger log = Logger.getLogger(MgcpController.class);
    private final MgcpTransactionManager transactions;
    private final MgcpEndpointManager endpoints;
    private final MgcpCommandProvider commands;
    private final MgcpControllerGlobalContext context;
    private final MgcpControllerFsm fsm;

    public MgcpController(String address, int port, AsyncMgcpChannel channel, MgcpTransactionManager transactions, MgcpEndpointManager endpoints, MgcpCommandProvider commands) {
        this.transactions = transactions;
        this.endpoints = endpoints;
        this.commands = commands;
        this.context = new MgcpControllerGlobalContext();
        this.context.setBindAddress(new InetSocketAddress(address, port));
        this.context.setChannel(channel);
        this.fsm = MgcpControllerFsmBuilder.INSTANCE.build(this.context);
        this.fsm.start();
    }

    public ControlProtocol getControlProtocol() {
        return ControlProtocol.MGPC;
    }

    public void activate() throws IllegalStateException {
        if (this.isActive()) {
            throw new IllegalStateException("Controller is already active");
        }
        this.context.getChannel().observe(this);
        this.transactions.observe(this);
        this.endpoints.observe(this);
        this.fsm.fire((Object)MgcpControllerEvent.ACTIVATE);
    }

    public void deactivate() throws IllegalStateException {
        if (!this.isActive()) {
            throw new IllegalStateException("Controller is already inactive");
        }
        this.context.getChannel().forget(this);
        this.transactions.forget(this);
        this.endpoints.observe(this);
        this.fsm.fire((Object)MgcpControllerEvent.DEACTIVATE);
    }

    public boolean isActive() {
        return MgcpControllerState.ACTIVATED.equals(this.fsm.getCurrentState());
    }

    public void onStarted(Endpoint endpoint, EndpointInstaller installer) {
    }

    public void onStopped(Endpoint endpoint) {
    }

    @Override
    public void onMessage(InetSocketAddress from, InetSocketAddress to, MgcpMessage message, MessageDirection direction) {
        switch (direction) {
            case INCOMING: {
                if (message.isRequest()) {
                    this.onIncomingRequest(from, to, (MgcpRequest)message);
                    break;
                }
                this.onIncomingResponse(from, to, (MgcpResponse)message);
                break;
            }
            case OUTGOING: {
                if (message.isRequest()) {
                    this.onOutgoingRequest(from, to, (MgcpRequest)message);
                    break;
                }
                this.onOutgoingResponse(from, to, (MgcpResponse)message);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown message direction: " + direction.name());
            }
        }
    }

    private void onIncomingRequest(InetSocketAddress from, InetSocketAddress to, MgcpRequest request) {
        MgcpCommand command = this.commands.provide(request.getRequestType(), request.getTransactionId(), request.getParameters());
        try {
            this.transactions.process(from, to, request, command, MessageDirection.INCOMING);
        }
        catch (DuplicateMgcpTransactionException e) {
            MgcpResponseCode provisional = MgcpResponseCode.TRANSACTION_BEING_EXECUTED;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Received duplicate request tx=" + request.getTransactionId() + " from " + from.toString() + ". Sending provisional response with code " + provisional.code()));
            }
            this.sendResponse(to, request.getTransactionId(), provisional.code(), provisional.message());
        }
    }

    private void onOutgoingRequest(InetSocketAddress from, InetSocketAddress to, MgcpRequest request) {
        try {
            this.transactions.process(from, to, request, null, MessageDirection.OUTGOING);
            this.context.getChannel().send(request, to, new SendChannelCallback());
        }
        catch (DuplicateMgcpTransactionException e) {
            log.error((Object)(e.getMessage() + ". Request wont' be sent to call agent."));
        }
    }

    private void onIncomingResponse(InetSocketAddress from, InetSocketAddress to, MgcpResponse response) {
        try {
            this.transactions.process(from, to, response, MessageDirection.INCOMING);
        }
        catch (MgcpTransactionNotFoundException e) {
            log.error((Object)e.getMessage());
        }
    }

    private void onOutgoingResponse(InetSocketAddress from, InetSocketAddress to, MgcpResponse response) {
        try {
            this.transactions.process(from, to, response, MessageDirection.OUTGOING);
            this.context.getChannel().send(response, to, new SendChannelCallback());
        }
        catch (MgcpTransactionNotFoundException e) {
            log.error((Object)(e.getMessage() + ". Response won't be sent to call agent."));
        }
    }

    private void sendResponse(InetSocketAddress to, int transactionId, int code, String message) {
        MgcpResponse response = new MgcpResponse();
        response.setTransactionId(transactionId);
        response.setCode(code);
        response.setMessage(message);
        this.context.getChannel().send(response, to, new SendChannelCallback());
    }

    private class SendChannelCallback
    implements FutureCallback<Void> {
        private SendChannelCallback() {
        }

        public void onSuccess(Void result) {
        }

        public void onFailure(Throwable t) {
            log.warn((Object)"Could not send MGCP message to remote peer.", t);
        }
    }
}

