/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.control.mgcp.endpoint;

import org.restcomm.media.component.audio.AudioMixer;
import org.restcomm.media.component.oob.OOBMixer;
import org.restcomm.media.control.mgcp.connection.MgcpConnection;
import org.restcomm.media.control.mgcp.connection.MgcpConnectionProvider;
import org.restcomm.media.control.mgcp.endpoint.EndpointIdentifier;
import org.restcomm.media.control.mgcp.endpoint.GenericMgcpEndpoint;
import org.restcomm.media.control.mgcp.endpoint.MediaGroup;
import org.restcomm.media.control.mgcp.endpoint.MediaGroupImpl;

public class MgcpMixerEndpoint
extends GenericMgcpEndpoint {
    private final AudioMixer inbandMixer;
    private final OOBMixer outbandMixer;

    public MgcpMixerEndpoint(EndpointIdentifier endpointId, AudioMixer inbandMixer, OOBMixer outbandMixer, MgcpConnectionProvider connectionProvider, MediaGroup mediaGroup) {
        super(endpointId, connectionProvider, mediaGroup);
        this.inbandMixer = inbandMixer;
        this.outbandMixer = outbandMixer;
    }

    @Override
    protected void onConnectionCreated(MgcpConnection connection) {
        this.inbandMixer.addComponent(connection.getAudioComponent());
        this.outbandMixer.addComponent(connection.getOutOfBandComponent());
    }

    @Override
    protected void onConnectionDeleted(MgcpConnection connection) {
        this.inbandMixer.release(connection.getAudioComponent());
        this.outbandMixer.release(connection.getOutOfBandComponent());
    }

    @Override
    protected void onActivated() {
        this.inbandMixer.addComponent(((MediaGroupImpl)this.mediaGroup).getAudioComponent());
        this.outbandMixer.addComponent(((MediaGroupImpl)this.mediaGroup).getOobComponent());
        this.inbandMixer.start();
        this.outbandMixer.start();
    }

    @Override
    protected void onDeactivated() {
        this.inbandMixer.release(((MediaGroupImpl)this.mediaGroup).getAudioComponent());
        this.outbandMixer.release(((MediaGroupImpl)this.mediaGroup).getOobComponent());
        this.inbandMixer.stop();
        this.outbandMixer.stop();
    }
}

