/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.control.mgcp.network.netty;

import com.google.common.collect.Sets;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.net.InetSocketAddress;
import java.util.Set;
import org.apache.log4j.Logger;
import org.restcomm.media.control.mgcp.message.MessageDirection;
import org.restcomm.media.control.mgcp.message.MgcpMessage;
import org.restcomm.media.control.mgcp.message.MgcpMessageObserver;
import org.restcomm.media.control.mgcp.message.MgcpMessageSubject;
import org.restcomm.media.control.mgcp.network.netty.MgcpMessageEnvelope;

public class MgcpChannelInboundHandler
extends SimpleChannelInboundHandler<MgcpMessageEnvelope>
implements MgcpMessageSubject {
    private static final Logger log = Logger.getLogger(MgcpChannelInboundHandler.class);
    private final Set<MgcpMessageObserver> observers = Sets.newConcurrentHashSet();

    protected void channelRead0(ChannelHandlerContext ctx, MgcpMessageEnvelope msg) throws Exception {
        this.notify(this, (InetSocketAddress)msg.sender(), (InetSocketAddress)msg.recipient(), (MgcpMessage)msg.content(), MessageDirection.INCOMING);
    }

    @Override
    public void observe(MgcpMessageObserver observer) {
        this.observers.add(observer);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Registered MgcpMessageObserver@" + observer.hashCode() + ". Count: " + this.observers.size()));
        }
    }

    @Override
    public void forget(MgcpMessageObserver observer) {
        this.observers.remove(observer);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Unregistered MgcpMessageObserver@" + observer.hashCode() + ". Count: " + this.observers.size()));
        }
    }

    @Override
    public void notify(Object originator, InetSocketAddress from, InetSocketAddress to, MgcpMessage message, MessageDirection direction) {
        for (MgcpMessageObserver observer : this.observers) {
            if (observer == originator) continue;
            observer.onMessage(from, to, message, direction);
        }
    }
}

