/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.control.mgcp.pkg;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.restcomm.media.control.mgcp.exception.MalformedMgcpEventRequestException;
import org.restcomm.media.control.mgcp.exception.MgcpEventNotFoundException;
import org.restcomm.media.control.mgcp.exception.MgcpPackageNotFoundException;
import org.restcomm.media.control.mgcp.pkg.MgcpEvent;
import org.restcomm.media.control.mgcp.pkg.MgcpEventProvider;
import org.restcomm.media.control.mgcp.pkg.MgcpRequestedEvent;

public class GlobalMgcpEventProvider
implements MgcpEventProvider {
    private static final Logger log = Logger.getLogger(GlobalMgcpEventProvider.class);
    private Map<String, MgcpEventProvider> eventProviders = new HashMap<String, MgcpEventProvider>(5);

    public void registerProvider(String pkg, MgcpEventProvider provider) {
        MgcpEventProvider value = this.eventProviders.put(pkg, provider);
        if (value == null && log.isDebugEnabled()) {
            log.debug((Object)("Registered MGCP Event Provider for package " + pkg));
        }
    }

    public MgcpEventProvider unregisterProvider(String pkg) {
        MgcpEventProvider value = this.eventProviders.remove(pkg);
        if (value != null && log.isDebugEnabled()) {
            log.debug((Object)("Unregistered MGCP Event Provider for package " + pkg));
        }
        return value;
    }

    @Override
    public MgcpEvent provide(MgcpRequestedEvent event) throws MgcpPackageNotFoundException, MgcpEventNotFoundException, MalformedMgcpEventRequestException {
        String pkg = event.getPackageName();
        MgcpEventProvider eventProvider = this.eventProviders.get(pkg);
        if (eventProvider == null) {
            throw new MgcpPackageNotFoundException("No event provider was registered for package " + pkg);
        }
        return eventProvider.provide(event);
    }
}

