/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.control.mgcp.pkg;

import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import java.util.Map;
import org.restcomm.media.control.mgcp.command.param.NotifiedEntity;
import org.restcomm.media.control.mgcp.endpoint.MediaGroup;
import org.restcomm.media.control.mgcp.endpoint.MgcpEndpoint;
import org.restcomm.media.control.mgcp.pkg.MgcpSignal;
import org.restcomm.media.control.mgcp.pkg.au.AudioSignalType;
import org.restcomm.media.control.mgcp.pkg.au.EndSignal;
import org.restcomm.media.control.mgcp.pkg.au.PlayAnnouncement;
import org.restcomm.media.control.mgcp.pkg.au.pc.PlayCollect;
import org.restcomm.media.control.mgcp.pkg.au.pr.PlayRecord;
import org.restcomm.media.control.mgcp.pkg.exception.UnrecognizedMgcpPackageException;
import org.restcomm.media.control.mgcp.pkg.exception.UnsupportedMgcpSignalException;

public class MgcpSignalProvider {
    private final ListeningScheduledExecutorService executor;

    public MgcpSignalProvider(ListeningScheduledExecutorService executor) {
        this.executor = executor;
    }

    public MgcpSignal provide(String pkg, String signal, int requestId, NotifiedEntity notifiedEntity, Map<String, String> parameters, MgcpEndpoint endpoint) throws UnrecognizedMgcpPackageException, UnsupportedMgcpSignalException {
        switch (pkg) {
            case "AU": {
                return this.provideAudioSignal(signal, requestId, notifiedEntity, parameters, endpoint, this.executor);
            }
        }
        throw new UnrecognizedMgcpPackageException("Unrecognized package " + pkg);
    }

    private MgcpSignal provideAudioSignal(String signal, int requestId, NotifiedEntity notifiedEntity, Map<String, String> parameters, MgcpEndpoint endpoint, ListeningScheduledExecutorService executor) throws UnsupportedMgcpSignalException {
        AudioSignalType signalType = AudioSignalType.fromSymbol(signal);
        if (signalType == null) {
            throw new UnsupportedMgcpSignalException("Package AU does not support signal " + signal);
        }
        MediaGroup mediaGroup = endpoint.getMediaGroup();
        switch (signalType) {
            case PLAY_ANNOUNCEMENT: {
                return new PlayAnnouncement(mediaGroup.getPlayer(), requestId, notifiedEntity, parameters);
            }
            case PLAY_COLLECT: {
                return new PlayCollect(mediaGroup.getPlayer(), mediaGroup.getDetector(), requestId, notifiedEntity, parameters, executor);
            }
            case PLAY_RECORD: {
                return new PlayRecord(mediaGroup.getPlayer(), mediaGroup.getDetector(), mediaGroup.getRecorder(), requestId, notifiedEntity, parameters);
            }
            case END_SIGNAL: {
                return new EndSignal(endpoint, requestId, notifiedEntity, parameters);
            }
        }
        throw new IllegalArgumentException("Unsupported audio signal: " + signal);
    }
}

