/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.control.mgcp.pkg.au.pr;

import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.log4j.Logger;
import org.restcomm.media.control.mgcp.pkg.MgcpEventSubject;
import org.restcomm.media.control.mgcp.pkg.au.OperationComplete;
import org.restcomm.media.control.mgcp.pkg.au.OperationFailed;
import org.restcomm.media.control.mgcp.pkg.au.Playlist;
import org.restcomm.media.control.mgcp.pkg.au.ReturnCode;
import org.restcomm.media.control.mgcp.pkg.au.pr.PlayRecordContext;
import org.restcomm.media.control.mgcp.pkg.au.pr.PlayRecordEvent;
import org.restcomm.media.control.mgcp.pkg.au.pr.PlayRecordFsm;
import org.restcomm.media.control.mgcp.pkg.au.pr.PlayRecordState;
import org.restcomm.media.spi.ResourceUnavailableException;
import org.restcomm.media.spi.dtmf.DtmfDetector;
import org.restcomm.media.spi.dtmf.DtmfDetectorListener;
import org.restcomm.media.spi.listener.TooManyListenersException;
import org.restcomm.media.spi.player.Player;
import org.restcomm.media.spi.player.PlayerListener;
import org.restcomm.media.spi.recorder.Recorder;
import org.restcomm.media.spi.recorder.RecorderListener;
import org.squirrelframework.foundation.fsm.impl.AbstractStateMachine;

public class PlayRecordFsmImpl
extends AbstractStateMachine<PlayRecordFsm, PlayRecordState, PlayRecordEvent, PlayRecordContext>
implements PlayRecordFsm {
    private static final Logger log = Logger.getLogger(PlayRecordFsmImpl.class);
    private final MgcpEventSubject mgcpEventSubject;
    private final DtmfDetector detector;
    final DtmfDetectorListener detectorListener;
    private final Player player;
    final PlayerListener playerListener;
    private final Recorder recorder;
    final RecorderListener recorderListener;
    private final PlayRecordContext context;

    public PlayRecordFsmImpl(MgcpEventSubject mgcpEventSubject, Recorder recorder, RecorderListener recorderListener, DtmfDetector detector, DtmfDetectorListener detectorListener, Player player, PlayerListener playerListener, PlayRecordContext context) {
        this.mgcpEventSubject = mgcpEventSubject;
        this.recorder = recorder;
        this.recorderListener = recorderListener;
        this.detector = detector;
        this.detectorListener = detectorListener;
        this.player = player;
        this.playerListener = playerListener;
        this.context = context;
    }

    private void playAnnouncement(String url, long delay) {
        try {
            this.player.setInitialDelay(delay);
            this.player.setURL(url);
            this.player.activate();
        }
        catch (MalformedURLException e) {
            log.warn((Object)("Could not play malformed segment " + url));
            this.context.setReturnCode(ReturnCode.BAD_AUDIO_ID.code());
            this.fire((Object)PlayRecordEvent.FAIL, this.context);
        }
        catch (ResourceUnavailableException e) {
            log.warn((Object)("Could not play unavailable segment " + url));
            this.context.setReturnCode(ReturnCode.BAD_AUDIO_ID.code());
            this.fire((Object)PlayRecordEvent.FAIL, this.context);
        }
    }

    private void deleteRecording() {
        try {
            Path path = Paths.get(this.context.getRecordId(), new String[0]);
            if (Files.exists(path, new LinkOption[0])) {
                Files.delete(path);
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)"Deleted temporary recording file before restart.");
            }
        }
        catch (IOException e) {
            log.warn((Object)"Failed to delete temporary recording file before restart.", (Throwable)e);
        }
    }

    @Override
    public void enterLoadingPlaylist(PlayRecordState from, PlayRecordState to, PlayRecordEvent event, PlayRecordContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Entered LOADING PLAYLIST state");
        }
    }

    @Override
    public void exitLoadingPlaylist(PlayRecordState from, PlayRecordState to, PlayRecordEvent event, PlayRecordContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Exited LOADING PLAYLIST state");
        }
    }

    @Override
    public void enterPrompting(PlayRecordState from, PlayRecordState to, PlayRecordEvent event, PlayRecordContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Entered PROMPTING state");
        }
        Playlist prompt = context.getInitialPrompt();
        try {
            this.player.addListener(this.playerListener);
            this.playAnnouncement(prompt.next(), 0L);
        }
        catch (TooManyListenersException e) {
            log.error((Object)"Too many player listeners", (Throwable)e);
            context.setReturnCode(ReturnCode.UNSPECIFIED_FAILURE.code());
            this.fire((Object)PlayRecordEvent.FAIL, context);
        }
    }

    @Override
    public void onPrompting(PlayRecordState from, PlayRecordState to, PlayRecordEvent event, PlayRecordContext context) {
        Playlist prompt;
        String next;
        if (log.isTraceEnabled()) {
            log.trace((Object)"On PROMPTING state");
        }
        if ((next = (prompt = context.getInitialPrompt()).next()).isEmpty()) {
            this.fire((Object)PlayRecordEvent.PROMPT_END, context);
        } else {
            this.playAnnouncement(next, 1000L);
        }
    }

    @Override
    public void exitPrompting(PlayRecordState from, PlayRecordState to, PlayRecordEvent event, PlayRecordContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Exited PROMPTING state");
        }
        this.player.removeListener(this.playerListener);
        this.player.deactivate();
    }

    @Override
    public void enterReprompting(PlayRecordState from, PlayRecordState to, PlayRecordEvent event, PlayRecordContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Entered REPROMPTING state");
        }
        Playlist prompt = context.getReprompt();
        try {
            this.player.addListener(this.playerListener);
            this.playAnnouncement(prompt.next(), 0L);
        }
        catch (TooManyListenersException e) {
            log.error((Object)"Too many player listeners", (Throwable)e);
            context.setReturnCode(ReturnCode.UNSPECIFIED_FAILURE.code());
            this.fire((Object)PlayRecordEvent.FAIL, context);
        }
    }

    @Override
    public void onReprompting(PlayRecordState from, PlayRecordState to, PlayRecordEvent event, PlayRecordContext context) {
        Playlist prompt;
        String next;
        if (log.isTraceEnabled()) {
            log.trace((Object)"On REPROMPTING state");
        }
        if ((next = (prompt = context.getReprompt()).next()).isEmpty()) {
            this.fire((Object)PlayRecordEvent.PROMPT_END, context);
        } else {
            this.playAnnouncement(next, 1000L);
        }
    }

    @Override
    public void exitReprompting(PlayRecordState from, PlayRecordState to, PlayRecordEvent event, PlayRecordContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Exited REPROMPTING state");
        }
        this.player.removeListener(this.playerListener);
        this.player.deactivate();
    }

    @Override
    public void enterNoSpeechReprompting(PlayRecordState from, PlayRecordState to, PlayRecordEvent event, PlayRecordContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Entered NO SPEECH REPROMPTING state");
        }
        Playlist prompt = context.getNoSpeechReprompt();
        try {
            this.player.addListener(this.playerListener);
            this.playAnnouncement(prompt.next(), 0L);
        }
        catch (TooManyListenersException e) {
            log.error((Object)"Too many player listeners", (Throwable)e);
            context.setReturnCode(ReturnCode.UNSPECIFIED_FAILURE.code());
            this.fire((Object)PlayRecordEvent.FAIL, context);
        }
    }

    @Override
    public void onNoSpeechReprompting(PlayRecordState from, PlayRecordState to, PlayRecordEvent event, PlayRecordContext context) {
        Playlist prompt;
        String next;
        if (log.isTraceEnabled()) {
            log.trace((Object)"On NO SPEECH REPROMPTING state");
        }
        if ((next = (prompt = context.getNoSpeechReprompt()).next()).isEmpty()) {
            this.fire((Object)PlayRecordEvent.PROMPT_END, context);
        } else {
            this.playAnnouncement(next, 1000L);
        }
    }

    @Override
    public void exitNoSpeechReprompting(PlayRecordState from, PlayRecordState to, PlayRecordEvent event, PlayRecordContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Exited NO SPEECH REPROMPTING state");
        }
        this.player.removeListener(this.playerListener);
        this.player.deactivate();
    }

    @Override
    public void enterCollecting(PlayRecordState from, PlayRecordState to, PlayRecordEvent event, PlayRecordContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Entered COLLECTING state");
        }
        try {
            this.detector.addListener(this.detectorListener);
            this.detector.activate();
        }
        catch (TooManyListenersException e) {
            log.error((Object)"Too many DTMF listeners", (Throwable)e);
        }
    }

    @Override
    public void onCollecting(PlayRecordState from, PlayRecordState to, PlayRecordEvent event, PlayRecordContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"On COLLECTING state");
        }
        char tone = context.getTone();
        if (context.getRestartKey() == tone) {
            this.fire((Object)PlayRecordEvent.RESTART, context);
        } else if (context.getReinputKey() == tone) {
            this.fire((Object)PlayRecordEvent.REINPUT, context);
        } else if (context.getEndInputKey() == tone) {
            this.fire((Object)PlayRecordEvent.END_RECORD, context);
        }
    }

    @Override
    public void exitCollecting(PlayRecordState from, PlayRecordState to, PlayRecordEvent event, PlayRecordContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Exited COLLECTING state");
        }
        this.detector.removeListener(this.detectorListener);
        this.detector.deactivate();
    }

    @Override
    public void enterCollected(PlayRecordState from, PlayRecordState to, PlayRecordEvent event, PlayRecordContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Entered COLLECTED state");
        }
    }

    @Override
    public void enterRecording(PlayRecordState from, PlayRecordState to, PlayRecordEvent event, PlayRecordContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Entered RECORDING state");
        }
        try {
            this.recorder.setMaxRecordTime((long)context.getTotalRecordingLengthTimer() * 1000000L);
            this.recorder.setPreSpeechTimer((long)context.getPreSpeechTimer() * 1000000L);
            this.recorder.setPostSpeechTimer((long)context.getPostSpeechTimer() * 1000000L);
            this.recorder.setRecordFile(context.getRecordId(), false);
            this.recorder.addListener(this.recorderListener);
            this.recorder.activate();
        }
        catch (IOException e) {
            log.error((Object)("Recording URL cannot be found:" + context.getRecordId()), (Throwable)e);
            context.setReturnCode(ReturnCode.BAD_AUDIO_ID.code());
            this.fire((Object)PlayRecordEvent.FAIL, context);
        }
        catch (TooManyListenersException e) {
            log.error((Object)"Too many recorder listeners.");
            context.setReturnCode(ReturnCode.UNSPECIFIED_FAILURE.code());
            this.fire((Object)PlayRecordEvent.FAIL, context);
        }
    }

    @Override
    public void onRecording(PlayRecordState from, PlayRecordState to, PlayRecordEvent event, PlayRecordContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"on RECORDING state");
        }
        if (PlayRecordEvent.SPEECH_DETECTED.equals((Object)event)) {
            log.info((Object)"SPEECH DETECTED !!!!!!!!");
        }
    }

    @Override
    public void exitRecording(PlayRecordState from, PlayRecordState to, PlayRecordEvent event, PlayRecordContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Exited RECORDING state");
        }
        this.recorder.deactivate();
        this.recorder.removeListener(this.recorderListener);
    }

    @Override
    public void enterRecorded(PlayRecordState from, PlayRecordState to, PlayRecordEvent event, PlayRecordContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Entered RECORDED state");
        }
    }

    @Override
    public void enterCanceled(PlayRecordState from, PlayRecordState to, PlayRecordEvent event, PlayRecordContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Entered CANCELED state");
        }
        if (context.isSpeechDetected()) {
            this.fire((Object)PlayRecordEvent.SUCCEED, context);
        } else {
            context.setReturnCode(ReturnCode.NO_SPEECH.code());
            this.fire((Object)PlayRecordEvent.FAIL, context);
        }
    }

    @Override
    public void exitCanceled(PlayRecordState from, PlayRecordState to, PlayRecordEvent event, PlayRecordContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Exited CANCELED state");
        }
    }

    @Override
    public void enterSucceeding(PlayRecordState from, PlayRecordState to, PlayRecordEvent event, PlayRecordContext context) {
        Playlist playlist;
        if (log.isTraceEnabled()) {
            log.trace((Object)"Entered SUCCEEDING state");
        }
        if ((playlist = context.getSuccessAnnouncement()).isEmpty()) {
            this.fire((Object)PlayRecordEvent.NO_PROMPT, context);
        } else {
            this.fire((Object)PlayRecordEvent.PROMPT, context);
        }
    }

    @Override
    public void exitSucceeding(PlayRecordState from, PlayRecordState to, PlayRecordEvent event, PlayRecordContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Exited SUCCEEDING state");
        }
    }

    @Override
    public void enterPlayingSuccess(PlayRecordState from, PlayRecordState to, PlayRecordEvent event, PlayRecordContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Entered PLAYING SUCCESS state");
        }
        Playlist prompt = context.getSuccessAnnouncement();
        try {
            this.player.addListener(this.playerListener);
            this.playAnnouncement(prompt.next(), 0L);
        }
        catch (TooManyListenersException e) {
            log.error((Object)"Too many player listeners", (Throwable)e);
            context.setReturnCode(ReturnCode.UNSPECIFIED_FAILURE.code());
            this.fire((Object)PlayRecordEvent.FAIL, context);
        }
    }

    @Override
    public void onPlayingSuccess(PlayRecordState from, PlayRecordState to, PlayRecordEvent event, PlayRecordContext context) {
        Playlist prompt;
        String next;
        if (log.isTraceEnabled()) {
            log.trace((Object)"On PLAYING SUCCESS state");
        }
        if ((next = (prompt = context.getSuccessAnnouncement()).next()).isEmpty()) {
            this.fire((Object)PlayRecordEvent.PROMPT_END, context);
        } else {
            this.playAnnouncement(next, 1000L);
        }
    }

    @Override
    public void exitPlayingSuccess(PlayRecordState from, PlayRecordState to, PlayRecordEvent event, PlayRecordContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Exited PLAYING SUCCESS state");
        }
        this.player.removeListener(this.playerListener);
        this.player.deactivate();
    }

    @Override
    public void enterSucceeded(PlayRecordState from, PlayRecordState to, PlayRecordEvent event, PlayRecordContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Entered SUCCEEDED state");
        }
        OperationComplete oc = new OperationComplete("pr", ReturnCode.SUCCESS.code());
        oc.setParameter("na", String.valueOf(context.getAttempt()));
        oc.setParameter("vi", Boolean.FALSE.toString());
        oc.setParameter("ri", context.getRecordId());
        this.mgcpEventSubject.notify(this.mgcpEventSubject, oc);
    }

    @Override
    public void enterFailing(PlayRecordState from, PlayRecordState to, PlayRecordEvent event, PlayRecordContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Entered FAILING state");
        }
        if (context.hasMoreAttempts()) {
            context.newAttempt();
            this.deleteRecording();
            this.fire((Object)event, context);
        } else {
            switch (event) {
                case MAX_DURATION_EXCEEDED: {
                    context.setReturnCode(ReturnCode.SPOKE_TOO_LONG.code());
                    break;
                }
                case NO_SPEECH: {
                    context.setReturnCode(ReturnCode.NO_SPEECH.code());
                    break;
                }
                case RESTART: 
                case REINPUT: {
                    context.setReturnCode(ReturnCode.MAX_ATTEMPTS_EXCEEDED.code());
                    break;
                }
                default: {
                    context.setReturnCode(ReturnCode.UNSPECIFIED_FAILURE.code());
                }
            }
            Playlist playlist = context.getFailureAnnouncement();
            if (playlist.isEmpty()) {
                this.fire((Object)PlayRecordEvent.NO_PROMPT, context);
            } else {
                this.fire((Object)PlayRecordEvent.PROMPT, context);
            }
        }
    }

    @Override
    public void exitFailing(PlayRecordState from, PlayRecordState to, PlayRecordEvent event, PlayRecordContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Exited FAILING state");
        }
    }

    @Override
    public void enterPlayingFailure(PlayRecordState from, PlayRecordState to, PlayRecordEvent event, PlayRecordContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Entered PLAYING FAILURE state");
        }
        Playlist prompt = context.getFailureAnnouncement();
        try {
            this.player.addListener(this.playerListener);
            this.playAnnouncement(prompt.next(), 0L);
        }
        catch (TooManyListenersException e) {
            log.error((Object)"Too many player listeners", (Throwable)e);
            context.setReturnCode(ReturnCode.UNSPECIFIED_FAILURE.code());
            this.fire((Object)PlayRecordEvent.FAIL, context);
        }
    }

    @Override
    public void onPlayingFailure(PlayRecordState from, PlayRecordState to, PlayRecordEvent event, PlayRecordContext context) {
        Playlist prompt;
        String next;
        if (log.isTraceEnabled()) {
            log.trace((Object)"On PLAYING FAILURE state");
        }
        if ((next = (prompt = context.getFailureAnnouncement()).next()).isEmpty()) {
            this.fire((Object)PlayRecordEvent.PROMPT_END, context);
        } else {
            this.playAnnouncement(next, 1000L);
        }
    }

    @Override
    public void exitPlayingFailure(PlayRecordState from, PlayRecordState to, PlayRecordEvent event, PlayRecordContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Exited PLAYING FAILURE state");
        }
        this.player.removeListener(this.playerListener);
        this.player.deactivate();
    }

    @Override
    public void enterFailed(PlayRecordState from, PlayRecordState to, PlayRecordEvent event, PlayRecordContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Entered FAILED state");
        }
        OperationFailed of = new OperationFailed("pr", context.getReturnCode());
        of.setParameter("na", String.valueOf(context.getAttempt()));
        this.mgcpEventSubject.notify(this.mgcpEventSubject, of);
    }
}

