/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.control.mgcp.util.collections;

import com.google.common.base.Function;

public class ValueTransformers {
    public static final Function<String, Integer> STRING_TO_INTEGER = new IntegerTransformer();
    public static final Function<String, Integer> STRING_TO_INTEGER_BASE16 = new IntegerBase16Transformer();
    public static final Function<String, Long> STRING_TO_LONG = new LongTransformer();
    public static final Function<String, Boolean> STRING_TO_BOOLEAN = new BooleanTransformer();

    private ValueTransformers() {
    }

    private static final class BooleanTransformer
    implements Function<String, Boolean> {
        private BooleanTransformer() {
        }

        public Boolean apply(String input) {
            if (input == null || input.isEmpty()) {
                return null;
            }
            return Boolean.parseBoolean(input);
        }
    }

    private static final class LongTransformer
    implements Function<String, Long> {
        private LongTransformer() {
        }

        public Long apply(String input) {
            if (input == null || input.isEmpty()) {
                return null;
            }
            try {
                return Long.parseLong(input);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    }

    private static final class IntegerBase16Transformer
    implements Function<String, Integer> {
        private IntegerBase16Transformer() {
        }

        public Integer apply(String input) {
            if (input == null || input.isEmpty()) {
                return null;
            }
            try {
                return Integer.parseInt(input, 16);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    }

    private static final class IntegerTransformer
    implements Function<String, Integer> {
        private IntegerTransformer() {
        }

        public Integer apply(String input) {
            if (input == null || input.isEmpty()) {
                return null;
            }
            try {
                return Integer.parseInt(input);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    }
}

