/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.control.mgcp.endpoint.provider;

import java.util.concurrent.atomic.AtomicInteger;
import org.restcomm.media.control.mgcp.endpoint.MgcpEndpoint;
import org.restcomm.media.control.mgcp.endpoint.provider.MgcpEndpointProvider;

public abstract class AbstractMgcpEndpointProvider<T extends MgcpEndpoint>
implements MgcpEndpointProvider<T> {
    private final String namespace;
    private final String domain;
    private final AtomicInteger idGenerator;

    public AbstractMgcpEndpointProvider(String namespace, String domain) {
        this.namespace = namespace;
        this.domain = domain;
        this.idGenerator = new AtomicInteger(0);
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    protected String generateId() {
        return this.namespace + this.nextId();
    }

    private int nextId() {
        this.idGenerator.compareAndSet(Integer.MAX_VALUE, 0);
        return this.idGenerator.incrementAndGet();
    }
}

