/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.control.mgcp.exception;

import org.restcomm.media.control.mgcp.exception.MalformedMgcpEventRequestException;
import org.restcomm.media.control.mgcp.exception.MgcpEventNotFoundException;
import org.restcomm.media.control.mgcp.exception.MgcpPackageNotFoundException;
import org.restcomm.media.control.mgcp.pkg.MgcpEvent;
import org.restcomm.media.control.mgcp.pkg.MgcpEventProvider;
import org.restcomm.media.control.mgcp.pkg.MgcpPackage;
import org.restcomm.media.control.mgcp.pkg.MgcpRequestedEvent;

public abstract class AbstractSubMgcpEventProvider
implements MgcpEventProvider {
    private final MgcpPackage pkg;

    public AbstractSubMgcpEventProvider(MgcpPackage pkg) {
        this.pkg = pkg;
    }

    @Override
    public MgcpEvent provide(MgcpRequestedEvent requestedEvent) throws MgcpPackageNotFoundException, MgcpEventNotFoundException, MalformedMgcpEventRequestException {
        String requestedPkg = requestedEvent.getPackageName();
        if (!this.pkg.getPackageName().equalsIgnoreCase(requestedPkg)) {
            throw new MgcpPackageNotFoundException("Event request " + requestedEvent.getQualifiedName() + " wrongly targeted package " + this.pkg.getPackageName());
        }
        String eventType = requestedEvent.getEventType();
        boolean supported = this.pkg.isEventSupported(eventType);
        if (!supported) {
            throw new MgcpEventNotFoundException("Package " + requestedPkg + " does not support event " + eventType);
        }
        return this.parse(requestedEvent);
    }

    protected abstract MgcpEvent parse(MgcpRequestedEvent var1) throws MalformedMgcpEventRequestException;
}

