/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.control.mgcp.message;

import org.restcomm.media.control.mgcp.exception.MgcpParseException;
import org.restcomm.media.control.mgcp.message.LocalConnectionOptionsParser;
import org.restcomm.media.control.mgcp.message.MgcpMessage;
import org.restcomm.media.control.mgcp.message.MgcpParameterType;
import org.restcomm.media.control.mgcp.message.MgcpRequest;
import org.restcomm.media.control.mgcp.message.MgcpRequestType;
import org.restcomm.media.control.mgcp.message.MgcpResponse;

public class MgcpMessageParser {
    private final LocalConnectionOptionsParser optionsParser = new LocalConnectionOptionsParser();

    public MgcpRequest parseRequest(byte[] data, int offset, int length) throws MgcpParseException {
        return this.parseRequest(new String(data, offset, length));
    }

    public MgcpRequest parseRequest(String message) throws MgcpParseException {
        try {
            MgcpRequest request = new MgcpRequest();
            this.parseMgcpRequest(message, request);
            return request;
        }
        catch (Exception e) {
            throw new MgcpParseException("Could not parse MGCP request.", e);
        }
    }

    private void parseMgcpRequest(String message, MgcpRequest request) throws Exception {
        String[] lines = message.split(System.lineSeparator());
        String header = lines[0];
        String[] headerParams = header.split(" ");
        String command = headerParams[0];
        MgcpRequestType requestType = MgcpRequestType.valueOf(command.toUpperCase());
        request.setRequestType(requestType);
        String transactionId = headerParams[1];
        request.setTransactionId(Integer.parseInt(transactionId));
        String endpointId = headerParams[2];
        request.setEndpointId(endpointId);
        this.parseParametersAndSdp(lines, request);
        String lcOptions = request.getParameter(MgcpParameterType.LOCAL_CONNECTION_OPTIONS);
        if (lcOptions != null) {
            this.optionsParser.parse(lcOptions);
        }
    }

    public MgcpResponse parseResponse(byte[] data, int offset, int length) throws MgcpParseException {
        return this.parseResponse(new String(data, offset, length));
    }

    public MgcpResponse parseResponse(String message) throws MgcpParseException {
        MgcpResponse response = new MgcpResponse();
        try {
            this.parseResponse(message, response);
        }
        catch (Exception e) {
            throw new MgcpParseException("Could not parse MGCP response", e);
        }
        return response;
    }

    private void parseResponse(String message, MgcpResponse response) throws Exception {
        String[] lines = message.split(System.lineSeparator());
        String header = lines[0];
        int codeSeparator = header.indexOf(" ");
        String returnCode = header.substring(0, codeSeparator);
        response.setCode(Integer.parseInt(returnCode));
        int transactionIdSeparator = header.indexOf(" ", codeSeparator + 1);
        String transactionId = header.substring(codeSeparator + 1, transactionIdSeparator);
        response.setTransactionId(Integer.parseInt(transactionId));
        String returnMessage = header.substring(transactionIdSeparator + 1);
        response.setMessage(returnMessage);
        this.parseParametersAndSdp(lines, response);
    }

    private void parseParametersAndSdp(String[] lines, MgcpMessage message) throws Exception {
        StringBuilder sdpBuilder = new StringBuilder();
        boolean sdp = false;
        int nLines = lines.length;
        for (int i = 1; i < nLines; ++i) {
            String line = lines[i];
            if (sdp) {
                sdpBuilder.append(line);
                if (i >= nLines - 1) continue;
                sdpBuilder.append(System.lineSeparator());
                continue;
            }
            if (line.isEmpty()) {
                sdp = true;
                continue;
            }
            int separatorIndex = line.indexOf(":");
            MgcpParameterType type = MgcpParameterType.fromCode(line.substring(0, separatorIndex));
            message.addParameter(type, line.substring(separatorIndex + 1).trim());
        }
        if (sdp) {
            message.addParameter(MgcpParameterType.SDP, sdpBuilder.toString());
        }
    }
}

