/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.control.mgcp.pkg.au.pc;

import com.google.common.base.Optional;
import java.util.Map;
import org.restcomm.media.control.mgcp.pkg.au.Playlist;
import org.restcomm.media.control.mgcp.pkg.au.SignalParameters;
import org.restcomm.media.spi.dtmf.DtmfDetector;
import org.restcomm.media.spi.dtmf.DtmfDetectorListener;

public class PlayCollectContext {
    private final Map<String, String> parameters;
    private final Playlist initialPrompt;
    private final Playlist reprompt;
    private final Playlist noDigitsReprompt;
    private final Playlist failureAnnouncement;
    private final Playlist successAnnouncement;
    private final StringBuilder collectedDigits;
    private long lastCollectedDigitOn;
    private char lastTone;
    private int attempt;
    private int returnCode;

    public PlayCollectContext(DtmfDetector detector, DtmfDetectorListener detectorListener, Map<String, String> parameters) {
        this.parameters = parameters;
        this.initialPrompt = new Playlist(this.getInitialPromptSegments(), 1);
        this.reprompt = new Playlist(this.getRepromptSegments(), 1);
        this.noDigitsReprompt = new Playlist(this.getNoDigitsRepromptSegments(), 1);
        this.failureAnnouncement = new Playlist(this.getFailureAnnouncementSegments(), 1);
        this.successAnnouncement = new Playlist(this.getSuccessAnnouncementSegments(), 1);
        this.collectedDigits = new StringBuilder("");
        this.lastCollectedDigitOn = 0L;
        this.lastTone = (char)32;
        this.returnCode = 0;
        this.attempt = 1;
    }

    private String getParameter(String name) {
        return this.parameters.get(name);
    }

    private String[] getInitialPromptSegments() {
        String value = (String)Optional.fromNullable((Object)this.getParameter(SignalParameters.INITIAL_PROMPT.symbol())).or((Object)"");
        return value.isEmpty() ? new String[]{} : value.split(",");
    }

    public Playlist getInitialPrompt() {
        return this.initialPrompt;
    }

    private String[] getRepromptSegments() {
        String segments = (String)Optional.fromNullable((Object)this.getParameter(SignalParameters.REPROMPT.symbol())).or((Object)"");
        return segments.isEmpty() ? this.getInitialPromptSegments() : segments.split(",");
    }

    public Playlist getReprompt() {
        return this.reprompt;
    }

    private String[] getNoDigitsRepromptSegments() {
        String segments = (String)Optional.fromNullable((Object)this.getParameter(SignalParameters.NO_DIGITS_REPROMPT.symbol())).or((Object)"");
        return segments.isEmpty() ? this.getRepromptSegments() : segments.split(",");
    }

    public Playlist getNoDigitsReprompt() {
        return this.noDigitsReprompt;
    }

    private String[] getFailureAnnouncementSegments() {
        String value = (String)Optional.fromNullable((Object)this.getParameter(SignalParameters.FAILURE_ANNOUNCEMENT.symbol())).or((Object)"");
        return value.isEmpty() ? new String[]{} : value.split(",");
    }

    public Playlist getFailureAnnouncement() {
        return this.failureAnnouncement;
    }

    public boolean hasFailureAnnouncement() {
        return !this.failureAnnouncement.isEmpty();
    }

    private String[] getSuccessAnnouncementSegments() {
        String value = (String)Optional.fromNullable((Object)this.getParameter(SignalParameters.SUCCESS_ANNOUNCEMENT.symbol())).or((Object)"");
        return value.isEmpty() ? new String[]{} : value.split(",");
    }

    public Playlist getSuccessAnnouncement() {
        return this.successAnnouncement;
    }

    public boolean hasSuccessAnnouncement() {
        return !this.successAnnouncement.isEmpty();
    }

    public boolean getNonInterruptibleAudio() {
        String value = (String)Optional.fromNullable((Object)this.getParameter(SignalParameters.NON_INTERRUPTIBLE_PLAY.symbol())).or((Object)"false");
        return Boolean.parseBoolean(value);
    }

    public boolean getClearDigitBuffer() {
        String value = (String)Optional.fromNullable((Object)this.getParameter(SignalParameters.CLEAR_DIGIT_BUFFER.symbol())).or((Object)"false");
        return Boolean.parseBoolean(value);
    }

    public int getMinimumDigits() {
        String value = (String)Optional.fromNullable((Object)this.getParameter(SignalParameters.MINIMUM_NUM_DIGITS.symbol())).or((Object)"1");
        return Integer.parseInt(value);
    }

    public int getMaximumDigits() {
        String value = (String)Optional.fromNullable((Object)this.getParameter(SignalParameters.MAXIMUM_NUM_DIGITS.symbol())).or((Object)"1");
        return Integer.parseInt(value);
    }

    public String getDigitPattern() {
        String pattern = (String)Optional.fromNullable((Object)this.getParameter(SignalParameters.DIGIT_PATTERN.symbol())).or((Object)"");
        if (!pattern.isEmpty()) {
            pattern = pattern.replace(".", "*").replace("x", "\\d");
        }
        return pattern;
    }

    public boolean hasDigitPattern() {
        return !((String)Optional.fromNullable((Object)this.getParameter(SignalParameters.DIGIT_PATTERN.symbol())).or((Object)"")).isEmpty();
    }

    public int getFirstDigitTimer() {
        String value = (String)Optional.fromNullable((Object)this.getParameter(SignalParameters.FIRST_DIGIT_TIMER.symbol())).or((Object)"50");
        return Integer.parseInt(value) * 100;
    }

    public int getInterDigitTimer() {
        String value = (String)Optional.fromNullable((Object)this.getParameter(SignalParameters.INTER_DIGIT_TIMER.symbol())).or((Object)"30");
        return Integer.parseInt(value) * 100;
    }

    public int getExtraDigitTimer() {
        String value = (String)Optional.fromNullable((Object)this.getParameter(SignalParameters.EXTRA_DIGIT_TIMER.symbol())).or((Object)"");
        return Integer.parseInt(value) * 100;
    }

    public char getRestartKey() {
        String value = (String)Optional.fromNullable((Object)this.getParameter(SignalParameters.RESTART_KEY.symbol())).or((Object)"");
        return value.isEmpty() ? (char)' ' : value.charAt(0);
    }

    public char getReinputKey() {
        String value = (String)Optional.fromNullable((Object)this.getParameter(SignalParameters.REINPUT_KEY.symbol())).or((Object)"");
        return value.isEmpty() ? (char)' ' : value.charAt(0);
    }

    public char getReturnKey() {
        String value = (String)Optional.fromNullable((Object)this.getParameter(SignalParameters.RETURN_KEY.symbol())).or((Object)"");
        return value.isEmpty() ? (char)' ' : value.charAt(0);
    }

    public char getPositionKey() {
        String value = (String)Optional.fromNullable((Object)this.getParameter(SignalParameters.POSITION_KEY.symbol())).or((Object)"");
        return value.isEmpty() ? (char)' ' : value.charAt(0);
    }

    public char getStopKey() {
        String value = (String)Optional.fromNullable((Object)this.getParameter(SignalParameters.STOP_KEY.symbol())).or((Object)"");
        return value.isEmpty() ? (char)' ' : value.charAt(0);
    }

    public String getStartInputKeys() {
        return (String)Optional.fromNullable((Object)this.getParameter(SignalParameters.START_INPUT_KEY.symbol())).or((Object)"0123456789");
    }

    public char getEndInputKey() {
        String value = (String)Optional.fromNullable((Object)this.getParameter(SignalParameters.END_INPUT_KEY.symbol())).or((Object)"");
        return value.isEmpty() ? (char)'#' : value.charAt(0);
    }

    public boolean getIncludeEndInputKey() {
        String value = (String)Optional.fromNullable((Object)this.getParameter(SignalParameters.INCLUDE_END_INPUT_KEY.symbol())).or((Object)"false");
        return Boolean.parseBoolean(value);
    }

    public int getNumberOfAttempts() {
        String value = (String)Optional.fromNullable((Object)this.getParameter(SignalParameters.NUMBER_OF_ATTEMPTS.symbol())).or((Object)"1");
        return Integer.parseInt(value);
    }

    public void collectDigit(char digit) {
        this.collectedDigits.append(digit);
        this.lastCollectedDigitOn = System.currentTimeMillis();
    }

    public void clearCollectedDigits() {
        this.collectedDigits.setLength(0);
    }

    public String getCollectedDigits() {
        return this.collectedDigits.toString();
    }

    public int countCollectedDigits() {
        return this.collectedDigits.length();
    }

    public long getLastCollectedDigitOn() {
        return this.lastCollectedDigitOn;
    }

    public char getLastTone() {
        return this.lastTone;
    }

    public void setLastTone(char lastTone) {
        this.lastTone = lastTone;
    }

    public int getAttempt() {
        return this.attempt;
    }

    public boolean hasMoreAttempts() {
        return this.attempt < this.getNumberOfAttempts();
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    protected void setReturnCode(int returnCode) {
        this.returnCode = returnCode;
    }

    protected void newAttempt() {
        ++this.attempt;
        this.collectedDigits.setLength(0);
        this.lastTone = (char)32;
        this.initialPrompt.rewind();
        this.reprompt.rewind();
        this.noDigitsReprompt.rewind();
        this.successAnnouncement.rewind();
        this.failureAnnouncement.rewind();
    }
}

