/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.control.mgcp.pkg.r;

import org.restcomm.media.control.mgcp.pkg.MgcpEventType;

public enum RtpEventType implements MgcpEventType
{
    ICMP_UNREACHABLE("iu", true),
    JITTER_BUFFER_SIZE_CHANGED("ji", true),
    MEDIA_START("ma"),
    OPERATION_COMPLETE("oc"),
    OPERATION_FAILED("of"),
    PACKET_LOSS_EXCEEDED("pl", true),
    QUALITY_ALERT("qa"),
    RTP_TIMEOUT("rto", true),
    SAMPLING_RATE_CHANGED("sr"),
    USED_CODEC_CHANGED("uc");

    private final String symbol;
    private final boolean parameterized;

    private RtpEventType(String symbol, boolean parameterized) {
        this.symbol = symbol;
        this.parameterized = parameterized;
    }

    private RtpEventType(String symbol) {
        this(symbol, false);
    }

    @Override
    public String symbol() {
        return this.symbol;
    }

    @Override
    public boolean parameterized() {
        return this.parameterized;
    }

    public static final RtpEventType fromSymbol(String symbol) {
        if (symbol != null && !symbol.isEmpty()) {
            for (RtpEventType eventType : RtpEventType.values()) {
                if (!eventType.symbol.equalsIgnoreCase(symbol)) continue;
                return eventType;
            }
        }
        return null;
    }
}

