/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.control.mgcp.pkg.r.rto;

import org.restcomm.media.control.mgcp.pkg.GenericMgcpEvent;
import org.restcomm.media.control.mgcp.pkg.r.rto.RtpTimeoutStartTime;

public class RtpTimeoutEvent
extends GenericMgcpEvent {
    public static final String SYMBOL = "rto";
    public static final String TIMEOUT_KEY = "to";
    public static final String START_TIME_KEY = "st";

    public RtpTimeoutEvent(int connectionId, int timeout) {
        this(connectionId, timeout, RtpTimeoutStartTime.IMMEDIATE);
    }

    public RtpTimeoutEvent(int connectionId, int timeout, RtpTimeoutStartTime startTime) {
        super("R", SYMBOL, connectionId);
        this.setParameter(TIMEOUT_KEY, String.valueOf(timeout));
        this.setParameter(START_TIME_KEY, startTime.symbol());
    }

    public int getTimeout() {
        String timeout = this.getParameter(TIMEOUT_KEY);
        if (timeout == null || timeout.isEmpty()) {
            return 0;
        }
        return Integer.parseInt(timeout);
    }

    public RtpTimeoutStartTime getWhen() {
        String when = this.getParameter(START_TIME_KEY);
        if (when == null || when.isEmpty()) {
            return RtpTimeoutStartTime.IMMEDIATE;
        }
        return RtpTimeoutStartTime.fromSymbol(when);
    }

    @Override
    public String toString() {
        this.builder.setLength(0);
        this.builder.append(this.pkg).append("/").append(this.symbol);
        this.builder.append("@").append(Integer.toHexString(this.connectionId));
        this.builder.append("(").append(this.getTimeout()).append(")");
        return this.builder.toString();
    }
}

