/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.control.mgcp.connection;

import com.google.common.collect.Sets;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.restcomm.media.component.audio.AudioComponent;
import org.restcomm.media.component.oob.OOBComponent;
import org.restcomm.media.control.mgcp.connection.MgcpConnection;
import org.restcomm.media.control.mgcp.connection.MgcpConnectionState;
import org.restcomm.media.control.mgcp.exception.MalformedMgcpEventRequestException;
import org.restcomm.media.control.mgcp.exception.MgcpEventNotFoundException;
import org.restcomm.media.control.mgcp.exception.MgcpPackageNotFoundException;
import org.restcomm.media.control.mgcp.exception.UnsupportedMgcpEventException;
import org.restcomm.media.control.mgcp.pkg.MgcpEvent;
import org.restcomm.media.control.mgcp.pkg.MgcpEventObserver;
import org.restcomm.media.control.mgcp.pkg.MgcpEventProvider;
import org.restcomm.media.control.mgcp.pkg.MgcpRequestedEvent;
import org.restcomm.media.control.mgcp.pkg.r.rto.RtpTimeoutEvent;
import org.restcomm.media.spi.ConnectionMode;

public abstract class AbstractMgcpConnection
implements MgcpConnection {
    private final int identifier;
    private final int callIdentifier;
    private ConnectionMode mode;
    protected volatile MgcpConnectionState state;
    protected final Object stateLock;
    private final MgcpEventProvider eventProvider;
    protected final Set<MgcpEventObserver> observers;
    protected final ListeningScheduledExecutorService executor;
    protected static final int HALF_OPEN_TIMER = 30;
    protected ListenableFuture<Integer> timerFuture;
    protected final int timeout;
    protected final int halfOpenTimeout;

    public AbstractMgcpConnection(int identifier, int callId, int halfOpenTimeout, int openTimeout, MgcpEventProvider eventProvider, ListeningScheduledExecutorService executor) {
        this.identifier = identifier;
        this.callIdentifier = callId;
        this.mode = ConnectionMode.INACTIVE;
        this.state = MgcpConnectionState.CLOSED;
        this.stateLock = new Object();
        this.eventProvider = eventProvider;
        this.observers = Sets.newConcurrentHashSet();
        this.executor = executor;
        this.timerFuture = null;
        this.halfOpenTimeout = halfOpenTimeout;
        this.timeout = openTimeout;
    }

    @Override
    public int getIdentifier() {
        return this.identifier;
    }

    @Override
    public String getHexIdentifier() {
        return Integer.toHexString(this.identifier).toUpperCase();
    }

    @Override
    public int getCallIdentifier() {
        return this.callIdentifier;
    }

    @Override
    public String getCallIdentifierHex() {
        return Integer.toHexString(this.callIdentifier).toUpperCase();
    }

    @Override
    public ConnectionMode getMode() {
        return this.mode;
    }

    @Override
    public MgcpConnectionState getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMode(ConnectionMode mode) throws IllegalStateException {
        Object object = this.stateLock;
        synchronized (object) {
            if (MgcpConnectionState.CLOSED.equals((Object)this.state)) {
                throw new IllegalStateException("Cannot update mode because connection is closed.");
            }
        }
        this.mode = mode;
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("Connection " + this.getHexIdentifier() + " mode is " + mode.name()));
        }
    }

    @Override
    public void listen(MgcpRequestedEvent event) throws UnsupportedMgcpEventException {
        if (this.isEventSupported(event)) {
            try {
                MgcpEvent mgcpEvent = this.eventProvider.provide(event);
                this.listen(mgcpEvent);
            }
            catch (MalformedMgcpEventRequestException | MgcpEventNotFoundException | MgcpPackageNotFoundException e) {
                throw new UnsupportedMgcpEventException("MGCP Event " + event.toString() + " is not supported.", e);
            }
        } else {
            throw new UnsupportedMgcpEventException("Connection " + this.getCallIdentifierHex() + " does not support event " + event.getQualifiedName());
        }
    }

    protected abstract boolean isEventSupported(MgcpRequestedEvent var1);

    protected abstract void listen(MgcpEvent var1) throws UnsupportedMgcpEventException;

    @Override
    public abstract AudioComponent getAudioComponent();

    @Override
    public abstract OOBComponent getOutOfBandComponent();

    @Override
    public void observe(MgcpEventObserver observer) {
        boolean added = this.observers.add(observer);
        if (added && this.log().isTraceEnabled()) {
            this.log().trace((Object)("Connection " + this.getHexIdentifier() + " registered MgcpEventObserver@" + observer.hashCode() + ". Count: " + this.observers.size()));
        }
    }

    @Override
    public void forget(MgcpEventObserver observer) {
        boolean removed = this.observers.remove(observer);
        if (removed && this.log().isTraceEnabled()) {
            this.log().trace((Object)("Connection " + this.getHexIdentifier() + " unregistered MgcpEventObserver@" + observer.hashCode() + ". Count: " + this.observers.size()));
        }
    }

    @Override
    public void notify(Object originator, MgcpEvent event) {
        for (MgcpEventObserver observer : this.observers) {
            if (observer == originator) continue;
            observer.onEvent(originator, event);
        }
    }

    protected abstract Logger log();

    protected void expireIn(int timeout) {
        if (this.timerFuture != null && !this.timerFuture.isCancelled()) {
            this.timerFuture.cancel(false);
        }
        this.timerFuture = this.executor.schedule((Callable)new MgcpConnectionTimer(timeout), (long)timeout, TimeUnit.SECONDS);
        Futures.addCallback(this.timerFuture, (FutureCallback)new MgcpConnectionTimerCallback(), (Executor)this.executor);
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("Connection " + this.getHexIdentifier() + " set to expire in " + timeout + " seconds"));
        }
    }

    final class MgcpConnectionTimerCallback
    implements FutureCallback<Integer> {
        MgcpConnectionTimerCallback() {
        }

        public void onSuccess(Integer result) {
            if (AbstractMgcpConnection.this.log().isInfoEnabled()) {
                AbstractMgcpConnection.this.log().info((Object)("Connection " + AbstractMgcpConnection.this.getHexIdentifier() + " timed out after " + result + " seconds"));
            }
            if (!MgcpConnectionState.CLOSED.equals((Object)AbstractMgcpConnection.this.state)) {
                try {
                    AbstractMgcpConnection.this.close();
                }
                catch (Exception e) {
                    AbstractMgcpConnection.this.log().warn((Object)("Could not close connection " + AbstractMgcpConnection.this.getHexIdentifier() + " in elegant manner after timeout."));
                }
            }
        }

        public void onFailure(Throwable t) {
            if (AbstractMgcpConnection.this.log().isDebugEnabled()) {
                AbstractMgcpConnection.this.log().debug((Object)("Connection " + AbstractMgcpConnection.this.getHexIdentifier() + " life timer was canceled or failed."));
            }
        }
    }

    final class MgcpConnectionTimer
    implements Callable<Integer> {
        private final int timeout;

        public MgcpConnectionTimer(int timeout) {
            this.timeout = timeout;
        }

        @Override
        public Integer call() {
            AbstractMgcpConnection.this.notify(AbstractMgcpConnection.this, new RtpTimeoutEvent(AbstractMgcpConnection.this.getIdentifier(), this.timeout));
            return this.timeout;
        }
    }
}

