/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.control.mgcp.endpoint.provider;

import org.restcomm.media.component.audio.AudioMixer;
import org.restcomm.media.component.oob.OOBMixer;
import org.restcomm.media.control.mgcp.connection.MgcpConnectionProvider;
import org.restcomm.media.control.mgcp.endpoint.EndpointIdentifier;
import org.restcomm.media.control.mgcp.endpoint.MediaGroup;
import org.restcomm.media.control.mgcp.endpoint.MgcpMixerEndpoint;
import org.restcomm.media.control.mgcp.endpoint.provider.AbstractMgcpEndpointProvider;
import org.restcomm.media.control.mgcp.endpoint.provider.MediaGroupProvider;
import org.restcomm.media.scheduler.PriorityQueueScheduler;

public class MgcpMixerEndpointProvider
extends AbstractMgcpEndpointProvider<MgcpMixerEndpoint> {
    private final PriorityQueueScheduler mediaScheduler;
    private final MgcpConnectionProvider connectionProvider;
    private final MediaGroupProvider mediaGroupProvider;

    public MgcpMixerEndpointProvider(String namespace, String domain, PriorityQueueScheduler mediaScheduler, MgcpConnectionProvider connectionProvider, MediaGroupProvider mediaGroupProvider) {
        super(namespace, domain);
        this.mediaScheduler = mediaScheduler;
        this.connectionProvider = connectionProvider;
        this.mediaGroupProvider = mediaGroupProvider;
    }

    @Override
    public MgcpMixerEndpoint provide() {
        EndpointIdentifier endpointId = new EndpointIdentifier(this.generateId(), this.getDomain());
        AudioMixer audioMixer = new AudioMixer(this.mediaScheduler);
        OOBMixer oobMixer = new OOBMixer(this.mediaScheduler);
        MediaGroup mediaGroup = this.mediaGroupProvider.provide();
        return new MgcpMixerEndpoint(endpointId, audioMixer, oobMixer, this.connectionProvider, mediaGroup);
    }
}

